/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.FileNameUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.common.util.ConvertUtils;
import kd.hrmp.hric.common.util.HricCacheUtils;

public class AttachmentUtils {
    private static Log LOG = LogFactory.getLog(AttachmentUtils.class);
    private static String PATH = "path";
    private static String CONFIG_KEY = "configKey";

    public static boolean checkUrlExist(String url) {
        boolean isRealURL = false;
        if (url.contains(CONFIG_KEY)) {
            isRealURL = CacheFactory.getCommonCacheFactory().getTempFileCache().exists(url);
        } else if (url.contains(PATH)) {
            String pathURL = url.substring(url.indexOf("path=") + 5, url.length());
            isRealURL = FileServiceFactory.getAttachmentFileService().exists(pathURL);
        }
        return isRealURL;
    }

    public static InputStream getInputStream(String url) {
        InputStream is;
        if (url.contains(CONFIG_KEY)) {
            TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            is = tempFileCache.getInputStream(url);
        } else {
            if (url.contains(PATH)) {
                url = url.substring(url.indexOf("path=") + 5, url.length());
            }
            is = FileServiceFactory.getAttachmentFileService().getInputStream(url);
        }
        return is;
    }

    public static boolean handleStop(Map<String, Object> map) {
        String annexInitType = map.get("annexinittype").toString();
        Boolean isStop = false;
        try {
            isStop = Optional.ofNullable(HricCacheUtils.get(annexInitType, Boolean.class)).orElseGet(() -> false);
        }
        catch (Exception e) {
            LOG.error("Failed to retrieve data from cache:{}", (Object)annexInitType);
        }
        return isStop;
    }

    public static int getProgressValue(Map<String, Object> map, int count) {
        BigDecimal countBig = new BigDecimal(count);
        BigDecimal totalBig = new BigDecimal(ConvertUtils.toInteger(map.get("count")));
        if (totalBig.compareTo(new BigDecimal(0)) == 0) {
            return 100;
        }
        if (count == 0) {
            return count;
        }
        BigDecimal result = countBig.divide(totalBig, 2, 4).multiply(new BigDecimal(100));
        if (result.compareTo(new BigDecimal(100)) == 0 && totalBig.subtract(countBig).compareTo(new BigDecimal(0)) != 0) {
            return 99;
        }
        return result.intValue();
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> parseUrl(List<String> zipPathList, String entityId, Map<String, Object> nameAndNumberMap, String uniqueType) {
        LOG.info("AttachmentUtils parseUrl start entityId : {}, filePathList size {}, nameAndNumberMap size {}  ", new Object[]{entityId, zipPathList.size(), nameAndNumberMap.size()});
        FileService fs = HRStringUtils.equals((String)entityId, (String)"hric_contractinit") ? FileServiceFactory.getAttachmentFileService() : FileServiceFactory.getImageFileService();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        RequestContext requestContext = RequestContext.get();
        HashMap<String, String> resultMap = new HashMap<String, String>(AppConstants.MAP_SIZE);
        String name = "";
        for (String filePath : zipPathList) {
            ZipInputStream zipIn = null;
            InputStream bis = null;
            try {
                ZipEntry zipEntry;
                zipIn = new ZipInputStream(CacheFactory.getCommonCacheFactory().getTempFileCache().getInputStream(filePath), Charset.forName("GBK"));
                while ((zipEntry = zipIn.getNextEntry()) != null) {
                    int size;
                    if (zipEntry.isDirectory()) continue;
                    byte[] bytes = new byte[1024];
                    while ((size = zipIn.read(bytes)) != -1) {
                        bos.write(bytes, 0, size);
                    }
                    bos.flush();
                    bis = new ByteArrayInputStream(bos.toByteArray());
                    bos.reset();
                    StringBuilder stringBuilder = new StringBuilder();
                    String format = zipEntry.getName().substring(zipEntry.getName().lastIndexOf("."));
                    String fileName = zipEntry.getName().trim();
                    if (fileName.indexOf("/") > -1) {
                        fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
                    }
                    if (HRStringUtils.equals((String)entityId, (String)"hric_perheadpicinit")) {
                        if (HRStringUtils.equals((String)uniqueType, (String)"A")) {
                            name = fileName.substring(fileName.lastIndexOf("+") + 1, fileName.lastIndexOf("."));
                            fileName = fileName.substring(0, fileName.indexOf("+"));
                            stringBuilder.append(fileName).append(format);
                        } else {
                            stringBuilder.append(fileName);
                        }
                    } else if (HRStringUtils.equals((String)entityId, (String)"hric_contractinit")) {
                        if (HRStringUtils.equals((String)uniqueType, (String)"A")) {
                            name = fileName.substring(0, fileName.lastIndexOf("+"));
                        }
                        String contractNumber = fileName.substring(fileName.lastIndexOf("+") + 1);
                        stringBuilder.append(contractNumber);
                    }
                    String realFileName = stringBuilder.toString();
                    String number = realFileName.substring(0, realFileName.lastIndexOf("."));
                    String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (Object)"init", (String)realFileName);
                    if (fs.exists(pathParam)) {
                        LOG.info("file exists, generate new file path");
                        realFileName = String.join((CharSequence)"", ConvertUtils.toString(ID.genLongId()), realFileName);
                        pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (Object)"init", (String)realFileName);
                    }
                    FileItem file = new FileItem(realFileName, pathParam, bis);
                    if (nameAndNumberMap.containsKey(number)) {
                        if (HRStringUtils.isNotEmpty((String)ConvertUtils.toString(nameAndNumberMap.get(number))) && HRStringUtils.equals((String)name, (String)ConvertUtils.toString(nameAndNumberMap.get(number))) || HRStringUtils.equals((String)uniqueType, (String)"B")) {
                            LOG.info("start file upload, realFileName= {}, pathParam = {}", (Object)realFileName, (Object)pathParam);
                            String fileId = fs.upload(file);
                            LOG.info("upload file success, fileId={}", (Object)fileId);
                            resultMap.put(number, pathParam);
                        } else {
                            resultMap.put(number, "false");
                        }
                    }
                    bis.close();
                }
                zipIn.close();
            }
            catch (Exception e) {
                LOG.error("AttachmentUtils parseUrl method has error : ", (Object)e.getMessage());
                break;
            }
            finally {
                try {
                    if (null != zipIn) {
                        zipIn.close();
                    }
                    if (null != bis) {
                        bis.close();
                    }
                    bos.close();
                }
                catch (IOException ioException) {
                    LOG.error("AttachmentUtils parseUrl method has error : ", (Object)ioException.getMessage());
                }
            }
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> analyzeZip(Map<String, String> zipMap) {
        HashMap<String, String> map = new HashMap<String, String>(AppConstants.MAP_SIZE);
        for (Map.Entry<String, String> entry : zipMap.entrySet()) {
            ZipInputStream zipIn = null;
            try {
                ZipEntry zipEntry;
                zipIn = new ZipInputStream(CacheFactory.getCommonCacheFactory().getTempFileCache().getInputStream(entry.getKey()), Charset.forName("GBK"));
                while ((zipEntry = zipIn.getNextEntry()) != null) {
                    if (zipEntry.isDirectory()) continue;
                    map.put(zipEntry.getName(), entry.getValue());
                }
            }
            catch (Exception e) {
                LOG.error("AttachmentUtils analyzeZip method has error : ", (Object)e.getMessage());
                HashMap<String, String> hashMap = new HashMap<String, String>(AppConstants.MAP_SIZE);
                return hashMap;
            }
            finally {
                try {
                    if (null == zipIn) continue;
                    zipIn.close();
                }
                catch (IOException ioException) {
                    LOG.error("AttachmentUtils analyzeZip method has error : ", (Object)ioException.getMessage());
                }
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getIdsByZip(Map<String, String> zipMap, String entityCode, String uniqueType) {
        ArrayList<String> numberList = new ArrayList<String>(AppConstants.LIST_SIZE);
        for (Map.Entry<String, String> entry : zipMap.entrySet()) {
            ZipInputStream zipIn = null;
            try {
                ZipEntry zipEntry;
                zipIn = new ZipInputStream(CacheFactory.getCommonCacheFactory().getTempFileCache().getInputStream(entry.getKey()), Charset.forName("GBK"));
                while ((zipEntry = zipIn.getNextEntry()) != null) {
                    if (zipEntry.isDirectory()) continue;
                    String fileName = zipEntry.getName().trim();
                    if (fileName.indexOf("/") > -1) {
                        fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
                    }
                    if (HRStringUtils.equals((String)entityCode, (String)"hric_perheadpicinit")) {
                        fileName = HRStringUtils.equals((String)uniqueType, (String)"A") ? fileName.substring(0, fileName.indexOf("+")) : fileName.substring(0, fileName.lastIndexOf("."));
                    } else if (HRStringUtils.equals((String)entityCode, (String)"hric_contractinit")) {
                        fileName = fileName.substring(fileName.lastIndexOf("+") + 1, fileName.lastIndexOf("."));
                    }
                    numberList.add(fileName);
                }
            }
            catch (Exception e) {
                LOG.error("AttachmentUtils getIdsByZip method has error : ", (Throwable)e);
                ArrayList<String> arrayList = new ArrayList<String>(AppConstants.LIST_SIZE);
                return arrayList;
            }
            finally {
                try {
                    if (null == zipIn) continue;
                    zipIn.close();
                }
                catch (IOException ioException) {
                    LOG.error("AttachmentUtils getIdsByZip method has error : ", (Object)ioException.getMessage());
                }
            }
        }
        return numberList;
    }

    public static Map<String, Map<String, String>> analyzeFileMap(Map<String, String> errorFileNumberMap, Map<String, String> fileNameMap) {
        HashMap<String, Map<String, String>> errorDataMap = new HashMap<String, Map<String, String>>(AppConstants.MAP_SIZE);
        block0: for (Map.Entry<String, String> entry : errorFileNumberMap.entrySet()) {
            for (Map.Entry<String, String> fileNameEntry : fileNameMap.entrySet()) {
                if (fileNameEntry.getKey().indexOf(entry.getKey()) <= -1) continue;
                HashMap<String, String> map = new HashMap<String, String>(1);
                map.put(fileNameEntry.getValue(), entry.getValue());
                errorDataMap.put(fileNameEntry.getKey(), map);
                continue block0;
            }
        }
        return errorDataMap;
    }
}

