/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.common.util;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.hrmp.hric.common.util.ConvertUtils;

public class ControlUtils {
    public static List<ValueMapItem> getAllValueMapItemPropList(String entityNumber, String field) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        ComboProp comboProp = (ComboProp)ConvertUtils.convert(mainType.findProperty(field));
        return comboProp.getComboItems();
    }

    public static Set<String> getComboValueSet(IDataEntityProperty property) {
        if (property instanceof ComboProp) {
            return ((ComboProp)property).getComboItems().stream().map(item -> item.getValue()).collect(Collectors.toSet());
        }
        return Sets.newHashSetWithExpectedSize((int)16);
    }

    public static List<EntityItem<?>> getAllEntityItems(String number) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)number);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainType.getName(), (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        return entityMetadata.getItems();
    }
}

