/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.common.util;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class ConvertUtils {
    private static final String[] FALSE_ARR = new String[]{"false", "0", "no", "off", "n", "f", "undefined", "disable"};
    private static final String[] TRUE_ARR = new String[]{"true", "1", "yes", "on", "y", "t", "ok", "success", "enable"};

    public static <T> T convert(Object obj) {
        return (T)obj;
    }

    public static QFilter[] getQFilter(QFilter ... qFilterArr) {
        return qFilterArr;
    }

    public static long toLong(Object value) {
        if (value == null) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1L : 0L;
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        return ConvertUtils.toLong(value.toString().trim());
    }

    private static long toLong(String s) {
        if (s.length() == 0) {
            return 0L;
        }
        return Long.parseLong(s);
    }

    public static int toInteger(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        return ConvertUtils.toInteger(value.toString().trim());
    }

    private static int toInteger(String s) {
        if (s.length() == 0) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public static String toString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).toPlainString();
        }
        String s = o.toString();
        if (s == null) {
            return null;
        }
        return (s = s.trim()).length() == 0 ? null : s;
    }

    public static boolean toBoolean(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue() != 0;
        }
        String s = o.toString().trim();
        if (s.length() == 0) {
            return false;
        }
        if (ConvertUtils.checkStrExistIgnoreCase(FALSE_ARR, s)) {
            return false;
        }
        if (ConvertUtils.checkStrExistIgnoreCase(TRUE_ARR, s)) {
            return true;
        }
        throw new KDBizException("invalid boolean string '" + s + "'.");
    }

    public static boolean checkStrExistIgnoreCase(String[] checkArr, String tar) {
        return Stream.of(checkArr).filter(it -> it.equalsIgnoreCase(tar)).findAny().isPresent();
    }

    public static Map<String, Object> convertDynamicObjectToMap(DynamicObject dy) {
        return dy.getDataEntityType().getProperties().stream().map(prop -> prop.getName()).filter(key -> Objects.nonNull(dy.get(key))).collect(Collectors.toMap(key -> key, key -> dy.get(key)));
    }

    public static <E> List<E> transferArrayToList(E[] array) {
        ArrayList transferedList = new ArrayList();
        Arrays.stream(array).forEach(arr -> transferedList.add(arr));
        return transferedList;
    }

    public static Set<Long> convertIdStringToLongSet(String idStr, String seperator) {
        if (HRStringUtils.isEmpty((String)idStr)) {
            return Sets.newHashSetWithExpectedSize((int)16);
        }
        return Arrays.stream(idStr.split(seperator)).map(ID::toLongId).collect(Collectors.toSet());
    }

    public static String convertLongIdSetToString(List<Long> idList, String seperator) {
        if (CollectionUtils.isEmpty(idList)) {
            return "";
        }
        return idList.stream().map(ID::toStringId).collect(Collectors.joining(seperator));
    }
}

