/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hrmp.hric.common.exception.HricDifBizException;

public class DateUtils {
    public static final Log LOGGER = LogFactory.getLog(DateUtils.class);
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static Date MIN_DATE_TIME;
    public static Date MAX_DATE_TIME;

    public static String date2String(Date date, String fmt) {
        if (null == date) {
            return "";
        }
        try {
            return HRDateTimeUtils.format((Date)date, (String)fmt);
        }
        catch (Exception e) {
            LOGGER.error("Date conversion error\u3002value:{}\uff0cformat:{}\uff0cerrMsg:{}", new Object[]{date.toString(), fmt, e.getMessage()});
            throw new HricDifBizException(date.toString() + " Date conversion error\uff0cthe format is " + fmt);
        }
    }

    public static String date2String(Date date) {
        if (null == date) {
            return "";
        }
        return DateUtils.date2String(date, null);
    }

    public static String date2OnlyString(Date date) {
        String dateStr = "-";
        if (null == date) {
            return dateStr;
        }
        try {
            dateStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
        }
        catch (Exception e) {
            throw new HricDifBizException(date + "convert to text error, reason: " + e);
        }
        return dateStr;
    }

    public static String date2ShortStr(Date date) {
        String dateStr = "-";
        if (null == date) {
            return dateStr;
        }
        try {
            dateStr = new SimpleDateFormat(YYYY_MM_DD).format(date);
        }
        catch (Exception e) {
            throw new HricDifBizException(date + "convert to text error, reason: " + e);
        }
        return dateStr;
    }

    public static Date getBeforeOrAfterDate(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, num);
        date = calendar.getTime();
        return date;
    }

    public static Date addDay(Date date, int day) {
        Calendar calendar = DateUtils.getCalendar(date);
        calendar.add(5, day);
        date = calendar.getTime();
        return date;
    }

    public static Date addMonth(Date date, int month) {
        Calendar calendar = DateUtils.getCalendar(date);
        calendar.add(2, month);
        date = calendar.getTime();
        return date;
    }

    private static Calendar getCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static Calendar getDateWithoutTimeCalendar(Date date) {
        Calendar calendar = DateUtils.getCalendar(date);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar;
    }

    public static Date getNowDateZero() {
        long nowTime = System.currentTimeMillis();
        long todayStartTime = nowTime - (nowTime + (long)TimeZone.getDefault().getRawOffset()) % 86400000L;
        return new Date(todayStartTime);
    }

    public static long getSubDay(Date beginDate, Date endDate) {
        return (endDate.getTime() - beginDate.getTime()) / 86400000L;
    }

    public static Long getSubMilliSecond(Date beginDate, Date endDate) {
        if (Objects.isNull(beginDate) || Objects.isNull(endDate)) {
            return 0L;
        }
        return endDate.getTime() - beginDate.getTime();
    }

    public static Long getSubSecond(Date beginDate, Date endDate) {
        Long milliSecond = DateUtils.getSubMilliSecond(beginDate, endDate);
        return milliSecond / 1000L;
    }

    public static Long getSubMinute(Date beginDate, Date endDate) {
        Long milliSecond = DateUtils.getSubMilliSecond(beginDate, endDate);
        return milliSecond / 60000L;
    }

    public static Date getMinuteAgoTime(int min) {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, min);
        return calendar.getTime();
    }

    static {
        try {
            MIN_DATE_TIME = HRDateTimeUtils.parseDate((String)"1970-01-01");
            MAX_DATE_TIME = HRDateTimeUtils.parseDate((String)"2199-12-31");
        }
        catch (ParseException exception) {
            LOGGER.error((Throwable)exception);
        }
    }
}

