/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.common.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.StringUtils;

public class HricDynamicObjectUtils {
    private static Log LOG = LogFactory.getLog(HricDynamicObjectUtils.class);

    public static String getFieldByPage(String page) {
        return HricDynamicObjectUtils.getFieldByPage(page, true);
    }

    public static String getFieldByPage(String page, boolean containsTag) {
        Map<String, IDataEntityProperty> fieldMap = HricDynamicObjectUtils.getFieldMap(page);
        if (containsTag) {
            HashMap fieldMapTemp = new HashMap();
            fieldMap.entrySet().forEach(entry -> {
                if (entry.getValue() instanceof LargeTextProp) {
                    fieldMapTemp.put((String)entry.getKey() + "_tag", new TextProp());
                }
            });
            fieldMap.putAll(fieldMapTemp);
        }
        StringBuilder builder = new StringBuilder();
        if (fieldMap.isEmpty()) {
            return "";
        }
        for (String key : fieldMap.keySet()) {
            builder.append(key).append(',');
        }
        return builder.substring(0, builder.length() - 1);
    }

    private static Map<String, IDataEntityProperty> getFieldMap(String page) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)page.trim());
        return entityType.getAllFields().entrySet().stream().filter(entry -> HRStringUtils.isNotEmpty((String)((IDataEntityProperty)entry.getValue()).getAlias())).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (IDataEntityProperty)entry.getValue(), (o1, o2) -> o1));
    }

    public static void setBigText(DynamicObject dyn, String field, String txt) {
        if (HRStringUtils.isNotEmpty((String)txt) && txt.length() > 255) {
            dyn.set(field, (Object)txt.substring(0, 255));
            dyn.set(field + "_tag", (Object)txt);
        } else {
            dyn.set(field, (Object)txt);
            dyn.set(field + "_tag", null);
        }
    }

    public static void clearBigText(DynamicObject dyn, String field) {
        HricDynamicObjectUtils.setBigText(dyn, field, "");
    }

    public static String getBigText(DynamicObject dyn, String field) {
        String tagTxt = dyn.getString(field + "_tag");
        return StringUtils.isEmpty((CharSequence)tagTxt) || tagTxt.length() <= 255 ? dyn.getString(field) : tagTxt;
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj, Set<String> fieldSet) {
        if (fromObj != null && toObj != null && fieldSet != null) {
            Set ignoreKeys = fromObj.getDataEntityType().getProperties().stream().filter(dyn -> !fieldSet.contains(dyn.getName())).map(dyn -> dyn.getName()).collect(Collectors.toSet());
            HRDynamicObjectUtils.copy((DynamicObject)fromObj, (DynamicObject)toObj, ignoreKeys);
        }
    }

    public static boolean entityContainsNumberAndName(BasedataEntityType dataEntityType) {
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        IDataEntityProperty numberProp = (IDataEntityProperty)properties.get((Object)"number");
        IDataEntityProperty nameProp = (IDataEntityProperty)properties.get((Object)"name");
        return Objects.nonNull(numberProp) && Objects.nonNull(nameProp) && HRStringUtils.isNotEmpty((String)numberProp.getAlias());
    }

    public static String getRelationBasedataNumberByProperty(IDataEntityProperty property) {
        if (property instanceof BasedataProp) {
            return ((BasedataProp)property).getBaseEntityId();
        }
        if (property instanceof MulBasedataProp) {
            return ((MulBasedataProp)property).getBaseEntityId();
        }
        return null;
    }

    public static DynamicObjectCollection entitySort(String entityNumber, IDataModel model, IFormView view) {
        DynamicObjectCollection entryEntity = model.getEntryEntity(entityNumber);
        if (HRStringUtils.equals((String)"hric_ptplitementry", (String)entityNumber)) {
            Collections.sort(entryEntity, (o1, o2) -> (int)(o1.getDynamicObject("fbasedataid").getLong("listseq") - o2.getDynamicObject("fbasedataid").getLong("listseq")));
            HricDynamicObjectUtils.updateEntry(entryEntity, model);
        } else {
            Collections.sort(entryEntity, (o1, o2) -> (int)(o1.getDynamicObject("implitem").getLong("listseq") - o2.getDynamicObject("implitem").getLong("listseq")));
        }
        view.updateView(entityNumber);
        return entryEntity;
    }

    public static void updateEntry(DynamicObjectCollection entryEntity, IDataModel iDataModel) {
        List<Long> itemList = entryEntity.stream().map(it -> it.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
        AbstractFormDataModel model = (AbstractFormDataModel)iDataModel;
        model.deleteEntryData("hric_ptplitementry");
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("fbasedataid_id", new Object[0]);
        itemList.forEach(xva$0 -> vs.addRow(new Object[]{xva$0}));
        model.batchCreateNewEntryRow("hric_ptplitementry", vs);
        model.endInit();
    }
}

