/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.common.util;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.common.bean.InitOperationResultInfo;
import kd.hrmp.hric.common.constants.msg.MidTableMsgEnum;

public class InitOperationResultUtils {
    private static final Log LOG = LogFactory.getLog(InitOperationResultUtils.class);

    public static InitOperationResultInfo parseResult(OperationResult operationResult, String operateKey) {
        if (operationResult != null && HRStringUtils.isNotEmpty((String)operateKey) && operationResult.getValidateResult().getErrorPkIds().size() != 0) {
            int successCount = operationResult.getSuccessPkIds().size();
            int errorCount = operationResult.getValidateResult().getErrorPkIds().size();
            int totalCount = successCount + errorCount;
            String operateName = "";
            switch (operateKey) {
                case "save": {
                    operateName = MidTableMsgEnum.MSG_SAVE.getMsg();
                    break;
                }
                case "modify": {
                    operateName = MidTableMsgEnum.MSG_MODIFY.getMsg();
                    break;
                }
            }
            String title = String.format(Locale.ROOT, MidTableMsgEnum.MSG_RESULT.getMsg(), totalCount, operateName, successCount, errorCount);
            InitOperationResultInfo operationResultInfo = new InitOperationResultInfo();
            operationResultInfo.setTitle(title);
            ArrayList errorMsgList = Lists.newArrayListWithExpectedSize((int)operationResult.getValidateResult().getValidateErrors().size());
            operationResult.getValidateResult().getValidateErrors().forEach(dy -> {
                List allErrorInfoList = dy.getAllErrorInfo();
                if (!CollectionUtils.isEmpty((Collection)allErrorInfoList)) {
                    allErrorInfoList.forEach(info -> errorMsgList.add(info.getMessage()));
                }
            });
            operationResultInfo.setErrorMsgList(errorMsgList);
            return operationResultInfo;
        }
        return null;
    }

    public static String parseResultToString(OperationResult operationResult, String operateKey) {
        InitOperationResultInfo operationResultInfo = InitOperationResultUtils.parseResult(operationResult, operateKey);
        if (operationResultInfo == null) {
            return null;
        }
        String operationResultInfoStr = "";
        try {
            operationResultInfoStr = HRJSONUtils.toString((Object)operationResultInfo);
        }
        catch (IOException e) {
            LOG.error("InitOperationResultUtils  parseResultToString error{}", (Object)e.getMessage());
        }
        return operationResultInfoStr;
    }

    public static FormShowParameter getShowOperationResultPageParameter(String operationResultInfoStr) {
        InitOperationResultInfo operationResultInfo = InitOperationResultUtils.getOperationResultInfo(operationResultInfoStr);
        if (operationResultInfo != null) {
            return InitOperationResultUtils.getShowOperationResultPageParameter(operationResultInfo.getTitle(), operationResultInfo.getErrorMsgList());
        }
        return null;
    }

    public static FormShowParameter getShowOperationResultPageParameter(String title, List<String> errorMessageList) {
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(false);
        parameters.setCustomParam("title", (Object)title);
        parameters.setCustomParam("errorMsg", errorMessageList);
        parameters.setHasRight(true);
        return parameters;
    }

    public static InitOperationResultInfo getOperationResultInfo(String operationResultInfoStr) {
        if (HRStringUtils.isEmpty((String)operationResultInfoStr)) {
            return null;
        }
        InitOperationResultInfo operationResultInfo = null;
        try {
            operationResultInfo = (InitOperationResultInfo)HRJSONUtils.cast((String)operationResultInfoStr, InitOperationResultInfo.class);
        }
        catch (IOException e) {
            LOG.error("InitOperationResultUtils  getOperationResultInfo error{}", (Object)e.getMessage());
        }
        return operationResultInfo;
    }
}

