/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.common.util;

import java.util.function.Supplier;
import kd.bos.context.RequestContext;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;

public class LogUtils {
    private static Log LOG = LogFactory.getLog(LogUtils.class);

    public static <T> T printCostLog(String logInfo, Supplier<T> supplier) {
        LOG.info(logInfo);
        long start = System.currentTimeMillis();
        T supp = supplier.get();
        LOG.info("{} use time: {}ms", (Object)logInfo, (Object)(System.currentTimeMillis() - start));
        return supp;
    }

    public static void recordAppLog(String entityId, String opName, String opDesc) {
        ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo appLogInfo = new AppLogInfo();
        appLogInfo.setBizAppID("22/9TRQ536NA");
        appLogInfo.setBizObjID(entityId);
        appLogInfo.setOpName(opName);
        appLogInfo.setOpDescription(opDesc);
        service.addLog(appLogInfo);
    }

    public static String getStackTraceString(Throwable throwable) {
        if (throwable.getCause() != null) {
            return LogUtils.getStackTraceString(throwable.getCause());
        }
        StringBuilder sb = new StringBuilder("traceId:");
        sb.append(RequestContext.get().getTraceId()).append('\n');
        sb.append(throwable.getMessage()).append('\n');
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            if (sb.length() > 4000) {
                return sb.toString();
            }
            sb.append(stackTraceElement).append('\n');
        }
        return sb.toString();
    }
}

