/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.common.util;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.common.util.HricObjectUtils;

public class QFilterUtils {
    public static QFilter getEnableQFilter() {
        return QFilterUtils.getEnableQFilter(true);
    }

    public static QFilter getEnableQFilter(boolean enable) {
        return new QFilter("enable", "=", (Object)(enable ? "1" : "0"));
    }

    public static QFilter getNumberEqFilter(String number) {
        return new QFilter("number", "=", (Object)number);
    }

    public static QFilter getIdInFilter(List<?> idList) {
        return new QFilter("id", "in", idList);
    }

    public static String getFilterSql(QFilter qFilter, String entityNumber) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        Set<String> propertySet = QFilterUtils.getQFilterPropertySet(qFilter);
        Map<String, String> aliasMap = entityType.getProperties().stream().filter(ss -> propertySet.contains(ss.getName())).collect(Collectors.toMap(IMetadata::getName, pro -> pro.getAlias()));
        String[] qFilterSqlArray = qFilter.toString().split(" ");
        StringBuilder sqlBuilder = new StringBuilder();
        for (String ss2 : qFilterSqlArray) {
            if (propertySet.contains(ss2)) {
                sqlBuilder.append(aliasMap.get(ss2)).append(" ");
                continue;
            }
            ss2 = ss2.replaceAll("EMPTY", " ");
            sqlBuilder.append(ss2).append(" ");
        }
        return sqlBuilder.toString().trim();
    }

    private static Set<String> getQFilterPropertySet(QFilter qFilter) {
        HashSet<String> propertySet = new HashSet<String>();
        if (HricObjectUtils.isEmpty(qFilter)) {
            return propertySet;
        }
        propertySet.add(qFilter.getProperty());
        List nestList = qFilter.getNests(true);
        nestList.stream().forEach(filter -> propertySet.addAll(QFilterUtils.getQFilterPropertySet(filter.getFilter())));
        return propertySet;
    }

    public static QFilter getDataInitQFilter(List<String> billFormIdList) {
        if (CollectionUtils.isEmpty(billFormIdList)) {
            return null;
        }
        for (String billFormId : billFormIdList) {
            Map allFields = MetadataServiceHelper.getDataEntityType((String)billFormId).getAllFields();
            for (IDataEntityProperty toPro : allFields.values()) {
                if (!HRStringUtils.equals((String)toPro.getName(), (String)"initdatasource") || HRStringUtils.isEmpty((String)toPro.getAlias())) continue;
                return new QFilter("initdatasource", "=", (Object)"1");
            }
        }
        return null;
    }
}

