/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.common.util;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hrmp.hric.common.util.ConvertUtils;

public class ServiceFlowUtils {
    private static Log LOG = LogFactory.getLog(ServiceFlowUtils.class);
    private static final String ACTS = "acts";
    private static final String TRANS = "trans";
    private static final String VALUE = "value";

    public static void openExecResultPage(AbstractFormPlugin form, long procInstId, String caption) {
        DynamicObject proc = null;
        try {
            proc = BusinessDataServiceHelper.loadSingle((Object)procInstId, (String)"isc_sf_proc_inst", (String)"flow,context_tag");
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            form.getView().showErrorNotification(e.getMessage());
            return;
        }
        Map diagram = (Map)ServiceFlowUtils.getDefineJson(ConvertUtils.toLong(proc.get("flow_id"))).get("diagram");
        HashMap<String, Object> params = new HashMap<String, Object>(7);
        params.put("diagram", diagram);
        params.put("released_id", proc.get("flow_id"));
        params.put("proc_inst_id", procInstId);
        params.put("$tag", null);
        DynamicObject flow = proc.getDynamicObject("flow");
        params.put("name", flow.getString("name"));
        params.put("number", flow.getString("number"));
        params.put("version", flow.getString("version"));
        Map runtime = (Map)JSON.parseObject((String)((String)proc.get("context_tag")), Map.class);
        Collection properties = (Collection)runtime.get("properties");
        if (properties != null) {
            ServiceFlowUtils.setParamMap(params, properties);
        }
        ServiceFlowUtils.showTabForm(form, "isc_service_flow_editor", caption, params);
    }

    private static void setParamMap(Map<String, Object> params, Collection<Map<?, ?>> properties) {
        for (Map<?, ?> o : properties) {
            String key = (String)o.get("key");
            if (ACTS.equals(key)) {
                params.put(ACTS, o.get(VALUE));
                continue;
            }
            if (!TRANS.equals(key)) continue;
            params.put(TRANS, o.get(VALUE));
        }
    }

    public static Map<String, Object> getDefineJson(long id) {
        DynamicObject r = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_service_flow_r");
        String json = r.getString("define_json_tag");
        return (Map)JSON.parseObject((String)json.substring(1, json.length() - 1), Map.class);
    }

    public static void showTabForm(AbstractFormPlugin form, String entity, String caption, Map<String, Object> params) {
        if (ServiceFlowUtils.openTabIfExist(form, entity, params)) {
            return;
        }
        FormShowParameter p = new FormShowParameter();
        p.setFormId(entity);
        p.setCustomParams(params);
        p.setCaption(caption);
        p.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        form.getView().showForm(p);
    }

    private static boolean openTabIfExist(AbstractFormPlugin form, String entity, Map<String, Object> params) {
        try {
            IFormView appView;
            Control control;
            IFormView view = form.getView();
            IFormView mainView = view.getMainView();
            return mainView != null && !mainView.getPageId().equals(view.getPageId()) && (control = (appView = SessionManager.getCurrent().getViewNoPlugin(view.getFormShowParameter().getAppId() + mainView.getPageId())).getControl("_submaintab_")) instanceof Tab && ServiceFlowUtils.existTabPage(entity, view, appView, (Tab)control, params);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean existTabPage(String entity, IFormView view, IFormView appView, Tab control, Map<String, Object> params) {
        for (Object c : control.getItems()) {
            FormShowParameter formShowParameter;
            String formId;
            TabPage tabPage = (TabPage)c;
            String tabPageKey = tabPage.getKey();
            IFormView lv = appView.getViewNoPlugin(tabPageKey);
            if (lv == null || "appmiantab".equals(tabPageKey) || !entity.equals(formId = (formShowParameter = lv.getFormShowParameter()) instanceof ListShowParameter ? ((ListShowParameter)formShowParameter).getBillFormId() : formShowParameter.getFormId())) continue;
            boolean flag = true;
            if (params != null && !params.isEmpty()) {
                Map customParams = formShowParameter.getCustomParams();
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    String key = entry.getKey();
                    if (Objects.equals(entry.getValue(), customParams.get(key))) continue;
                    flag = false;
                    break;
                }
            }
            if (!flag) continue;
            control.activeTab(tabPageKey);
            view.sendFormAction(appView);
            return true;
        }
        return false;
    }
}

