/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.mservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.init.IMidTableDomainService;
import kd.hrmp.hric.bussiness.service.InitExecTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.InitMidTableServiceHelper;
import kd.hrmp.hric.bussiness.service.InitTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.InitTemplateServiceHelper;
import kd.hrmp.hric.bussiness.service.impl.InitExecTaskServiceImpl;
import kd.hrmp.hric.common.bean.TaskInfo;
import kd.hrmp.hric.common.openapi.OpenApiResponse;
import kd.hrmp.hric.common.util.ConvertUtils;
import kd.hrmp.hric.common.util.HricObjectUtils;
import kd.hrmp.hric.mservice.IInitMidTableService;
import kd.hrmp.hric.mservice.handle.InitMidOpHandleFactory;

public class InitMidTableServiceImpl
implements IInitMidTableService {
    private static final String INFO_MAP = "infoMap";
    private static final String EXEC_TASK_ID = "execTaskId";
    private static final String INFO_DYNAMIC_OBJECT = "infoDynamicObject";
    private static Log LOG = LogFactory.getLog(InitMidTableServiceImpl.class);
    private final IMidTableDomainService midTableDomainService = (IMidTableDomainService)ServiceFactory.getService(IMidTableDomainService.class);

    public Map<String, Object> getInfoWithMap(Map<String, Object> paramMap) {
        return this.getDataMap(paramMap, INFO_MAP);
    }

    public Map<String, Object> getInfoWithDynamicObject(Map<String, Object> paramMap) {
        return this.getDataMap(paramMap, INFO_DYNAMIC_OBJECT);
    }

    private Map<String, Object> getDataMap(Map<String, Object> paramMap, String getInfoType) {
        Object execTaskId = paramMap.get(EXEC_TASK_ID);
        if (ObjectUtils.isEmpty((Object)execTaskId)) {
            LOG.info("[HRIC]Call RPC Service,execTaskId:{} is null", execTaskId);
            return new HashMap<String, Object>();
        }
        LOG.info("[HRIC]Call RPC Service,methodType:{},execTaskId:{}", (Object)getInfoType, execTaskId);
        DynamicObject execTask = InitExecTaskServiceHelper.getExecTaskById((Long)Long.valueOf(execTaskId.toString()));
        if (ObjectUtils.isEmpty((Object)execTask)) {
            LOG.info("[HRIC]Call RPC Service,The ExecTask cannot be found according to the execTaskId");
            return new HashMap<String, Object>();
        }
        String taskInfo = execTask.getString("taskinfo");
        JSONObject jsonObject = JSON.parseObject((String)taskInfo);
        Long endId = jsonObject.getLong("endId");
        Long startId = jsonObject.getLong("startId");
        String midTableNumber = jsonObject.getString("midTableNumber");
        String qFilterStr = jsonObject.getString("qfilter");
        QFilter qFilter = QFilter.fromSerializedString((String)qFilterStr);
        QFilter[] filters = new QFilter[]{qFilter.and(new QFilter("id", ">=", (Object)startId)).and("id", "<=", (Object)endId)};
        Object[] dys = InitMidTableServiceHelper.queryPageCollection((String)midTableNumber, (QFilter[])filters);
        if (ObjectUtils.isEmpty((Object[])dys)) {
            StringBuilder sb = new StringBuilder();
            Arrays.stream(filters).forEach(filter -> sb.append(filter.toSerializedString()));
            LOG.info("[HRIC]Call RPC Service,Cannot get mediate table data,filters is:{}", (Object)sb.toString());
            return new HashMap<String, Object>();
        }
        if (HRStringUtils.equals((String)getInfoType, (String)INFO_DYNAMIC_OBJECT)) {
            String entityCode = jsonObject.getString("entityNumber");
            String bussinessKey = jsonObject.getString("bussinessKey");
            return InitMidOpHandleFactory.getInitMidOpHandle(entityCode, bussinessKey, midTableNumber).handleData((DynamicObject[])dys);
        }
        Long taskId = execTask.getLong("batchnumber");
        List mapData = Stream.of(dys).map(ConvertUtils::convertDynamicObjectToMap).collect(Collectors.toList());
        for (Map map : mapData) {
            map.put("initbatch", taskId);
            map.remove("initstatus");
        }
        return ImmutableMap.of((Object)"data", mapData, (Object)"aliasMapping", (Object)InitMidTableServiceHelper.getMidTableAndEntityMapping((String)midTableNumber));
    }

    public Long getCurrentBatchTotalCount(Long execTaskId) {
        return new InitExecTaskServiceImpl().getCurrentBatchTotalCount(execTaskId);
    }

    public Map<String, Object> getBizDOBySpecifyConditions(Long taskId, Map<String, List<String>> paramMap) {
        if (taskId == null || paramMap.isEmpty()) {
            LOG.info("[HRIC] Call getBizDOBySpecifyConditions()\uff0cInput parameter \"taskId\" is\uff1a{}\uff0c\"paramMap\" is\uff1a{}", (Object)taskId, paramMap);
            return new HashMap<String, Object>();
        }
        try {
            DynamicObject task = InitTaskServiceHelper.getTask((long)taskId);
            DynamicObject implItemRel = task.getDynamicObject("implitemrel");
            long tempId = implItemRel.getDynamicObject("initimporttemplat").getLong("id");
            DynamicObject template = InitTemplateServiceHelper.getInitTemplateByTemplateID((Long)tempId);
            String entityCode = template.getDynamicObject("entityobjscope").getString("number");
            String midTableNumber = template.getString("intermediatetable");
            String bussinessKey = template.getString("uniquestring");
            Set bussinessSet = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToStream((CharSequence)bussinessKey).collect(Collectors.toSet());
            QFilter qFilter = new QFilter("hrictaskid", "=", (Object)taskId);
            for (Map.Entry<String, List<String>> entry : paramMap.entrySet()) {
                qFilter.and(new QFilter(entry.getKey(), "in", entry.getValue()));
            }
            qFilter.and(new QFilter("initstatus", "=", (Object)"C1"));
            DynamicObject[] dys = InitMidTableServiceHelper.queryPageCollection((String)midTableNumber, (QFilter[])qFilter.toArray());
            return InitMidOpHandleFactory.getInitMidOpHandle(entityCode, Joiner.on((String)"|").join(bussinessSet), midTableNumber).handleData(dys);
        }
        catch (Exception e) {
            LOG.error("[HRIC] Exception occurred when calling getBizDOBySpecifyConditions()\uff0c Error is\uff1a", (Throwable)e);
            return new HashMap<String, Object>();
        }
    }

    public Map<String, List<Long>> getBizIdMapByExecTaskId(Long execTaskId) {
        HashMap bizIdMap = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObject execTask = InitExecTaskServiceHelper.getExecTaskById((String)"id,midtableids,taskinfo", (Long)execTaskId);
        if (HricObjectUtils.isEmpty((Object)execTask)) {
            return bizIdMap;
        }
        String midTableIds = execTask.getString("midtableids");
        if (HRStringUtils.isEmpty((String)midTableIds)) {
            return bizIdMap;
        }
        TaskInfo taskInfo = new InitExecTaskServiceImpl().parseTaskInfo(execTask);
        Set midTableIdSet = ConvertUtils.convertIdStringToLongSet((String)midTableIds, (String)",");
        QFilter qFilter = new QFilter("id", "in", (Object)midTableIdSet);
        DynamicObject[] dynamicObjects = InitMidTableServiceHelper.queryPageCollection((String)taskInfo.getMidTableNumber(), (String)"hricbizid", (QFilter[])qFilter.toArray());
        Map<String, List<DynamicObject>> bizIdDynMap = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dyn -> dyn.getString("hricbizid")));
        for (Map.Entry<String, List<DynamicObject>> bizIdEntry : bizIdDynMap.entrySet()) {
            bizIdMap.put(bizIdEntry.getKey(), bizIdEntry.getValue().stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList()));
        }
        return bizIdMap;
    }

    public Map<String, List<Long>> getBizIdMapByExecTaskIdAndBizIds(Long execTaskId, Set<String> bizIdSet) {
        HashMap bizIdMap = Maps.newHashMapWithExpectedSize((int)16);
        if (Objects.isNull(execTaskId) || CollectionUtils.isEmpty(bizIdSet)) {
            LOG.info("[HRIC]Call RPC Service:getBizIdMapByExecTaskIdAndBizIds(), The parameters cannot be empty");
            return bizIdMap;
        }
        DynamicObject execTask = InitExecTaskServiceHelper.getExecTaskById((String)"taskinfo,batchnumber", (Long)execTaskId);
        if (ObjectUtils.isEmpty((Object)execTask)) {
            LOG.info("[HRIC]Call RPC Service:getBizIdMapByExecTaskIdAndBizIds,The ExecTask cannot be found according to the execTaskId");
            return bizIdMap;
        }
        long taskId = execTask.getLong("batchnumber");
        String taskInfo = execTask.getString("taskinfo");
        String midTblNumber = JSON.parseObject((String)taskInfo).getString("midTableNumber");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(midTblNumber);
        QFilter[] qFilters = new QFilter[]{new QFilter("hrictaskid", "=", (Object)taskId), new QFilter("initstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"D1", "E1"})), new QFilter("hricbizid", "in", bizIdSet)};
        DynamicObject[] result = serviceHelper.query("id,hricbizid", qFilters);
        Arrays.stream(result).forEach(dyc -> {
            final long midId = dyc.getLong("id");
            String bizId = dyc.getString("hricbizid");
            if (bizIdMap.containsKey(bizId)) {
                ((List)bizIdMap.get(bizId)).add(midId);
            } else {
                bizIdMap.put(bizId, new ArrayList<Long>(){
                    {
                        this.add(midId);
                    }
                });
            }
        });
        return bizIdMap;
    }

    public OpenApiResponse syncMidTableData(String planNumber, String tableNumber, String batchNumber, List<Map<String, Object>> data, String hricSourceSys) {
        this.midTableDomainService.syncMidTableValidate(planNumber, tableNumber, batchNumber, data, hricSourceSys);
        this.midTableDomainService.syncMidTableData(planNumber, tableNumber, batchNumber, data, hricSourceSys);
        return OpenApiResponse.success((String)String.valueOf(data.size()));
    }

    @Deprecated
    public DynamicObject[] getMidTblWithSpecifyParam(Map<String, Set<Object>> fieldFilterMap, Map<String, Set<Object>> initFieldFilterMap, Long execTaskId, Set<String> selectFieldSet) {
        StringBuilder sb = new StringBuilder();
        if (CollectionUtils.isEmpty(fieldFilterMap)) {
            sb.append("fieldFilterMap\u3001");
        }
        if (execTaskId == null) {
            sb.append("execTaskId\u3001");
        }
        if (CollectionUtils.isEmpty(selectFieldSet)) {
            sb.append("selectFieldSet\u3001");
        }
        if (sb.length() > 0) {
            LOG.warn("[HRIC]Call RPC Service,getMidTblWithSpecifyParam(), The following parameters are empty:{}", (Object)sb.toString());
            return new DynamicObject[0];
        }
        return this.midTableDomainService.getMidTblWithSpecifyParam(fieldFilterMap, initFieldFilterMap, execTaskId, selectFieldSet);
    }
}

