/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.mservice;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.init.IInitTaskDomainService;
import kd.hrmp.hric.bussiness.service.ImplItemListDaoHelper;
import kd.hrmp.hric.bussiness.service.InitTaskServiceHelper;
import kd.hrmp.hric.common.util.HricObjectUtils;
import kd.hrmp.hric.mservice.IInitTaskService;

public class InitTaskServiceImpl
implements IInitTaskService {
    private static final Log LOG = LogFactory.getLog(InitTaskServiceImpl.class);
    private IInitTaskDomainService iInitTaskDomainService = (IInitTaskDomainService)ServiceFactory.getService(IInitTaskDomainService.class);

    public Map<String, Long> getPreTaskMap(long taskId) {
        DynamicObject task = InitTaskServiceHelper.getTask((String)"pretask", (long)taskId);
        if (HricObjectUtils.isEmpty((Object)task)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        DynamicObjectCollection preTasks = task.getDynamicObjectCollection("pretask");
        List preTaskList = preTasks.stream().map(it -> it.getDynamicObject("fbasedataid")).collect(Collectors.toList());
        List implItemIdList = preTaskList.stream().map(dyn -> dyn.getDynamicObject("implitemrel").getLong("id")).collect(Collectors.toList());
        DynamicObject[] implItemDyns = ImplItemListDaoHelper.getImplItemObjectByIds((String)"initfordatasource,entityobjscope", implItemIdList);
        Map<Long, DynamicObject> implItemMap = Arrays.stream(implItemDyns).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
        preTaskList.stream().forEach(dyn -> dyn.set("implitemrel", implItemMap.get(dyn.getDynamicObject("implitemrel").getLong("id"))));
        return preTaskList.stream().filter(dyn -> this.checkDataSourceForA((DynamicObject)dyn)).collect(Collectors.toMap(dyn -> dyn.getDynamicObject("implitemrel").getDynamicObject("entityobjscope").getString("number"), dyn -> dyn.getLong("id"), (k1, k2) -> k1));
    }

    public DynamicObject[] getTaskWithSpecifyParam(Map<String, Set<Long>> fieldFilterMap, Set<String> selectFieldSet) {
        if (CollectionUtils.isEmpty(fieldFilterMap)) {
            LOG.warn("[HRIC]Call RPC Service,getTaskWithTaskIdSet:{} is null", fieldFilterMap);
            return new DynamicObject[0];
        }
        if (CollectionUtils.isEmpty(selectFieldSet)) {
            LOG.warn("[HRIC]Call RPC Service,getTaskWithTaskIdSet:{} is null", selectFieldSet);
            return new DynamicObject[0];
        }
        return this.iInitTaskDomainService.getTaskWithSpecifyParam(fieldFilterMap, selectFieldSet);
    }

    private boolean checkDataSourceForA(DynamicObject task) {
        return Optional.ofNullable(task.getDynamicObject("implitemrel")).map(dyn -> HRStringUtils.equals((String)"A", (String)dyn.getString("initfordatasource"))).orElseGet(() -> false);
    }
}

