/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.mservice.handle;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.service.InitMidTableServiceHelper;
import kd.hrmp.hric.common.setter.PropertySetterFactory;
import kd.hrmp.hric.common.setter.Setter;
import kd.hrmp.hric.common.util.HricDynamicObjectUtils;
import kd.hrmp.hric.mservice.handle.IInitMidOpHandle;

public abstract class AbstractInitMidOpHandle
implements IInitMidOpHandle {
    protected static final String SEQ = "seq";
    protected static final String IDMAPPING = "idmapping";
    protected static final String HRICBIZID = "hricbizid";
    protected String entityCode;
    protected String bussinessKey;
    protected String midTableNumber;
    protected MainEntityType dataEntityType;
    protected DynamicObject[] currHandleBatchData;
    protected Set<String> entityOnlyKeySet;
    protected Map<Long, Set<Long>> pkRelMap = new HashMap<Long, Set<Long>>();
    protected Map<String, String> midTblAndEntityMappingMap;
    protected Map<String, List<DynamicObject>> baseDataMap = new HashMap<String, List<DynamicObject>>();
    protected DataEntityPropertyCollection midTblProps;
    protected List<DynamicObject> entityDycList = new ArrayList<DynamicObject>();
    protected Set<String> midTableFieldSet = new HashSet<String>();

    public AbstractInitMidOpHandle(String entityCode, String bussinessKey, MainEntityType dataEntityType, String midTableNumber) {
        this.entityCode = entityCode;
        this.bussinessKey = bussinessKey;
        this.dataEntityType = dataEntityType;
        this.midTableNumber = midTableNumber;
        this.midTblAndEntityMappingMap = InitMidTableServiceHelper.getMidTableAndEntityMappingWithoutName((String)midTableNumber);
        this.entityOnlyKeySet = Splitter.on((String)"|").trimResults().omitEmptyStrings().splitToStream((CharSequence)bussinessKey).collect(Collectors.toSet());
        this.midTblProps = MetadataServiceHelper.getDataEntityType((String)midTableNumber).getProperties();
    }

    @Override
    public Map<String, Object> handleData(DynamicObject[] dys) {
        this.init();
        this.currHandleBatchData = dys;
        this.loadBasedata();
        this.structBizEntity();
        if (CollectionUtils.isEmpty(this.entityDycList)) {
            return new HashMap<String, Object>();
        }
        this.dynamicObjectSort(this.entityDycList);
        return ImmutableMap.of((Object)"data", this.entityDycList, (Object)IDMAPPING, this.pkRelMap);
    }

    protected abstract void init();

    protected abstract void structBizEntity();

    protected abstract void loadBasedata();

    protected void baseDataMapSetVal(Set<String> fieldValSet, String entityType, String fieldName, String belongEntityCode) {
        List<DynamicObject> dys = this.baseDataMap.get(entityType);
        if (!CollectionUtils.isEmpty(dys)) {
            dys.addAll(InitMidTableServiceHelper.loadBaseDataFromDBWithRefProp((String)entityType, fieldValSet, (String)fieldName, (String)belongEntityCode));
            Map<Object, DynamicObject> dycMap = dys.stream().collect(Collectors.toMap(dyc -> dyc.get("id"), dyc -> dyc, (k1, k2) -> k1));
            this.baseDataMap.put(entityType, dycMap.values().stream().collect(Collectors.toList()));
        } else {
            this.baseDataMap.put(entityType, InitMidTableServiceHelper.loadBaseDataFromDBWithRefProp((String)entityType, fieldValSet, (String)fieldName, (String)belongEntityCode));
        }
    }

    protected void distributeMainEntity(DynamicObject dy, Map<String, List<DynamicObject>> midTblDataMap) {
        StringBuilder sb = new StringBuilder();
        this.entityOnlyKeySet.forEach(it -> sb.append(dy.getString(it)).append("|"));
        String key = sb.toString();
        if (!midTblDataMap.containsKey(key)) {
            midTblDataMap.put(key, new ArrayList());
        }
        midTblDataMap.get(key).add(dy);
    }

    protected long getId(List<DynamicObject> midList, long id) {
        if (CollectionUtils.isEmpty(midList)) {
            return id;
        }
        String bizid = (String)midList.get(0).get(HRICBIZID);
        if (HRStringUtils.isNotEmpty((String)bizid)) {
            return Long.parseLong(bizid);
        }
        return id;
    }

    protected void valueConvert(DynamicObject midDyc, DynamicObject bizDyc, IDataEntityProperty property) {
        String propName = this.entityField2MidTblField(property);
        String midDycFieldVal = midDyc.getString(propName);
        if (property instanceof BasedataProp && HRStringUtils.isNotEmpty((String)midDycFieldVal)) {
            this.baseDataHandle(midDyc, bizDyc, midDycFieldVal, this.baseDataMap.get(((BasedataProp)property).getBaseEntityId()), propName);
        } else if (property instanceof MulBasedataProp) {
            if (HRStringUtils.isNotEmpty((String)(midDycFieldVal = midDycFieldVal + "," + midDyc.getString(propName + "_tag")))) {
                this.mulBaseDataHandle(bizDyc, midDycFieldVal, this.baseDataMap.get(((MulBasedataProp)property).getBaseEntityId()), propName);
            }
        } else {
            Setter setter = PropertySetterFactory.createSetter((IDataEntityProperty)property);
            setter.midTblDyc2BizEntityDyc(bizDyc, midDyc.get(propName));
        }
    }

    protected void baseDataHandle(DynamicObject midDyc, DynamicObject bizDyc, String dycFieldVal, List<DynamicObject> dys, String propName) {
        String importProp = midDyc.getDynamicObjectType().getProperty(propName + "a") != null ? "number" : "name";
        DynamicProperty property = bizDyc.getDynamicObjectType().getProperty(this.midTblField2EntityField(propName));
        BasedataEntityType dataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)((BasedataProp)property).getBaseEntityId());
        if (!HricDynamicObjectUtils.entityContainsNumberAndName((BasedataEntityType)dataEntityType) && HRStringUtils.isEmpty((String)(importProp = dataEntityType.getNumberProperty()))) {
            importProp = dataEntityType.getNameProperty();
        }
        DataEntityPropertyCollection bizDycProperties = bizDyc.getDynamicObjectType().getProperties();
        for (DynamicObject dyc : dys) {
            if (!HRStringUtils.equals((String)dycFieldVal, (String)dyc.getString(importProp))) continue;
            if (!bizDycProperties.containsKey((Object)propName)) {
                bizDyc.set(this.midTblField2EntityField(propName), (Object)dyc);
                return;
            }
            bizDyc.set(propName, (Object)dyc);
            return;
        }
    }

    protected void mulBaseDataHandle(DynamicObject bizDyc, String dycFieldVal, List<DynamicObject> dys, String propName) {
        DynamicObjectCollection docs = bizDyc.getDynamicObjectCollection(propName);
        String baseDataId = ((BasedataProp)docs.getDynamicObjectType().getProperty("fbasedataid")).getBaseEntityId();
        BasedataEntityType dataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)baseDataId);
        ArrayList fieldValList = Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)dycFieldVal));
        if (!HricDynamicObjectUtils.entityContainsNumberAndName((BasedataEntityType)dataEntityType)) {
            String numberProp = dataEntityType.getNumberProperty();
            if (HRStringUtils.isEmpty((String)numberProp)) {
                numberProp = dataEntityType.getNameProperty();
            }
            String finalNumberProp = numberProp;
            fieldValList.forEach(val -> dys.stream().filter(dyc -> HRStringUtils.equals((String)val, (String)dyc.getString(finalNumberProp))).forEach(dyc -> this.structMulBaseDataDyc(docs, (DynamicObject)dyc)));
        } else {
            fieldValList.forEach(val -> dys.stream().filter(dyc -> HRStringUtils.equals((String)val, (String)dyc.getString("number")) || HRStringUtils.equals((String)val, (String)dyc.getString("name"))).forEach(dyc -> this.structMulBaseDataDyc(docs, (DynamicObject)dyc)));
        }
        DataEntityPropertyCollection bizDycProperties = bizDyc.getDynamicObjectType().getProperties();
        if (!bizDycProperties.containsKey((Object)propName)) {
            bizDyc.set(this.midTblField2EntityField(propName), (Object)docs);
            return;
        }
        bizDyc.set(propName, (Object)docs);
    }

    private void structMulBaseDataDyc(DynamicObjectCollection docs, DynamicObject dyc) {
        DynamicObject dy = new DynamicObject(docs.getDynamicObjectType());
        dy.set("fbasedataid", (Object)dyc);
        docs.add((Object)dy);
    }

    private void dynamicObjectSort(List<DynamicObject> entityDycList) {
        entityDycList.sort((dyc1, dyc2) -> {
            Long dycId1 = this.pkRelMap.get(dyc1.getLong("id")).stream().findFirst().orElse(0L);
            Long dycId2 = this.pkRelMap.get(dyc2.getLong("id")).stream().findFirst().orElse(0L);
            return dycId1.compareTo(dycId2);
        });
    }

    protected void handleBaseDataOrMulBaseData(Map<String, IDataEntityProperty> entityFieldMap, String fieldName, IDataEntityProperty prop) {
        String belongEntityCode = this.getBelongEntityCode(prop);
        HashSet<String> fieldValSet = new HashSet<String>();
        if (prop instanceof BasedataProp) {
            Arrays.stream(this.currHandleBatchData).map(dyc -> dyc.getString(fieldName)).forEach(fieldVal -> fieldValSet.add((String)fieldVal));
            String fieldNameCopy = this.midTblField2EntityField(entityFieldMap, fieldName);
            String entityType = ((BasedataProp)entityFieldMap.get(fieldNameCopy)).getBaseEntityId();
            this.baseDataMapSetVal(fieldValSet, entityType, fieldNameCopy, belongEntityCode);
        } else if (prop instanceof MulBasedataProp) {
            Arrays.stream(this.currHandleBatchData).map(dyc -> dyc.getString(fieldName) + "," + dyc.getString(fieldName + "_tag")).forEach(fieldVal -> fieldValSet.addAll(new HashSet(Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)fieldVal)))));
            String fieldNameCopy = this.midTblField2EntityField(entityFieldMap, fieldName);
            String entityType = ((MulBasedataProp)entityFieldMap.get(fieldNameCopy)).getBaseEntityId();
            this.baseDataMapSetVal(fieldValSet, entityType, fieldNameCopy, belongEntityCode);
        }
    }

    protected abstract String getBelongEntityCode(IDataEntityProperty var1);

    private String midTblField2EntityField(Map<String, IDataEntityProperty> entityFieldMap, String fieldName) {
        IDataEntityProperty property = entityFieldMap.get(fieldName);
        String fieldVal = this.midTblAndEntityMappingMap.get(fieldName);
        if (property == null && HRStringUtils.isNotEmpty((String)fieldVal)) {
            ArrayList entryFieldNameList = Lists.newArrayList((Iterable)Splitter.on((String)".").trimResults().omitEmptyStrings().splitToList((CharSequence)fieldVal));
            return (String)entryFieldNameList.get(1);
        }
        return fieldName;
    }

    private String midTblField2EntityField(String fieldName) {
        String fieldVal = this.midTblAndEntityMappingMap.get(fieldName);
        if (HRStringUtils.isNotEmpty((String)fieldVal)) {
            ArrayList entryFieldNameList = Lists.newArrayList((Iterable)Splitter.on((String)".").trimResults().omitEmptyStrings().splitToList((CharSequence)fieldVal));
            return (String)entryFieldNameList.get(1);
        }
        return fieldName;
    }

    private String entityField2MidTblField(IDataEntityProperty property) {
        String propertyName = property.getName();
        String belongEntityName = property.getParent().getName();
        Optional<String> midTblFieldName = this.midTblAndEntityMappingMap.entrySet().stream().filter(entry -> {
            List entityFieldList = Splitter.on((String)".").splitToList((CharSequence)entry.getValue());
            return HRStringUtils.equals((String)((String)entityFieldList.get(0)), (String)belongEntityName) && HRStringUtils.equals((String)((String)entityFieldList.get(1)), (String)propertyName);
        }).map(entry -> (String)entry.getKey()).findFirst();
        if (midTblFieldName.isPresent()) {
            return midTblFieldName.get();
        }
        return propertyName;
    }
}

