/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.mservice.handle;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.mservice.handle.AbstractInitMidOpHandle;

public class InitMidTblOpHandleForQueryEntity
extends AbstractInitMidOpHandle {
    private QueryEntityType queryEntityType;
    private Map<String, Map<String, IDataEntityProperty>> queryEntityFieldMap;

    public InitMidTblOpHandleForQueryEntity(String entityCode, String bussinessKey, QueryEntityType queryEntityType, String midTableNumber) {
        super(entityCode, bussinessKey, (MainEntityType)queryEntityType, midTableNumber);
        this.queryEntityType = queryEntityType;
    }

    @Override
    protected void init() {
        this.handleEntityFiled();
        this.handleMidTblField();
    }

    private void handleMidTblField() {
        this.midTblProps.stream().map(pro -> pro.getName()).filter(pro -> !HRStringUtils.equals((String)pro, (String)"id")).forEach(midTblField -> this.queryEntityFieldMap.entrySet().forEach(entity -> {
            Map entityFieldMap = (Map)entity.getValue();
            for (String key : entityFieldMap.keySet()) {
                if (!HRStringUtils.equals((String)midTblField, (String)key)) continue;
                this.midTableFieldSet.add(midTblField);
                return;
            }
            if (this.midTblAndEntityMappingMap.containsKey(midTblField)) {
                this.midTableFieldSet.add(midTblField);
            }
        }));
    }

    private void handleEntityFiled() {
        this.queryEntityFieldMap = new HashMap<String, Map<String, IDataEntityProperty>>();
        ArrayList<String> entityNameList = new ArrayList<String>();
        entityNameList.add(this.queryEntityType.getEntityName());
        List joinEntitys = this.queryEntityType.getJoinEntitys();
        if (!CollectionUtils.isEmpty((Collection)joinEntitys)) {
            joinEntitys.forEach(entity -> entityNameList.add(entity.getEntityName()));
        }
        entityNameList.forEach(entityName -> {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
            Map<String, IDataEntityProperty> billHeadFieldMap = dataEntityType.getProperties().stream().collect(Collectors.toMap(IMetadata::getName, pro -> pro));
            this.queryEntityFieldMap.put((String)entityName, billHeadFieldMap);
        });
    }

    @Override
    protected void structBizEntity() {
        HashMap midTblDataMap = Maps.newHashMap();
        Stream.of(this.currHandleBatchData).forEach(dy -> this.distributeMainEntity((DynamicObject)dy, midTblDataMap));
        long[] ids = ORM.create().genLongIds(this.entityCode, midTblDataMap.size());
        int index = 0;
        for (Map.Entry it : midTblDataMap.entrySet()) {
            DynamicObject midDyc = (DynamicObject)((List)it.getValue()).get(0);
            DynamicObject bizDyc = new DynamicObject((DynamicObjectType)this.queryEntityType, true);
            String mainEntityName = this.queryEntityType.getEntityName();
            Map<String, IDataEntityProperty> mainEntityMap = this.queryEntityFieldMap.get(mainEntityName);
            this.midTableObject2EntityObject(midDyc, mainEntityName, bizDyc, mainEntityMap);
            this.queryEntityFieldMap.entrySet().forEach(entity -> {
                String entityName = (String)entity.getKey();
                if (HRStringUtils.equals((String)entityName, (String)mainEntityName)) {
                    return;
                }
                DynamicObject joinBizDyc = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName));
                Map entityFieldMap = (Map)entity.getValue();
                this.midTableObject2EntityObject(midDyc, entityName, joinBizDyc, entityFieldMap);
                bizDyc.set(entityName, (Object)joinBizDyc);
            });
            HashSet<Long> midTblIdSet = new HashSet<Long>();
            midTblIdSet.add(midDyc.getLong("id"));
            long id = this.getId((List)it.getValue(), ids[index++]);
            bizDyc.set("id", (Object)id);
            this.pkRelMap.put(id, midTblIdSet);
            this.entityDycList.add(bizDyc);
        }
    }

    private void midTableObject2EntityObject(DynamicObject midDyc, String entityName, DynamicObject joinBizDyc, Map<String, IDataEntityProperty> entityFieldMap) {
        Set<String> entityFieldNameSet = entityFieldMap.keySet();
        this.midTableFieldSet.forEach(midTblField -> {
            if (entityFieldNameSet.contains(midTblField)) {
                this.valueConvert(midDyc, joinBizDyc, (IDataEntityProperty)entityFieldMap.get(midTblField));
            } else {
                String entityFieldPath = (String)this.midTblAndEntityMappingMap.get(midTblField);
                if (HRStringUtils.isEmpty((String)entityFieldPath) || !entityFieldPath.contains(entityName)) {
                    return;
                }
                List entryFieldNameList = Splitter.on((String)".").trimResults().omitEmptyStrings().splitToList((CharSequence)entityFieldPath);
                this.valueConvert(midDyc, joinBizDyc, (IDataEntityProperty)entityFieldMap.get(entryFieldNameList.get(1)));
            }
        });
    }

    @Override
    protected void loadBasedata() {
        this.queryEntityFieldMap.entrySet().forEach(entity -> {
            String entityName = (String)entity.getKey();
            Map entityFieldMap = (Map)entity.getValue();
            entityFieldMap.entrySet().forEach(pro -> {
                String fieldName = (String)pro.getKey();
                IDataEntityProperty fieldProp = (IDataEntityProperty)pro.getValue();
                if (this.midTableFieldSet.contains(fieldName)) {
                    this.handleBaseDataOrMulBaseData(entityFieldMap, fieldName, fieldProp);
                    return;
                }
                this.midTblAndEntityMappingMap.entrySet().forEach(entry -> {
                    String midTbleFieldAlias = (String)entry.getKey();
                    String path = (String)entry.getValue();
                    if (path.contains(entityName + "." + fieldName)) {
                        this.handleBaseDataOrMulBaseData(entityFieldMap, midTbleFieldAlias, fieldProp);
                        return;
                    }
                });
            });
        });
    }

    @Override
    protected String getBelongEntityCode(IDataEntityProperty prop) {
        return prop.getParent().getName();
    }
}

