/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrobs.business.domain.repository;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hrmp.hrobs.business.domain.repository.PortalSchemeRepository;
import kd.hrmp.hrobs.common.enums.TerminalEnum;

public class PortalSchemeLayoutRepository
extends HRBaseServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(PortalSchemeLayoutRepository.class);
    private static final PortalSchemeLayoutRepository REPOSITORY = new PortalSchemeLayoutRepository("hrobs_schemelayout");

    public PortalSchemeLayoutRepository(String entityName) {
        super(entityName);
    }

    public static PortalSchemeLayoutRepository getRepository() {
        return REPOSITORY;
    }

    public DynamicObject findPortalSchemeLayout(TerminalEnum terminal, String selectProperties) {
        DynamicObject portalScheme = PortalSchemeRepository.getRepository().matchPortalScheme();
        long portalSchemeId = portalScheme.getLong("id");
        LOGGER.info("PortalSchemeLayoutRepository_matchPortalScheme_portalSchemeId :{}", (Object)portalSchemeId);
        long userId = RequestContext.get().getCurrUserId();
        QFilter[] filters = new QFilter[]{new QFilter("portalscheme", "=", (Object)portalSchemeId), new QFilter("user", "=", (Object)userId), new QFilter("terminal", "=", (Object)terminal.getValue()), new QFilter("iscustomlayout", "=", (Object)true)};
        DynamicObject portalSchemeLayout = selectProperties == null ? REPOSITORY.loadDynamicObject(filters) : REPOSITORY.queryOne(selectProperties, filters);
        LOGGER.info("user custom portalSchemeId :{}", (Object)portalSchemeLayout);
        if (HRObjectUtils.isEmpty((Object)portalSchemeLayout)) {
            filters = new QFilter[]{new QFilter("portalscheme", "=", (Object)portalSchemeId), new QFilter("terminal", "=", (Object)terminal.getValue()), new QFilter("iscustomlayout", "=", (Object)false)};
            portalSchemeLayout = selectProperties == null ? REPOSITORY.loadDynamicObject(filters) : REPOSITORY.queryOne(selectProperties, filters);
            LOGGER.info("default_portalSchemeId :{}", (Object)portalSchemeLayout);
        }
        LOGGER.info("PortalSchemeLayoutRepository_portalSchemeLayout :{}", (Object)portalSchemeLayout);
        return portalSchemeLayout;
    }

    public DynamicObject[] findPortalSchemeLayoutByCardId(Long cardId) {
        QFilter filter = new QFilter("entryentity.card", "=", (Object)cardId);
        return REPOSITORY.loadDynamicObjectArray(new QFilter[]{filter});
    }

    public DynamicObject[] findPortalSchemeLayoutBySchemeIds(List<Long> schemeIds) {
        QFilter sfilter = new QFilter("portalscheme", "in", schemeIds);
        return PortalSchemeLayoutRepository.getRepository().query(new QFilter[]{sfilter});
    }

    public DynamicObject[] findPortalSchemeLayoutByCardLayoutId(Long cardlayoutid) {
        QFilter sfilter = new QFilter("entryentity.id", "=", (Object)cardlayoutid);
        return PortalSchemeLayoutRepository.getRepository().query(new QFilter[]{sfilter});
    }
}

