/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrobs.business.domain.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hrobs.business.domain.repository.ProcessConfigRepository;
import kd.hrmp.hrobs.common.enums.TerminalEnum;

public class WorkFlowToHandleTaskRepository
extends HRBaseServiceHelper {
    private static final WorkFlowToHandleTaskRepository REPOSITORY = new WorkFlowToHandleTaskRepository("hrobs_tohandletask");

    public WorkFlowToHandleTaskRepository(String entityName) {
        super(entityName);
    }

    public static WorkFlowToHandleTaskRepository getRepository() {
        return REPOSITORY;
    }

    public int getPortalToHandleCount(Long userId, List<String> entityNumbers, TerminalEnum terminal) {
        QFilter[] filters = this.buildFilters(userId, entityNumbers, terminal);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(Arrays.asList(filters));
        return this.count(this.getEntityName(), filterList.toArray(new QFilter[0]));
    }

    public List<Long> getTaskIds(Long userId, List<String> entityNumbers, TerminalEnum terminal) {
        QFilter[] filters = this.buildFilters(userId, entityNumbers, terminal);
        DynamicObject[] dynamicObjects = this.query(filters);
        if (dynamicObjects.length == 0) {
            return new ArrayList<Long>();
        }
        return Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    public QFilter[] buildFilters(Long userId, List<String> entityNumbers, TerminalEnum terminal) {
        if (userId == null) {
            userId = RequestContext.get().getCurrUserId();
        }
        if (entityNumbers == null || entityNumbers.size() == 0) {
            entityNumbers = ProcessConfigRepository.getRepository().queryAllBusinessObjectNumbers();
        }
        return new QFilter[]{new QFilter("wf_participant.userid", "=", (Object)userId), new QFilter("wf_participant.compositetaskid", "=", (Object)0L), new QFilter("entitynumber", "in", entityNumbers), new QFilter("display", "=", (Object)"1"), new QFilter("endtype", "!=", (Object)(terminal == TerminalEnum.MOBILE ? "pc" : "mobile"))};
    }

    public DynamicObject queryByPkValue(Object pkValue) {
        return this.loadDynamicObject(new QFilter("id", "=", pkValue));
    }
}

