/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrobs.business.domain.service.portal.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hrmp.hrobs.business.domain.repository.AppConfigRepository;
import kd.hrmp.hrobs.business.domain.service.portal.IAppConfigService;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class AppConfigServiceImpl
implements IAppConfigService {
    private static final Log LOGGER = LogFactory.getLog(AppConfigServiceImpl.class);
    private static final String APP = "app";
    private static final String INDEX = "index";
    private static final String CARDLAYOUTID = "cardlayoutid";
    private static final String APP_ID = "app.id";

    @Override
    public List<Map<String, Object>> getCardLayoutApps(String terminal, Long cardId, Long cardLayoutId) {
        DynamicObject[] hrobsCardLayoutApp = this.getHrobsCardLayoutApp(cardLayoutId);
        List cardLayoutApps = Arrays.stream(hrobsCardLayoutApp).sorted(Comparator.comparing(e -> e.get(INDEX).toString())).collect(Collectors.toList());
        List appConfigs = cardLayoutApps.stream().filter(Objects::nonNull).map(entity -> entity.getDynamicObject(APP)).collect(Collectors.toList());
        List<Long> appConfigIds = appConfigs.stream().filter(Objects::nonNull).map(entity -> entity.getLong("id")).collect(Collectors.toList());
        LOGGER.info("getCardLayoutApps.appConfigIds: {}", appConfigIds);
        DynamicObject[] appConfigsByIds = this.getAppConfigsByIds(appConfigIds, terminal);
        LOGGER.info("getCardLayoutApps.appConfigsByIds: {}", (Object)appConfigsByIds);
        ArrayList appConfigMapList = new ArrayList();
        for (DynamicObject appConfig : appConfigsByIds) {
            HashMap<String, Object> appConfigMap2 = new HashMap<String, Object>(16);
            Optional<DynamicObject> layOutApp = Arrays.stream(hrobsCardLayoutApp).filter(Objects::nonNull).filter(a -> a.getDynamicObject(APP) != null && a.getDynamicObject(APP).get("id").equals(appConfig.get("id"))).findFirst();
            if (layOutApp.isPresent()) {
                appConfigMap2.put(INDEX, layOutApp.get().get(INDEX));
            } else {
                appConfigMap2.put(INDEX, 0);
            }
            appConfigMap2.put("number", appConfig.get("number"));
            appConfigMap2.put("id", appConfig.get("id"));
            appConfigMap2.put("name", appConfig.get("name"));
            appConfigMap2.put("appsource", appConfig.get("appsource"));
            appConfigMap2.put("systemicon", appConfig.get("systemicon"));
            Optional<DynamicObject> optional = appConfig.getDynamicObjectCollection("entryentity").stream().filter(entity -> StringUtils.equals((String)entity.getString("terminal"), (String)terminal)).findFirst();
            if (!optional.isPresent()) continue;
            DynamicObject entryentity = optional.get();
            if (StringUtils.isEmpty((String)entryentity.getString("businessobjecttype"))) {
                appConfigMap2.put("businessobjecttype", "0");
            } else {
                appConfigMap2.put("businessobjecttype", entryentity.getString("businessobjecttype"));
            }
            DynamicObject form = (DynamicObject)entryentity.get("form");
            if (ObjectUtils.isEmpty((Object)form)) {
                LOGGER.info("form is null ,appInfo:{}", appConfigMap2);
                if (!appConfig.get("appsource").equals("1") || !StringUtils.isNotBlank((String)entryentity.getString("url"))) continue;
                appConfigMap2.put("formId", appConfig.get("number"));
                appConfigMapList.add(appConfigMap2);
                continue;
            }
            appConfigMap2.put("formId", form.get("number"));
            appConfigMap2.put("entryentity.params_tag", entryentity.get("params_tag"));
            String modelType = form.getString("modeltype");
            appConfigMap2.put("modeltype", modelType);
            appConfigMapList.add(appConfigMap2);
        }
        LOGGER.warn("getCardLayoutApps.hrobsAppList: {}", appConfigMapList);
        return appConfigMapList.stream().sorted(Comparator.comparing(appConfigMap -> (Integer)appConfigMap.get(INDEX))).collect(Collectors.toList());
    }

    private DynamicObject[] getAppConfigsByIds(List<Long> appConfigIds, String terminal) {
        String entityName = "hrobs_appconfig";
        String selectProperties = String.join((CharSequence)",", "entryentity.params_tag", "number", "name", "appsource", "systemicon", "form", "terminal", "businessobjecttype", "entryentity.url");
        QFilter eFilter = new QFilter("enable", "=", (Object)"1");
        QFilter iFilter = new QFilter("id", "in", appConfigIds);
        QFilter tFilter = new QFilter("entryentity.terminal", "=", (Object)terminal);
        return BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, (QFilter[])new QFilter[]{eFilter, tFilter, iFilter});
    }

    private DynamicObject[] getHrobsCardLayoutApp(Long cardLayoutId) {
        String selectProperties = String.join((CharSequence)",", CARDLAYOUTID, APP, INDEX);
        String entityName = "hrobs_cardlayoutapp";
        QFilter filter = new QFilter(CARDLAYOUTID, "=", (Object)cardLayoutId.toString());
        return BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, (QFilter[])new QFilter[]{filter});
    }

    @Override
    public String getCardTitle(Long cardId) {
        String entityName = "hrobs_card";
        String selectProperties = String.join((CharSequence)",", "name");
        QFilter filter = new QFilter("id", "=", (Object)cardId);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, (QFilter[])new QFilter[]{filter});
        return dynamicObjects[0].get("name").toString();
    }

    @Override
    public Map<String, Object> getCustomParams(Long appConfigId, String terminal) {
        String entityName = "hrobs_appconfig";
        String selectProperties = String.join((CharSequence)",", "entryentity.params_tag", "number", "entryentity.terminal");
        QFilter nFilter = new QFilter("id", "=", (Object)appConfigId);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)entityName, (String)selectProperties, (QFilter[])new QFilter[]{nFilter});
        if (ObjectUtils.isNotEmpty((Object)dynamicObject)) {
            Optional<DynamicObject> entryentityOptional = dynamicObject.getDynamicObjectCollection("entryentity").stream().filter(entity -> StringUtils.equals((String)entity.getString("terminal"), (String)terminal)).findFirst();
            if (!entryentityOptional.isPresent()) {
                return null;
            }
            DynamicObject entryentity = entryentityOptional.get();
            if (ObjectUtils.isNotEmpty((Object)entryentity.get("params_tag"))) {
                return HRJSONUtils.convertJSONObjectToMap((Object)entryentity.get("params_tag"));
            }
        }
        return null;
    }

    @Override
    public Map<String, Object> getAppConfigById(Long appConfigId, String terminal) {
        String entityName = "hrobs_appconfig";
        String selectProperties = String.join((CharSequence)",", "entryentity", "entryentity.params_tag", "number", "name", "appsource", "systemicon", "entryentity.url", "terminal", "url");
        QFilter eFilter = new QFilter("enable", "=", (Object)"1");
        QFilter tFilter = new QFilter("entryentity.terminal", "=", (Object)terminal);
        QFilter nFilter = new QFilter("id", "=", (Object)appConfigId);
        DynamicObject appConfigDy = BusinessDataServiceHelper.loadSingle((String)entityName, (String)selectProperties, (QFilter[])new QFilter[]{eFilter, tFilter, nFilter});
        Optional<DynamicObject> optional = appConfigDy.getDynamicObjectCollection("entryentity").stream().filter(entity -> StringUtils.equals((String)entity.getString("terminal"), (String)terminal)).findFirst();
        if (!optional.isPresent()) {
            return null;
        }
        DynamicObject appConfigDynamicObject = optional.get();
        HashMap<String, Object> appConfigMap = new HashMap<String, Object>(16);
        appConfigMap.put("entryentity.url", appConfigDynamicObject.get("url"));
        appConfigMap.put("entryentity.params_tag", appConfigDynamicObject.get("params_tag"));
        appConfigMap.put("number", appConfigDy.get("number"));
        appConfigMap.put("name", appConfigDy.get("name"));
        appConfigMap.put("appsource", appConfigDy.get("appsource"));
        appConfigMap.put("systemicon", appConfigDy.get("systemicon"));
        return appConfigMap;
    }

    @Override
    public DynamicObject[] getAppConfigByIds(List<Long> ids) {
        return AppConfigRepository.getRepository().query(ids);
    }

    @Override
    public List<String> getHrAppIds() {
        HRBaseServiceHelper appServiceHelper = new HRBaseServiceHelper("hbss_cloud_app");
        DynamicObject[] apps = appServiceHelper.loadDynamicObjectArray(new QFilter[0]);
        if (apps.length == 0) {
            LOGGER.info("apps is empty");
            return new ArrayList<String>(0);
        }
        List<String> bizAppIds = Arrays.stream(apps).filter(app -> ObjectUtils.isNotEmpty((Object)app.get(APP_ID))).map(e -> String.valueOf(e.get(APP_ID))).collect(Collectors.toList());
        LOGGER.info("appIds:{}", bizAppIds);
        if (!CollectionUtils.isEmpty(bizAppIds)) {
            HRBaseServiceHelper bizAppServiceHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
            DynamicObject[] bizApps = bizAppServiceHelper.query("id", new QFilter[]{new QFilter("masterid", "in", bizAppIds).or(new QFilter("id", "in", bizAppIds))});
            bizAppIds = Arrays.stream(bizApps).map(e -> String.valueOf(e.get("id"))).collect(Collectors.toList());
            LOGGER.info("bizAppIds:{}", bizAppIds);
        }
        return bizAppIds;
    }
}

