/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrobs.business.domain.service.portal.impl;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hrmp.hrobs.business.domain.service.portal.IEmpInfoService;

public class EmpInfoServiceImpl
implements IEmpInfoService {
    private static final Log LOGGER = LogFactory.getLog(EmpInfoServiceImpl.class);
    private static final String EMPLOYEE = "employee";
    private static final String IHSPM_SERVICE = "IHSPMService";
    private static final String GET_PRIMARY_ERMANF_FILE = "getPrimaryErmanfFile";
    private static final String IHRPI_EMPLOYEE_SERVICE = "IHRPIEmployeeService";
    private static final String CHECK_EMPLOYEE_STATUS = "checkEmployeeStatus";
    private static final String GET_PERSON_MODEL_ID = "getPersonModelId";
    private static final String DATA = "data";
    private static final String HSPM = "hspm";
    private static final String GET_CARD_FIELDS = "getCardFields";

    @Override
    public Map<String, Object> getPersonInfo() {
        Map<String, Long> personModel = this.getPersonModelId();
        if (personModel == null) {
            LOGGER.info("EmpInfoService,personModelId is null");
            return null;
        }
        Long startTime = System.currentTimeMillis();
        DynamicObject ermanFileDy = (DynamicObject)HRMServiceHelper.invokeHRService((String)HSPM, (String)IHSPM_SERVICE, (String)GET_PRIMARY_ERMANF_FILE, (Object[])new Object[]{personModel.get("person")});
        if (ermanFileDy == null) {
            LOGGER.info("EmpInfoService,ermanFileDy is null");
            return null;
        }
        List cardFieldsList = (List)HRMServiceHelper.invokeHRService((String)HSPM, (String)IHSPM_SERVICE, (String)GET_CARD_FIELDS, (Object[])new Object[]{Collections.singletonList(ermanFileDy.get("id"))});
        Long endTime = System.currentTimeMillis();
        LOGGER.info("PcEmpInfoPlugin_hspm total time : {}", (Object)(endTime - startTime));
        if (cardFieldsList.size() < 1) {
            LOGGER.info("EmpInfoService,ermanInfo is null");
            return null;
        }
        Map cardFields = (Map)cardFieldsList.get(0);
        HashMap<String, Object> personInfoMap = new HashMap<String, Object>(16);
        Date startDate = (Date)cardFields.get("startdate");
        personInfoMap.put("name", cardFields.get("name"));
        personInfoMap.put("headsculpture", cardFields.get("headsculpture"));
        personInfoMap.put("startdate", startDate);
        personInfoMap.put("company", cardFields.get("company"));
        personInfoMap.put("adminorg", cardFields.get("adminorg"));
        personInfoMap.put("position", cardFields.get("position"));
        personInfoMap.put("job", cardFields.get("job"));
        personInfoMap.put("stdposition", cardFields.get("stdposition"));
        personInfoMap.put("apositiontype", cardFields.get("apositiontype"));
        return personInfoMap;
    }

    @Override
    public Map<String, Object> empValidate() {
        Map<String, Long> personModelId = this.getPersonModelId();
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("boolean", Boolean.TRUE);
        if (personModelId == null || personModelId.get(EMPLOYEE) == null || personModelId.get(EMPLOYEE) == 0L) {
            LOGGER.info("empInfoValidate======personModelId.get(EMPLOYEE):{}", personModelId != null ? personModelId.get(EMPLOYEE) : null);
            String errMsg = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e3a\u201c\u975eHR\u4eba\u5458\u201d\uff0c\u65e0\u6cd5\u6b63\u5e38\u4f7f\u7528HR\u81ea\u52a9\u670d\u52a1\u3002", (String)"EmpInfoServiceImpl_0", (String)"hrmp-hrobs-business", (Object[])new Object[0]);
            map.put("boolean", Boolean.FALSE);
            map.put("errMsg", errMsg);
            return map;
        }
        Boolean isEmployee = this.isEmployee(personModelId.get(EMPLOYEE));
        if (!isEmployee.booleanValue()) {
            String errMsg = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u5df2\u79bb\u804c\uff0c\u65e0\u6cd5\u6b63\u5e38\u4f7f\u7528HR\u81ea\u52a9\u670d\u52a1\u3002", (String)"EmpInfoServiceImpl_1", (String)"hrmp-hrobs-business", (Object[])new Object[0]);
            map.put("boolean", Boolean.FALSE);
            map.put("errMsg", errMsg);
        }
        return map;
    }

    @Override
    public Map<String, Long> getPersonModelId() {
        Map personModelIdMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)GET_PERSON_MODEL_ID, (Object[])new Object[0]);
        Map personModelInfo = personModelIdMap != null ? (Map)personModelIdMap.get(DATA) : null;
        LOGGER.info(MessageFormat.format("EmpInfoService====getPersonId,personInfo = {0}", personModelInfo));
        return personModelInfo;
    }

    private Boolean isEmployee(Long employeeId) {
        Map empAppMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)IHRPI_EMPLOYEE_SERVICE, (String)CHECK_EMPLOYEE_STATUS, (Object[])new Object[]{Collections.singletonList(employeeId), EMPLOYEE});
        LOGGER.info("empInfoValidate======isEmployee: {}", (Object)empAppMap);
        return (Boolean)empAppMap.get(employeeId);
    }
}

