/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrobs.business.domain.service.process.impl;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.hrmp.hrobs.business.domain.repository.ProcessConfigRepository;
import kd.hrmp.hrobs.business.domain.repository.WorkFlowAppliedRepository;
import kd.hrmp.hrobs.business.domain.repository.WorkFlowHandledTaskRepository;
import kd.hrmp.hrobs.business.domain.repository.WorkFlowToApplyRepository;
import kd.hrmp.hrobs.business.domain.repository.WorkFlowToHandleTaskRepository;
import kd.hrmp.hrobs.business.domain.service.process.IMessageCenterService;
import kd.hrmp.hrobs.common.enums.ProcessTypeEnum;
import kd.hrmp.hrobs.common.enums.TerminalEnum;

public class MessageCenterServiceImpl
implements IMessageCenterService {
    @Override
    public int getTaskCountByType(ProcessTypeEnum processType, TerminalEnum terminal, Long userId) {
        if (userId == null) {
            userId = RequestContext.get().getCurrUserId();
        }
        if (userId == 0L) {
            return 0;
        }
        List<String> businessObjectNumbers = ProcessConfigRepository.getRepository().queryAllBusinessObjectNumbers();
        if (businessObjectNumbers.size() == 0) {
            return 0;
        }
        switch (processType) {
            case TO_HANDLE: {
                return WorkFlowToHandleTaskRepository.getRepository().getPortalToHandleCount(userId, businessObjectNumbers, terminal);
            }
            case HANDLED: {
                return WorkFlowHandledTaskRepository.getRepository().getPortalHandledCount(userId, businessObjectNumbers, terminal);
            }
            case TO_APPLY: {
                return WorkFlowToApplyRepository.getRepository().getPortalToApplyCount(userId, businessObjectNumbers);
            }
            case APPLIED: {
                return WorkFlowAppliedRepository.getRepository().getPortalAppliedCount(userId, businessObjectNumbers);
            }
        }
        return 0;
    }

    @Override
    public String getDisplayCount(int count) {
        return count > 99 ? "99+" : count + "";
    }
}

