/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrobs.business.domain.task;

import java.util.Arrays;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrobs.business.domain.repository.AppConfigRepository;
import kd.hrmp.hrobs.business.domain.utils.ScheduleTaskUtil;

public class AppFormIdUpdateTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(AppFormIdUpdateTask.class);
    private static final String SCHEDULE_TASK_ID = "3IDN1VO4IVQX";

    public void execute(RequestContext requestContext, Map<String, Object> map) {
        LOGGER.info("AppFormIdUpdateTask start");
        AppConfigRepository repository = AppConfigRepository.getRepository();
        DynamicObject[] apps = repository.query(String.join((CharSequence)",", "entryentity.form", "entryentity.businessobject"), new QFilter[0]);
        if (apps.length == 0) {
            LOGGER.info("apps is empty");
            return;
        }
        Arrays.stream(apps).forEach(app -> {
            DynamicObjectCollection entryEntities = app.getDynamicObjectCollection("entryentity");
            if (entryEntities.isEmpty()) {
                return;
            }
            entryEntities.stream().filter(entryEntity -> HRStringUtils.isNotEmpty((String)entryEntity.getString("businessobject"))).forEach(entryEntity -> entryEntity.set("form", (Object)entryEntity.getString("businessobject.dentityid")));
        });
        repository.update(apps);
        ScheduleTaskUtil.disableTask(SCHEDULE_TASK_ID);
        LOGGER.info("AppFormIdUpdateTask end");
    }
}

