/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrobs.formplugin.appconfig;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.svc.picture.IImage;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrobs.business.domain.service.portal.IAppConfigService;
import org.apache.commons.lang3.ObjectUtils;

public class AppConfigFormPlugin
extends AbstractFormPlugin
implements CellClickListener,
BeforeF7SelectListener {
    public static final String VALUE = "value";
    public static final String IDE_PICTURESELECTOR = "ide_pictureselector";
    private static final Log LOGGER = LogFactory.getLog(AppConfigFormPlugin.class);
    public static final String PARAMETER_CALL_BACK = "parameterCallBack";
    public static final String PIC_CALL_BACK = "picCallBack";
    public static final String XZICON_96_96_PNG = "/icons/pc/other/hr_xzicon_96_96.png";
    public static final String APPSOURCE_CONFIRM_CALLBACK = "appsource_confirm_callback";
    public static final String CHANGE_TYPE = "changeType";
    public static final String IMAGEAP = "imageap";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        HashSet sets = new HashSet();
        Collections.addAll(sets, OperationStatus.ADDNEW, OperationStatus.VIEW, OperationStatus.EDIT);
        OperationStatus status = parameter.getStatus();
        if (sets.contains(status)) {
            DynamicObject dataEntity = model.getDataEntity();
            DynamicObjectCollection objectList = dataEntity.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < objectList.size(); ++i) {
                ((DynamicObject)objectList.get(i)).set("terminal", (Object)i);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        String appSource = dataEntity.getString("appsource");
        this.setVisible(appSource);
        this.setImageAp(dataEntity.getString("systemicon"));
        DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("entryentity");
        LOGGER.info("AppConfigFormPlugin_entryentity:{}", (Object)entryentity.size());
        if (entryentity.size() < 2) {
            DynamicObject dynamicObject = (DynamicObject)entryentity.get(0);
            if (dynamicObject.get("terminal").equals("0")) {
                int index = model.createNewEntryRow("entryentity");
                model.setValue("terminal", (Object)"1", index);
            } else {
                DynamicObject object = (DynamicObject)entryentity.get(0);
                model.deleteEntryRow("entryentity", 0);
                int row = model.createNewEntryRow("entryentity");
                model.setValue("terminal", (Object)"0", row);
                model.createNewEntryRow("entryentity", 1, object);
            }
        }
    }

    private void setImageAp(String imageUrl) {
        IImage imageAp = (IImage)this.getControl(IMAGEAP);
        if (ObjectUtils.isNotEmpty((Object)imageUrl)) {
            imageAp.setUrl(imageUrl);
        }
    }

    private void selectImage(boolean isSysPreset) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(IDE_PICTURESELECTOR);
        if (isSysPreset) {
            parameter.setStatus(OperationStatus.VIEW);
        } else {
            parameter.setStatus(this.getView().getFormShowParameter().getStatus());
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, PIC_CALL_BACK);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    public void validate(BeforeDoOperationEventArgs args) {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        String systemIcon = dataEntity.getString("systemicon");
        if (StringUtils.isEmpty((CharSequence)systemIcon) || XZICON_96_96_PNG.equals(systemIcon)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5e94\u7528\u56fe\u6807\u4e0d\u80fd\u4e3a\u7a7a", (String)"AppConfigFormPlugin_0", (String)"hrmp-hrobs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        } else {
            DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
            String appSource = dataEntity.getString("appsource");
            if (ObjectUtils.isEmpty((Object)entryEntity) || entryEntity.size() < 2) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5e94\u7528\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6ce8\u518c\u5e94\u7528\u65f6\u81f3\u5c11\u5c01\u88c5\u4e00\u4e2a\u7ec8\u7aef\u7684\u914d\u7f6e\u4fe1\u606f\u3002", (String)"AppConfigFormPlugin_1", (String)"hrmp-hrobs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else if (entryEntity.size() == 2) {
                DynamicObject pcEntry = (DynamicObject)entryEntity.get(0);
                pcEntry.getDataEntityState().setBizChanged(true);
                boolean pcRemark = ObjectUtils.isEmpty((Object)pcEntry.get("remark"));
                boolean pcForm = ObjectUtils.isEmpty((Object)pcEntry.get("form"));
                boolean pcBusinessObjectType = ObjectUtils.isEmpty((Object)pcEntry.get("businessobjecttype"));
                boolean pcParamsTag = ObjectUtils.isEmpty((Object)pcEntry.get("params_tag"));
                boolean pcUrl = ObjectUtils.isEmpty((Object)pcEntry.get("url"));
                DynamicObject mobEntry = (DynamicObject)entryEntity.get(1);
                mobEntry.getDataEntityState().setBizChanged(true);
                boolean mobRemark = ObjectUtils.isEmpty((Object)mobEntry.get("remark"));
                boolean mobForm = ObjectUtils.isEmpty((Object)mobEntry.get("form"));
                boolean mobBusinessObjectType = ObjectUtils.isEmpty((Object)mobEntry.get("businessobjecttype"));
                boolean mobParamsTag = ObjectUtils.isEmpty((Object)mobEntry.get("params_tag"));
                boolean mobUrl = ObjectUtils.isEmpty((Object)mobEntry.get("url"));
                if (HRObjectUtils.equals((Object)appSource, (Object)"0")) {
                    boolean mobBusTypeValid;
                    boolean pcBusValid = !pcRemark || !pcParamsTag || !pcBusinessObjectType;
                    boolean pcBusTypeValid = !pcRemark || !pcParamsTag || !pcForm;
                    boolean mobBusValid = !mobRemark || !mobParamsTag || !mobBusinessObjectType;
                    boolean bl = mobBusTypeValid = !mobRemark || !mobParamsTag || !mobForm;
                    if (pcRemark && mobRemark && pcForm && mobForm && pcBusinessObjectType && mobBusinessObjectType && pcParamsTag && mobParamsTag) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5e94\u7528\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6ce8\u518c\u5e94\u7528\u65f6\u81f3\u5c11\u5c01\u88c5\u4e00\u4e2a\u7ec8\u7aef\u7684\u914d\u7f6e\u4fe1\u606f\u3002", (String)"AppConfigFormPlugin_1", (String)"hrmp-hrobs-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                    } else if (pcBusValid && pcForm) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u670d\u52a1\u5904\u7406\u7ec8\u7aef\u5b58\u5728\u5fc5\u586b\u5b57\u6bb5\u4e3a\u7a7a\uff1a\u5904\u7406\u9875\u9762\u3002", (String)"AppConfigFormPlugin_2", (String)"hrmp-hrobs-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                    } else if (pcBusTypeValid && pcBusinessObjectType) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u670d\u52a1\u5904\u7406\u7ec8\u7aef\u5b58\u5728\u5fc5\u586b\u5b57\u6bb5\u4e3a\u7a7a\uff1a\u5bf9\u8c61\u7c7b\u578b\u3002", (String)"AppConfigFormPlugin_3", (String)"hrmp-hrobs-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                    } else if (mobBusValid && mobForm) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u670d\u52a1\u5904\u7406\u7ec8\u7aef\u5b58\u5728\u5fc5\u586b\u5b57\u6bb5\u4e3a\u7a7a\uff1a\u5904\u7406\u9875\u9762\u3002", (String)"AppConfigFormPlugin_2", (String)"hrmp-hrobs-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                    } else if (mobBusTypeValid && mobBusinessObjectType) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u670d\u52a1\u5904\u7406\u7ec8\u7aef\u5b58\u5728\u5fc5\u586b\u5b57\u6bb5\u4e3a\u7a7a\uff1a\u5bf9\u8c61\u7c7b\u578b\u3002", (String)"AppConfigFormPlugin_3", (String)"hrmp-hrobs-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                    }
                } else if (HRObjectUtils.equals((Object)appSource, (Object)"1")) {
                    if (pcRemark && mobRemark && pcUrl && mobUrl) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5e94\u7528\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6ce8\u518c\u5e94\u7528\u65f6\u81f3\u5c11\u5c01\u88c5\u4e00\u4e2a\u7ec8\u7aef\u7684\u914d\u7f6e\u4fe1\u606f\u3002", (String)"AppConfigFormPlugin_1", (String)"hrmp-hrobs-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                    } else if (!pcRemark && pcUrl) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u670d\u52a1\u5904\u7406\u7ec8\u7aef\u5b58\u5728\u5fc5\u586b\u5b57\u6bb5\u4e3a\u7a7a\uff1a\u8df3\u8f6c\u5730\u5740\u3002", (String)"AppConfigFormPlugin_7", (String)"hrmp-hrobs-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                    } else if (!mobRemark && mobUrl) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u670d\u52a1\u5904\u7406\u7ec8\u7aef\u5b58\u5728\u5fc5\u586b\u5b57\u6bb5\u4e3a\u7a7a\uff1a\u8df3\u8f6c\u5730\u5740\u3002", (String)"AppConfigFormPlugin_7", (String)"hrmp-hrobs-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                    }
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u5b9a\u4e49\u7684\u6570\u636e\u7c7b\u578b\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"AppConfigFormPlugin_5", (String)"hrmp-hrobs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"save") || HRStringUtils.equals((String)operateKey, (String)"edit")) {
            this.validate(args);
        } else if ("donothing_pic".equals(operateKey)) {
            boolean isSysPreset = this.getModel().getDataEntity().getBoolean("issyspreset");
            this.selectImage(isSysPreset);
            args.setCancel(true);
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addCellClickListener((CellClickListener)this);
        BasedataEdit formEdit = (BasedataEdit)this.getView().getControl("form");
        if (formEdit != null) {
            formEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map picMap;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        IDataModel model = this.getModel();
        if (PARAMETER_CALL_BACK.equalsIgnoreCase(actionId)) {
            if (ObjectUtils.isNotEmpty((Object)returnData)) {
                String jsonString = SerializationUtils.toJsonString((Object)returnData);
                model.setValue("params_tag", (Object)jsonString);
            } else if (returnData != null) {
                model.setValue("params_tag", null);
            }
        } else if (PIC_CALL_BACK.equalsIgnoreCase(actionId) && (picMap = (Map)returnData) != null) {
            String imageUrl = (String)picMap.get(VALUE);
            IImage backImageAp = (IImage)this.getControl(IMAGEAP);
            if (StringUtils.isNotBlank((CharSequence)imageUrl)) {
                backImageAp.setUrl(imageUrl);
                model.setValue("systemicon", (Object)imageUrl);
            } else {
                backImageAp.setUrl(XZICON_96_96_PNG);
                model.setValue("systemicon", (Object)"");
            }
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        super.beforePropertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if ("appsource".equals(property.getName())) {
            String appSource = dataEntity.getString("appsource");
            this.setVisible(appSource);
            IPageCache pageCache = this.getPageCache();
            String changeType = pageCache.get(CHANGE_TYPE);
            if (changeType != null) {
                pageCache.remove(CHANGE_TYPE);
                return;
            }
            ConfirmCallBackListener confirm = new ConfirmCallBackListener(APPSOURCE_CONFIRM_CALLBACK, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5e94\u7528\u6765\u6e90\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5e94\u7528\u914d\u7f6e\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"AppConfigFormPlugin_6", (String)"hrmp-hrobs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirm);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        IDataEntityProperty property = args.getProperty();
        if (HRStringUtils.equals((String)property.getName(), (String)"form")) {
            IDataModel dataModel = this.getModel();
            int entryCurrentRowIndex = dataModel.getEntryCurrentRowIndex("entryentity");
            DynamicObject form = (DynamicObject)dataModel.getValue("form", entryCurrentRowIndex);
            dataModel.setValue("businessobject", (Object)form.getString("number"), entryCurrentRowIndex);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        List bizAppIds;
        String fieldKey = evt.getProperty().getName();
        if (HRStringUtils.equals((String)fieldKey, (String)"form") && !CollectionUtils.isEmpty((Collection)(bizAppIds = IAppConfigService.getInstance().getHrAppIds()))) {
            evt.addCustomQFilter(new QFilter("bizappid", "in", (Object)bizAppIds));
        }
    }

    private void setVisible(String appSource) {
        IFormView view = this.getView();
        if ("1".equals(appSource)) {
            view.setVisible(Boolean.valueOf(true), new String[]{"url"});
            view.setVisible(Boolean.valueOf(false), new String[]{"form", "businessobjecttype", "params_tag"});
        } else if ("0".equals(appSource)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"url"});
            view.setVisible(Boolean.valueOf(true), new String[]{"form", "businessobjecttype", "params_tag"});
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        String callBackId = e.getCallBackId();
        String appsource = dataEntity.getString("appsource");
        if (APPSOURCE_CONFIRM_CALLBACK.equalsIgnoreCase(callBackId)) {
            if (MessageBoxResult.Yes.toString().equals(e.getResultValue())) {
                this.setModelProperty(appsource);
            } else {
                this.getPageCache().put(CHANGE_TYPE, "0");
                appsource = appsource.equals("0") ? "1" : "0";
                this.getModel().setValue("appsource", (Object)appsource);
                this.setVisible(appsource);
            }
        }
    }

    private void setModelProperty(String appSource) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        if ("1".equals(appSource)) {
            view.setVisible(Boolean.valueOf(true), new String[]{"url"});
            view.setVisible(Boolean.valueOf(false), new String[]{"form", "businessobjecttype", "params_tag"});
            for (int i = 0; i < entryEntity.size(); ++i) {
                this.setFieldsNull(Lists.newArrayList((Object[])new String[]{"businessobject", "form", "businessobjecttype", "remark", "params_tag"}), i);
            }
        } else if ("0".equals(appSource)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"url"});
            view.setVisible(Boolean.valueOf(true), new String[]{"form", "businessobjecttype", "params_tag"});
            for (int i = 0; i < entryEntity.size(); ++i) {
                this.setFieldsNull(Lists.newArrayList((Object[])new String[]{"url", "remark"}), i);
            }
        } else {
            view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u5b9a\u4e49\u7684\u6570\u636e\u7c7b\u578b\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"AppConfigFormPlugin_5", (String)"hrmp-hrobs-formplugin", (Object[])new Object[0]));
        }
    }

    private void setFieldsNull(List<String> fields, int index) {
        for (String field : fields) {
            this.getModel().setValue(field, null, index);
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        String fieldKey = cellClickEvent.getFieldKey();
        if ("params_tag".equalsIgnoreCase(fieldKey)) {
            this.showCustomParams(cellClickEvent.getRow(), fieldKey);
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        String fieldKey = cellClickEvent.getFieldKey();
        if ("params_tag".equalsIgnoreCase(fieldKey)) {
            this.showCustomParams(cellClickEvent.getRow(), cellClickEvent.getFieldKey());
        }
    }

    private void showCustomParams(int row, String fieldKey) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        OperationStatus parentStatus = parameter.getStatus();
        String originalParameter = (String)this.getModel().getValue("params_tag");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hrobs_customparams");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("params_tag", (Object)originalParameter);
        formShowParameter.setCustomParam("row", (Object)row);
        formShowParameter.setCustomParam("key", (Object)fieldKey);
        if (dataEntity.getBoolean("issyspreset")) {
            formShowParameter.setStatus(OperationStatus.VIEW);
        } else {
            formShowParameter.setStatus(parentStatus);
        }
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PARAMETER_CALL_BACK));
        this.getView().showForm(formShowParameter);
    }
}

