/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrobs.formplugin.appconfig;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.CollectionUtils;

public class CustomParamsPlugin
extends AbstractFormPlugin {
    public static final String NAME_REGEX = "^[A-Za-z][A-Za-z0-9_]*$";

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("donothing_btnok".equalsIgnoreCase(operateKey)) {
            this.returnData();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        int entryRowCount;
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        if ("newentry".equals(source.getOperateKey()) && (entryRowCount = this.getModel().getEntryRowCount("entryentity")) >= 99) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u8fbe\u5230\u5e94\u7528\u53c2\u6570\u4e2a\u6570\u4e0a\u9650%s\u4e2a\uff0c\u65e0\u6cd5\u7ee7\u7eed\u65b0\u589e\u3002", (String)"CustomParamsPlugin_4", (String)"hrmp-hrobs-formplugin", (Object[])new Object[]{99}));
            args.setCancel(true);
        }
    }

    private String validate(DynamicObjectCollection params) {
        String validateResult = null;
        if (CollectionUtils.isNotEmpty((Collection)params)) {
            int size = params.size();
            ArrayList<String> numbers = new ArrayList<String>(size);
            for (int i = 0; i < params.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)params.get(i);
                String name = dynamicObject.getString("paramname");
                String value = dynamicObject.getString("paramvalue");
                int row = i + 1;
                int index = numbers.indexOf(name);
                if (StringUtils.isEmpty((CharSequence)name) && StringUtils.isEmpty((CharSequence)value)) {
                    validateResult = String.format(ResManager.loadKDString((String)"\u53c2\u6570\u540d\u3001\u53c2\u6570\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CustomParamsPlugin_3", (String)"hrmp-hrobs-formplugin", (Object[])new Object[0]), row);
                } else if (StringUtils.isEmpty((CharSequence)name)) {
                    validateResult = String.format(ResManager.loadKDString((String)"\u53c2\u6570\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CustomParamsPlugin_2", (String)"hrmp-hrobs-formplugin", (Object[])new Object[0]), row);
                } else if (StringUtils.isEmpty((CharSequence)value)) {
                    validateResult = String.format(ResManager.loadKDString((String)"\u53c2\u6570\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CustomParamsPlugin_2", (String)"hrmp-hrobs-formplugin", (Object[])new Object[0]), row);
                } else if (!name.matches(NAME_REGEX)) {
                    validateResult = String.format(ResManager.loadKDString((String)"\u53c2\u6570\u540d\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u4e14\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"CustomParamsPlugin_0", (String)"hrmp-hrobs-formplugin", (Object[])new Object[0]), row);
                }
                if (index > -1) {
                    validateResult = String.format(ResManager.loadKDString((String)"\u53c2\u6570\u540d\uff1a%s\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"CustomParamsPlugin_1", (String)"hrmp-hrobs-formplugin", (Object[])new Object[0]), name);
                }
                numbers.add(name);
            }
        }
        return validateResult;
    }

    public void afterCreateNewData(EventObject e) {
        String originalParameter = (String)this.getView().getFormShowParameter().getCustomParam("params_tag");
        Map map = new LinkedHashMap(16);
        if (StringUtils.isNotBlank((CharSequence)originalParameter)) {
            map = (Map)SerializationUtils.fromJsonString((String)originalParameter, LinkedHashMap.class);
        }
        if (map != null && map.size() > 0) {
            this.getModel().batchCreateNewEntryRow("entryentity", map.size());
            int index = 0;
            for (Map.Entry entrySet : map.entrySet()) {
                this.getModel().setValue("paramname", entrySet.getKey(), index);
                this.getModel().setValue("paramvalue", entrySet.getValue(), index);
                ++index;
            }
        } else {
            this.getModel().createNewEntryRow("entryentity");
        }
        if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.VIEW)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"cancel"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.selectRows(rowCount - 1, true);
    }

    private void returnData() {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
        String tip = this.validate(dynamicObjects);
        if (tip != null) {
            this.getView().showTipNotification(tip);
        } else {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(16);
            for (DynamicObject dynamicObject : dynamicObjects) {
                String paramName = dynamicObject.getString("paramname").trim();
                String paramValue = dynamicObject.getString("paramvalue").trim();
                map.put(paramName, paramValue);
            }
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }
}

