/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrobs.formplugin.messagecenter.mobile;

import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterMobileListPushDownRefreshEvent;
import kd.bos.list.plugin.AbstractMobListPlugin;
import kd.hrmp.hrobs.business.domain.service.process.IMessageCenterService;
import kd.hrmp.hrobs.common.enums.ProcessTypeEnum;
import kd.hrmp.hrobs.common.enums.TerminalEnum;

public class WorkflowListButtonPlugin
extends AbstractMobListPlugin {
    public void afterPushDownRefresh(AfterMobileListPushDownRefreshEvent evt) {
        super.afterPushDownRefresh(evt);
        this.updateParentTabPageCount();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("refresh".equals(args.getOperateKey())) {
            this.updateParentTabPageCount();
        }
    }

    private void updateParentTabPageCount() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String processType = (String)customParams.get("processType");
        String terminal = (String)customParams.get("terminal");
        String processTypeName = (String)customParams.get("processTypeName");
        ProcessTypeEnum processTypeEnum = ProcessTypeEnum.getByValue((String)processType);
        TerminalEnum terminalEnum = TerminalEnum.getByValue((String)terminal);
        int count = IMessageCenterService.getInstance().getTaskCountByType(processTypeEnum, terminalEnum, null);
        IFormView parentView = this.getView().getParentView();
        Tab tab = (Tab)parentView.getControl("tabap");
        String currentTab = tab.getCurrentTab();
        TabPage tabPage = (TabPage)parentView.getControl(currentTab);
        tabPage.setText(this.getTabPageName(processTypeName, count));
        parentView.updateView(currentTab);
        this.getView().sendFormAction(parentView);
    }

    private LocaleString getTabPageName(String processTypeName, int count) {
        return new LocaleString(String.format("%s(%s)", processTypeName, IMessageCenterService.getInstance().getDisplayCount(count)));
    }
}

