/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrobs.formplugin.portal;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrobs.business.domain.repository.CardProcessRepository;
import kd.hrmp.hrobs.business.domain.service.process.IMessageCenterService;
import kd.hrmp.hrobs.common.enums.ProcessTypeEnum;
import kd.hrmp.hrobs.common.enums.TerminalEnum;
import kd.hrmp.hrobs.common.utils.ComboUtils;
import kd.hrmp.hrobs.formplugin.utils.CustomControlUtils;
import kd.hrmp.hrobs.formplugin.utils.ShowFormUtils;

public class MessageCenterCommonPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final Log LOGGER = LogFactory.getLog(MessageCenterCommonPlugin.class);

    private TabAp createTabAp(Long cardId) {
        TabAp tabAp = CustomControlUtils.customTabAp("tabap", null, 1);
        DynamicObject[] cardProcessArrays = CardProcessRepository.getRepository().queryByCardId(cardId, TerminalEnum.PC, "processtype,color");
        if (cardProcessArrays.length == 0) {
            LOGGER.info("cardProcessArrays is null");
            return null;
        }
        for (DynamicObject cardProcess : cardProcessArrays) {
            ProcessTypeEnum processType = ProcessTypeEnum.getByValue((String)cardProcess.getString("processtype"));
            LocaleString processTypeName = ComboUtils.getComboOptionName((DynamicObject)cardProcess, (String)"processtype");
            int count = IMessageCenterService.getInstance().getTaskCountByType(processType, TerminalEnum.PC, null);
            String tabPageKey = String.format("tabpageap_%s", processType.getValue());
            TabPageAp tabPageAp = CustomControlUtils.customTabPageAp(tabPageKey, this.getTabPageName(processTypeName, count), tabAp.getId());
            tabAp.getItems().add(tabPageAp);
        }
        return tabAp;
    }

    private LocaleString getTabPageName(LocaleString processTypeName, int count) {
        return new LocaleString(String.format("%s(%s)", processTypeName.getLocaleValue(), IMessageCenterService.getInstance().getDisplayCount(count)));
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        if (HRStringUtils.equals((String)key, (String)"tabap")) {
            Tab tab = new Tab();
            tab.setKey(key);
            tab.setView(this.getView());
            tab.addTabSelectListener((TabSelectListener)this);
            args.setControl((Control)tab);
            return;
        }
        if (HRStringUtils.startsWithIgnoreCase((String)key, (String)"tabpageap")) {
            TabPage tabPage = new TabPage();
            tabPage.setKey(key);
            tabPage.setView(this.getView());
            tabPage.addClickListener((ClickListener)this);
            args.setControl((Control)tabPage);
        }
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long cardId = (Long)formShowParameter.getCustomParam("cardId");
        if (cardId == null) {
            LOGGER.info("cardId is null");
            return;
        }
        DynamicObject[] cardProcessArrays = CardProcessRepository.getRepository().queryByCardId(cardId, TerminalEnum.PC, "processtype,color");
        if (cardProcessArrays.length == 0) {
            LOGGER.info("cardProcessArrays.length == 0");
            return;
        }
        TabAp tabAp = this.createTabAp(cardId);
        if (tabAp == null) {
            LOGGER.info("tabAp is null");
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("id", "tabap");
        params.put("items", (String)tabAp.createControl().get("items"));
        this.getView().updateControlMetadata("tabap", params);
        ArrayList<String> tabPageKeys = new ArrayList<String>(cardProcessArrays.length);
        for (DynamicObject cardProcess : cardProcessArrays) {
            ProcessTypeEnum processType = ProcessTypeEnum.getByValue((String)cardProcess.getString("processtype"));
            String tabPageKey = String.format("tabpageap_%s", processType.getValue());
            tabPageKeys.add(tabPageKey);
        }
        IPageCache pageCache = this.getView().getPageCache();
        String processType = pageCache.get("selectProcessType");
        if (HRStringUtils.isEmpty((String)processType)) {
            processType = (String)formShowParameter.getCustomParam("selectProcessType");
        }
        Tab tab = (Tab)this.getView().getControl("tabap");
        String activeTab = HRStringUtils.isEmpty((String)processType) || !tabPageKeys.contains(String.format("tabpageap_%s", processType)) ? (String)tabPageKeys.get(0) : String.format("tabpageap_%s", processType);
        tab.activeTab(activeTab);
    }

    public void tabSelected(TabSelectEvent event) {
        String tabKey = event.getTabKey();
        String[] tabKeySplit = tabKey.split("_");
        if (tabKeySplit.length < 2) {
            LOGGER.info("tabKeySplit.length < 2");
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String processType = tabKeySplit[1];
        ProcessTypeEnum processTypeEnum = ProcessTypeEnum.getByValue((String)processType);
        Long cardId = (Long)formShowParameter.getCustomParam("cardId");
        if (cardId == null) {
            LOGGER.info("cardId is null");
            return;
        }
        DynamicObject[] cardProcessArrays = CardProcessRepository.getRepository().queryByCardId(cardId, TerminalEnum.PC, "processtype,color");
        if (cardProcessArrays.length == 0) {
            LOGGER.info("cardProcessArrays.length == 0");
            return;
        }
        ListShowParameter listShowParameter = ShowFormUtils.buildListShowParameter(event.getTabKey(), processTypeEnum.getPcFormId(), ShowType.InContainer, null);
        for (DynamicObject cardProcess : cardProcessArrays) {
            String tabPageKey = String.format("tabpageap_%s", ProcessTypeEnum.getByValue((String)cardProcess.getString("processtype")).getValue());
            if (!HRStringUtils.equals((String)tabKey, (String)tabPageKey)) continue;
            LocaleString processTypeName = ComboUtils.getComboOptionName((DynamicObject)cardProcess, (String)"processtype");
            listShowParameter.setCustomParam("processTypeName", (Object)processTypeName.getLocaleValue());
            int count = IMessageCenterService.getInstance().getTaskCountByType(processTypeEnum, TerminalEnum.PC, null);
            TabPage tabPage = (TabPage)this.getView().getControl(tabKey);
            tabPage.setText(this.getTabPageName(processTypeName, count));
            this.getView().updateView(tabKey);
            break;
        }
        listShowParameter.setHasRight(true);
        listShowParameter.setCustomParam("processType", (Object)processType);
        listShowParameter.setCustomParam("terminal", (Object)TerminalEnum.PC.getValue());
        this.getView().showForm((FormShowParameter)listShowParameter);
    }
}

