/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrobs.formplugin.portal.mobile;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrobs.business.domain.repository.PortalSchemeLayoutRepository;
import kd.hrmp.hrobs.business.domain.service.corporateculture.ICorporateCultureService;
import kd.hrmp.hrobs.common.constants.PortalSchemeLayoutConstants;
import kd.hrmp.hrobs.common.enums.CardTypeEnum;
import kd.hrmp.hrobs.common.enums.TerminalEnum;
import kd.hrmp.hrobs.formplugin.utils.CustomControlUtils;
import kd.hrmp.hrobs.formplugin.utils.ShowFormUtils;
import org.apache.commons.lang3.ObjectUtils;

public class HomePlugin
extends AbstractMobFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(HomePlugin.class);

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        DynamicObject portalSchemeLayout = PortalSchemeLayoutRepository.getRepository().findPortalSchemeLayout(TerminalEnum.MOBILE, null);
        if (ObjectUtils.isEmpty((Object)portalSchemeLayout)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9996\u9875\u65b9\u6848\u5e03\u5c40\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u65b9\u6848\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"HomePlugin_10", (String)"hrmp-hrobs-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection cardLayouts = portalSchemeLayout.getDynamicObjectCollection("entryentity");
        FlexPanelAp flexPanelAp = CustomControlUtils.customFlexPane("flexpanelap", null, null, null, null, null);
        for (int i = 0; i < cardLayouts.size(); ++i) {
            FlexPanelAp cardFlex = CustomControlUtils.customFlexPane("cardflexpanel" + i, null, null, null, null, null);
            CustomControlUtils.setControlApGrowAndShrink((ControlAp)cardFlex, 0, 0);
            flexPanelAp.getItems().add(cardFlex);
        }
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("id", "flexpanelap");
        params.put("items", (String)flexPanelAp.createControl().get("items"));
        args.getItems().add(params);
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        if (key.startsWith("cardflexpanel")) {
            Container container = new Container();
            container.setKey(key);
            container.setView(this.getView());
            container.addClickListener((ClickListener)this);
            args.setControl((Control)container);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject portalSchemeLayout = PortalSchemeLayoutRepository.getRepository().findPortalSchemeLayout(TerminalEnum.MOBILE, null);
        DynamicObjectCollection cardLayouts = portalSchemeLayout.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < cardLayouts.size(); ++i) {
            String corporateCulture;
            DynamicObject cardLayout = (DynamicObject)cardLayouts.get(i);
            DynamicObject card = cardLayout.getDynamicObject("card");
            String formId = null;
            long cardtypeId = card.getLong("cardtype.id");
            if (cardtypeId == PortalSchemeLayoutConstants.CARD_TYPE_1040) {
                formId = card.getString("mobbindform.number");
            }
            if (HRStringUtils.isEmpty(formId)) {
                Long cardTypeId = card.getLong("cardtype.id");
                CardTypeEnum cardType = CardTypeEnum.getById((Long)cardTypeId);
                formId = cardType.getMobileFormId();
            }
            if (HRStringUtils.equals((String)formId, (String)"hrobs_mob_empinfocard") && HRStringUtils.isEmpty((String)(corporateCulture = ICorporateCultureService.getInstance().getCorporateCulture()))) {
                formId = "hrobs_mob_empinfo_simple";
            }
            MobileFormShowParameter formShowParameter = ShowFormUtils.buildMobileFormShowParameter("cardflexpanel" + i, formId, null, OperationStatus.VIEW);
            String pageId = this.getView().getPageId() + card.getString("id");
            LOGGER.info("HomePlugin_pageId:{}", (Object)pageId);
            formShowParameter.setPageId(pageId);
            formShowParameter.setCustomParam("cardId", (Object)card.getLong("id"));
            formShowParameter.setCustomParam("cardLayoutId", (Object)cardLayout.getLong("id"));
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"hyperlinkap"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (HRStringUtils.equals((String)key, (String)"hyperlinkap")) {
            MobileFormShowParameter formShowParameter = ShowFormUtils.buildMobileFormShowParameter(null, "hrobs_mob_privacy", ShowType.Floating, OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
    }
}

