/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrobs.formplugin.portal.mobile;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrobs.business.domain.service.portal.IAppConfigService;
import kd.hrmp.hrobs.formplugin.utils.HrobsPageUtil;
import kd.hrmp.hrobs.formplugin.utils.ShowFormUtils;

public class MobCommonAppPlugin
extends AbstractMobFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(MobCommonAppPlugin.class);
    private static final String IMAGEKEY = "imagekey";
    private static final String CONTENTFLEXPANELAP = "contentflexpanelap";
    private static final String APP_FLEX = "appflex";
    private static final String TITLEFLEXPANELAP = "titleflexpanelap";
    private static final String TITLELABELAP = "titlelabelap";
    private static final String LABEL_NAME = "labelname";

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (key.startsWith(APP_FLEX)) {
            this.showMobileView(key);
        }
    }

    private void showMobileView(String flexKey) {
        String[] splitStr = flexKey.split("#");
        String formId = splitStr[1];
        if (formId.equalsIgnoreCase("formId")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u5e94\u7528\u5904\u7406\u9875\u9762\uff0c\u65e0\u6cd5\u8df3\u8f6c", (String)"MobCommonAppPlugin_3", (String)"hrmp-hrobs-formplugin", (Object[])new Object[0]));
            return;
        }
        String appSource = splitStr[2];
        String modelType = splitStr[3];
        Long appConfigId = Long.valueOf(splitStr[4]);
        Map map = IAppConfigService.getInstance().getCustomParams(appConfigId, "1");
        if ("0".equals(appSource)) {
            FormShowParameter formShowParameter;
            String showType = splitStr[5];
            switch (modelType) {
                case "baseformmodel": {
                    formShowParameter = ShowFormUtils.buildBaseFormMobModel(showType, formId);
                    break;
                }
                case "dynamicformmodel": {
                    formShowParameter = ShowFormUtils.buildDynamicModel(formId);
                    break;
                }
                case "billformmodel": {
                    formShowParameter = ShowFormUtils.buildBillFormModel(showType, formId);
                    break;
                }
                case "querylistmodel": {
                    formShowParameter = ShowFormUtils.buildQueryListFormModel(formId);
                    break;
                }
                case "mobilebillformmodel": {
                    formShowParameter = ShowFormUtils.buildMobileBillFormModel(showType, formId);
                    break;
                }
                default: {
                    formShowParameter = ShowFormUtils.buildMobileFormModel(formId);
                }
            }
            if (formShowParameter != null) {
                formShowParameter.setCustomParams(map);
                formShowParameter.setCustomParam("checkRightAppId", (Object)"hssc");
            }
            this.getView().showForm(formShowParameter);
        } else if (HRStringUtils.equals((String)appSource, (String)"1")) {
            Map appConfigMap = IAppConfigService.getInstance().getAppConfigById(appConfigId, "1");
            LOGGER.info("IAppConfigService_getAppConfigByNumber: {}", (Object)map);
            this.getView().openUrl(String.valueOf(appConfigMap.get("entryentity.url")));
        }
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = String.valueOf(args.getKey());
        if (key.startsWith(APP_FLEX)) {
            Container container = new Container();
            container.setKey(key);
            container.setView(this.getView());
            container.addClickListener((ClickListener)this);
            args.setControl((Control)container);
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        this.buildCardTitle(args);
        this.buildAllApp(args);
    }

    private void buildCardTitle(LoadCustomControlMetasArgs args) {
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        Long cardId = (Long)formShowParameter.getCustomParam("cardId");
        if (cardId == null) {
            return;
        }
        String title = IAppConfigService.getInstance().getCardTitle(cardId);
        if (title == null || title.isEmpty()) {
            return;
        }
        FlexPanelAp titleFlex = new FlexPanelAp();
        titleFlex.setKey(TITLEFLEXPANELAP);
        titleFlex.setHeight(new LocaleString("36px"));
        LabelAp appFlex = this.getTitleFlex(title);
        titleFlex.getItems().add(appFlex);
        this.addFlexPanel(TITLEFLEXPANELAP, titleFlex, args);
    }

    private LabelAp getTitleFlex(String title) {
        Style style = new Style();
        Margin margin = new Margin();
        margin.setTop("12px");
        margin.setLeft("12px");
        style.setMargin(margin);
        LabelAp titleLabelAp = HrobsPageUtil.customLabel(TITLELABELAP, new LocaleString(title), 14, "#212121");
        titleLabelAp.setFontWeight("bold");
        titleLabelAp.setStyle(style);
        return titleLabelAp;
    }

    private void buildAllApp(LoadCustomControlMetasArgs args) {
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        Long cardId = (Long)formShowParameter.getCustomParam("cardId");
        Long cardLayoutId = (Long)formShowParameter.getCustomParam("cardLayoutId");
        if (cardId == null || cardLayoutId == null) {
            return;
        }
        List appConfigList = IAppConfigService.getInstance().getCardLayoutApps("1", cardId, cardLayoutId);
        if (appConfigList == null || appConfigList.isEmpty()) {
            return;
        }
        boolean index = false;
        FlexPanelAp appListFlex = new FlexPanelAp();
        appListFlex.setKey(CONTENTFLEXPANELAP);
        appListFlex.setWidth(new LocaleString("318px"));
        appListFlex.setBackColor("#ffffff");
        Padding padding = new Padding();
        padding.setLeft("6px");
        padding.setBottom("16px");
        Style style = new Style();
        style.setPadding(padding);
        appListFlex.setStyle(style);
        long userId = RequestContext.get().getCurrUserId();
        for (int i = 0; i < appConfigList.size(); ++i) {
            Map appConfig = (Map)appConfigList.get(i);
            if ("0".equals(appConfig.get("appsource"))) {
                String formId = (String)appConfig.get("formId");
                boolean checkPermission = PermissionServiceHelper.checkPermission((Long)userId, (String)"hssc", (String)formId, (String)"47150e89000000ac");
                LOGGER.info("checkPermission userId:{},formId:{} result:{}", new Object[]{userId, formId, checkPermission});
                if (!checkPermission || !this.specialPermission(appConfig)) {
                    LOGGER.info("{} permission verification fail!", (Object)formId);
                    continue;
                }
            }
            FlexPanelAp appFlex = this.getAppFlex(appConfig, i);
            appListFlex.getItems().add(appFlex);
        }
        this.addFlexPanel(CONTENTFLEXPANELAP, appListFlex, args);
    }

    private boolean specialPermission(Map<String, Object> appConfig) {
        long userId = RequestContext.get().getCurrUserId();
        String formId = (String)appConfig.get("formId");
        Long id = (Long)appConfig.get("id");
        if ("hdm_selfhelp_entry".equals(formId)) {
            return PermissionServiceHelper.checkPermission((Long)userId, (String)"hssc", (String)"hdm_regselfhelpbill", (String)"47150e89000000ac");
        }
        if ("hspp_mobpwdinit".equals(formId)) {
            HashMap map = IAppConfigService.getInstance().getCustomParams(id, "1");
            if (map == null) {
                map = new HashMap(16);
            }
            String isPerm = (String)map.get("isPerm");
            String isSum = (String)map.get("isSum");
            if ("0".equals(isPerm)) {
                return true;
            }
            String entityNum = "1".equals(isSum) ? "hspp_salaryslipdetailsum" : "hspp_mobilesalarycal";
            return PermissionServiceHelper.checkPermission((Long)userId, (String)"hssc", (String)entityNum, (String)"47150e89000000ac");
        }
        return true;
    }

    private FlexPanelAp getAppFlex(Map<String, Object> appConfigDy, int index) {
        String apKey = "appflex#" + appConfigDy.get("formId") + "#" + appConfigDy.get("appsource") + "#" + appConfigDy.get("modeltype") + "#" + appConfigDy.get("id") + "#" + appConfigDy.get("businessobjecttype");
        LOGGER.info("apKey: {}", (Object)apKey);
        FlexPanelAp appFlex = HrobsPageUtil.customFlexPane(apKey, null, null, null, null, null);
        HrobsPageUtil.setFlexGrowAndShrink(appFlex, 0, 1);
        HrobsPageUtil.setFlexDirection(appFlex, "column", false, "center", "center");
        appFlex.setBackColor("#ffffff");
        appFlex.setOverflow("visible");
        ImageAp imageAp = this.buildImageAp((String)appConfigDy.get("systemicon"), index);
        LabelAp titleLabel = this.buildAppTitleLabel(new LocaleString(appConfigDy.get("name").toString()), index);
        titleLabel.setTextAlign("center");
        titleLabel.setWidth(new LocaleString("106px"));
        titleLabel.setAutoTextWrap(true);
        appFlex.setClickable(true);
        appFlex.getItems().add(imageAp);
        appFlex.getItems().add(titleLabel);
        return appFlex;
    }

    private ImageAp buildImageAp(String imageUrl, int index) {
        ImageAp imageAp = new ImageAp();
        imageAp.setImageKey(imageUrl);
        imageAp.setKey(IMAGEKEY + index);
        imageAp.setHeight(new LocaleString("40px"));
        imageAp.setWidth(new LocaleString("40px"));
        Style style = new Style();
        Margin margin = new Margin();
        margin.setTop("16px");
        margin.setBottom("8px");
        margin.setLeft("33px");
        margin.setRight("33px");
        style.setMargin(margin);
        imageAp.setStyle(style);
        return imageAp;
    }

    private LabelAp buildAppTitleLabel(LocaleString title, int index) {
        return HrobsPageUtil.customLabel(LABEL_NAME + index, title, 12, "#212121");
    }

    private void addFlexPanel(String id, FlexPanelAp flexPanelAp, LoadCustomControlMetasArgs args) {
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("id", id);
        params.put("items", (String)flexPanelAp.createControl().get("items"));
        args.getItems().add(params);
    }
}

