/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrobs.formplugin.portal.mobile;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrobs.business.domain.service.corporateculture.ICorporateCultureService;
import kd.hrmp.hrobs.business.domain.service.portal.IEmpInfoService;
import org.apache.commons.lang3.StringUtils;

public class MobEmpInfoPlugin
extends AbstractMobFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(MobEmpInfoPlugin.class);

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Long startTime = System.currentTimeMillis();
        this.initHeadCard();
        Long endTime = System.currentTimeMillis();
        LOGGER.info("MobEmpInfoPlugin_initHeadCard total time : {}", (Object)(endTime - startTime));
    }

    private void initHeadCard() {
        IDataModel model = this.getModel();
        Map personInfo = IEmpInfoService.getInstance().getPersonInfo();
        LOGGER.info("MobEmpInfoPlugin_personInfo:{}", (Object)personInfo);
        if (personInfo == null) {
            return;
        }
        model.setValue("headsculpture", personInfo.get("headsculpture"));
        Label lblCompany = (Label)this.getView().getControl("company");
        String company = personInfo.get("company") == null ? "" : (String)personInfo.get("company");
        lblCompany.setText(company);
        Label lblAdminOrg = (Label)this.getView().getControl("adminorg");
        String adminOrg = personInfo.get("adminorg") == null ? "" : (String)personInfo.get("adminorg");
        lblAdminOrg.setText(adminOrg);
        String position = personInfo.get("position") == null ? "" : (String)personInfo.get("position");
        String stdposition = personInfo.get("stdposition") == null ? "" : (String)personInfo.get("stdposition");
        String positionType = (String)personInfo.get("apositiontype");
        model.setValue("name", (Object)("Hi~" + personInfo.get("name")));
        Label lblPosition = (Label)this.getView().getControl("position");
        if (HRStringUtils.isNotEmpty((String)positionType) && HRStringUtils.equals((String)positionType, (String)"0")) {
            lblPosition.setText(stdposition);
        } else if (HRStringUtils.isNotEmpty((String)positionType) && HRStringUtils.equals((String)positionType, (String)"1")) {
            lblPosition.setText(position);
        } else if (HRStringUtils.isNotEmpty((String)positionType) && HRStringUtils.equals((String)positionType, (String)"2")) {
            lblPosition.setText(String.valueOf(personInfo.get("job") == null ? "" : stdposition));
        } else {
            LOGGER.error("error when drawing personCard , please check the positionType and the value under this type ");
        }
        model.setValue("entrydays", (Object)MobEmpInfoPlugin.getEntryDays((Date)personInfo.get("startdate")));
        String corporateculture = ICorporateCultureService.getInstance().getCorporateCulture();
        if (StringUtils.isNotBlank((CharSequence)corporateculture)) {
            model.setValue("corporateculture", (Object)corporateculture);
        }
    }

    private static String getEntryDays(Date startdate) {
        long diffDay = startdate == null ? 0L : HRDateTimeUtils.dateDiff((Date)startdate, (Date)new Date()) / 86400000L + 1L;
        return String.format(ResManager.loadKDString((String)"\u6211\u4eec\u5df2\u643a\u624b\u540c\u884c%s\u5929", (String)"MobEmpInfoPlugin_0", (String)"hrmp-hrobs-formplugin", (Object[])new Object[0]), diffDay);
    }
}

