/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrobs.formplugin.portal.mobile;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrobs.business.domain.repository.CardProcessRepository;
import kd.hrmp.hrobs.business.domain.repository.CardRepository;
import kd.hrmp.hrobs.business.domain.service.process.IMessageCenterService;
import kd.hrmp.hrobs.common.enums.AlignItemsEnum;
import kd.hrmp.hrobs.common.enums.DirectionEnum;
import kd.hrmp.hrobs.common.enums.JustifyContentEnum;
import kd.hrmp.hrobs.common.enums.ProcessTypeEnum;
import kd.hrmp.hrobs.common.enums.TerminalEnum;
import kd.hrmp.hrobs.common.utils.ComboUtils;
import kd.hrmp.hrobs.formplugin.utils.CustomControlUtils;
import kd.hrmp.hrobs.formplugin.utils.ShowFormUtils;

public class ProcessCardPlugin
extends AbstractMobFormPlugin {
    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        if (HRStringUtils.startsWithIgnoreCase((String)key, (String)"morevectorap") || HRStringUtils.startsWithIgnoreCase((String)key, (String)"processflexpanelap")) {
            Container container = new Container();
            container.setKey(key);
            container.setView(this.getView());
            container.addClickListener((ClickListener)this);
            args.setControl((Control)container);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (HRStringUtils.startsWithIgnoreCase((String)key, (String)"morevectorap") || HRStringUtils.startsWithIgnoreCase((String)key, (String)"processflexpanelap")) {
            String[] split = key.split("_");
            MobileFormShowParameter formShowParameter = ShowFormUtils.buildMobileFormShowParameter(null, "hrobs_mob_messagecenter", ShowType.Floating, OperationStatus.VIEW);
            formShowParameter.setCustomParam("cardId", (Object)Long.valueOf(split[1]));
            if (split.length > 2) {
                formShowParameter.setCustomParam("selectProcessType", (Object)split[2]);
            }
            formShowParameter.setHasRight(true);
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        Long cardId = (Long)formShowParameter.getCustomParam("cardId");
        if (cardId == null) {
            return;
        }
        DynamicObject card = CardRepository.getRepository().queryOne("name", (Object)cardId);
        if (HRObjectUtils.isEmpty((Object)card)) {
            return;
        }
        DynamicObject[] cardProcessArrays = CardProcessRepository.getRepository().queryByCardId(cardId, TerminalEnum.MOBILE, "processtype,color");
        FlexPanelAp flexPanelAp = CustomControlUtils.customFlexPane("flexpanelap", null, null, null, null, null);
        FlexPanelAp titleFlexPanelAp = CustomControlUtils.customFlexPane("titleflexpanelap", null, null, null, null, "24px");
        CustomControlUtils.setControlApGrowAndShrink((ControlAp)titleFlexPanelAp, 0, 1);
        CustomControlUtils.setFlexDirection(titleFlexPanelAp, DirectionEnum.ROW, false, JustifyContentEnum.SPACE_BETWEEN, AlignItemsEnum.CENTER, null);
        flexPanelAp.getItems().add(titleFlexPanelAp);
        String titleName = card.getString("name");
        LabelAp titleLabelAp = CustomControlUtils.customLabel("titlelabelap", new LocaleString(titleName), 14, "#212121", false);
        CustomControlUtils.setControlApGrowAndShrink((ControlAp)titleLabelAp, 0, 1);
        titleLabelAp.setFontWeight("bold");
        titleFlexPanelAp.getItems().add(titleLabelAp);
        if (cardProcessArrays.length > 3) {
            String moreVectorApKey = String.format("morevectorap_%s", cardId);
            VectorAp moreVectorAp = CustomControlUtils.customVectorAp(moreVectorApKey, null, "kdfont kdfont-fangxiangyou", 16, true);
            CustomControlUtils.setControlApGrowAndShrink((ControlAp)moreVectorAp, 0, 0);
            titleFlexPanelAp.getItems().add(moreVectorAp);
        }
        Margin contentFlexPanelApMargin = CustomControlUtils.buildMargin("12px", null, null, null);
        FlexPanelAp contentFlexPanelAp = CustomControlUtils.customFlexPane("contentflexpanelap", contentFlexPanelApMargin, null, null, null, null);
        CustomControlUtils.setControlApGrowAndShrink((ControlAp)contentFlexPanelAp, 0, 1);
        CustomControlUtils.setFlexDirection(contentFlexPanelAp, DirectionEnum.ROW, false, JustifyContentEnum.SPACE_BETWEEN, null, null);
        flexPanelAp.getItems().add(contentFlexPanelAp);
        for (int i = 0; i < Integer.min(cardProcessArrays.length, 3); ++i) {
            DynamicObject cardProcess = cardProcessArrays[i];
            ProcessTypeEnum processType = ProcessTypeEnum.getByValue((String)cardProcess.getString("processtype"));
            String processTypeValue = processType.getValue();
            String processFlexPanelApKey = String.format("processflexpanelap_%s_%s", cardId, processTypeValue);
            Padding processFlexPanelApPadding = CustomControlUtils.buildPadding("12px", "10px", "10px", "10px");
            FlexPanelAp processFlexPanelAp = CustomControlUtils.customFlexPane(processFlexPanelApKey, null, processFlexPanelApPadding, null, "98px", "78px");
            CustomControlUtils.setControlApGrowAndShrink((ControlAp)processFlexPanelAp, 0, 1);
            CustomControlUtils.setFlexDirection(processFlexPanelAp, DirectionEnum.COLUMN, false, null, null, null);
            processFlexPanelAp.setAlignSelf(AlignItemsEnum.CENTER.getValue());
            processFlexPanelAp.setRadius("8px");
            processFlexPanelAp.setBackgroundImg(processType.getBackgroundImg());
            processFlexPanelAp.setBKFull(true);
            processFlexPanelAp.setClickable(true);
            contentFlexPanelAp.getItems().add(processFlexPanelAp);
            LocaleString processTypeName = ComboUtils.getComboOptionName((DynamicObject)cardProcess, (String)"processtype");
            String processNameLabelApKey = String.format("processnamelabelap_%s_%s", cardId, processTypeValue);
            LabelAp processNameLabelAp = CustomControlUtils.customLabel(processNameLabelApKey, processTypeName, 12, "#666666", false);
            CustomControlUtils.setControlApGrowAndShrink((ControlAp)processNameLabelAp, 0, 1);
            processFlexPanelAp.getItems().add(processNameLabelAp);
            int count = IMessageCenterService.getInstance().getTaskCountByType(processType, TerminalEnum.MOBILE, null);
            String processCountLabelApKey = String.format("processcountlabelap_%s_%s", cardId, processTypeValue);
            String processColor = cardProcess.getString("color");
            LabelAp processCountLabelAp = CustomControlUtils.customLabel(processCountLabelApKey, new LocaleString(IMessageCenterService.getInstance().getDisplayCount(count)), 24, processColor, false);
            Margin processCountLabelApMargin = CustomControlUtils.buildMargin("8px", null, null, null);
            CustomControlUtils.setControlApStyle((ControlAp)processCountLabelAp, processCountLabelApMargin, null, null);
            CustomControlUtils.setControlApGrowAndShrink((ControlAp)processCountLabelAp, 0, 1);
            processFlexPanelAp.getItems().add(processCountLabelAp);
        }
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("id", "flexpanelap");
        params.put("items", (String)flexPanelAp.createControl().get("items"));
        args.getItems().add(params);
    }
}

