/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrobs.formplugin.portal.pc;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.ext.form.container.GridContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.pluginnew.common.GridContainerAbstract;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrobs.business.domain.repository.PortalSchemeLayoutRepository;
import kd.hrmp.hrobs.business.domain.service.config.IConfigService;
import kd.hrmp.hrobs.common.constants.PortalSchemeLayoutConstants;
import kd.hrmp.hrobs.common.enums.CardTypeEnum;
import kd.hrmp.hrobs.common.enums.TerminalEnum;
import kd.hrmp.hrobs.formplugin.utils.ShowFormUtils;

public class HomePlugin
extends GridContainerAbstract
implements TabSelectListener {
    private static final Log LOGGER = LogFactory.getLog(HomePlugin.class);

    public void afterCreateNewData(EventObject e) {
        LOGGER.info("resetGridContainer().start=====================");
        this.resetGridContainer();
    }

    private void resetGridContainer() {
        DynamicObject portalSchemeLayout = PortalSchemeLayoutRepository.getRepository().findPortalSchemeLayout(TerminalEnum.PC, null);
        LOGGER.info("HomePlugin_portalSchemeLayout: {}", (Object)portalSchemeLayout);
        String layout = portalSchemeLayout.getString("config_tag");
        if (HRStringUtils.isEmpty((String)layout)) {
            layout = portalSchemeLayout.getString("config");
        }
        GridContainer gridContainer = (GridContainer)this.getView().getControl("gridcontainerap");
        gridContainer.reset(layout);
        portalSchemeLayout.getDynamicObjectCollection("entryentity").forEach(this::showCardForm);
    }

    private void showCardForm(DynamicObject cardLayout) {
        LOGGER.info("HomePlugin_cardLayoutInfo: {}", (Object)cardLayout);
        DynamicObject card = cardLayout.getDynamicObject("card");
        LOGGER.info("HomePlugin_cardInfo: {}", (Object)card);
        long cardtypeId = card.getLong("cardtype.id");
        String formId = null;
        if (cardtypeId == PortalSchemeLayoutConstants.CARD_TYPE_1040) {
            formId = card.getString("pcbindform.number");
        }
        if (HRStringUtils.isEmpty(formId)) {
            Long cardTypeId = card.getLong("cardtype.id");
            CardTypeEnum cardType = CardTypeEnum.getById((Long)cardTypeId);
            formId = cardType.getPcFormId();
        }
        long cardId = card.getLong("id");
        long cardLayoutId = cardLayout.getLong("id");
        FormShowParameter formShowParameter = ShowFormUtils.buildFormShowParameter("gridcontainerap", formId, ShowType.InContainer, OperationStatus.VIEW);
        this.setOpenStyle(cardId, cardLayoutId, formShowParameter);
        this.setCustomParam(cardId, cardLayoutId, formShowParameter);
        this.getView().showForm(formShowParameter);
        String pageId = formShowParameter.getPageId();
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put(String.valueOf(cardId), pageId);
        LOGGER.info("HomePlugin_pageId: {}", (Object)pageId);
    }

    private void setOpenStyle(long cardId, long cardLayoutId, FormShowParameter formShowParameter) {
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setTargetKey("gridcontainerap");
        this.setOpenStyleCustParam(cardId, cardLayoutId, openStyle);
    }

    @Deprecated
    private void setOpenStyleCustParam(long cardId, long cardLayoutId, OpenStyle openStyle) {
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("id", String.valueOf(cardId));
        params.put("cardId", String.valueOf(cardId));
        params.put("cardLayoutId", String.valueOf(cardLayoutId));
        openStyle.setCustParam(params);
    }

    private void setCustomParam(long cardId, long cardLayoutId, FormShowParameter formShowParameter) {
        formShowParameter.setCustomParam("id", (Object)cardId);
        formShowParameter.setCustomParam("cardId", (Object)cardId);
        formShowParameter.setCustomParam("cardLayoutId", (Object)cardLayoutId);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"hyperlinkap"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (HRStringUtils.equals((String)key, (String)"hyperlinkap")) {
            FormShowParameter formShowParameter = ShowFormUtils.buildFormShowParameter(null, "hrobs_pc_privacy", ShowType.Modal, OperationStatus.VIEW);
            this.getView().showForm(formShowParameter);
        }
    }

    public void tabSelected(TabSelectEvent event) {
        String isAutoFresh;
        super.tabSelected(event);
        LOGGER.info("tabSelected().start=====================");
        String tabKey = event.getTabKey();
        if (HRStringUtils.endsWithIgnoreCase((String)tabKey, (String)"appmiantab") && HRStringUtils.equals((String)(isAutoFresh = IConfigService.getInstance().getValueByKey("hrobs_is_auto_fresh_pc_home", "true")), (String)"true")) {
            this.resetGridContainer();
        }
    }
}

