/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrobs.formplugin.portal.pc;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hrobs.business.domain.service.portal.IAppConfigService;
import kd.hrmp.hrobs.formplugin.utils.HrobsPageUtil;
import kd.hrmp.hrobs.formplugin.utils.ShowFormUtils;
import org.apache.commons.lang3.StringUtils;

public class PcCommonAppPlugin
extends HRDataBaseEdit {
    private static final Log LOGGER = LogFactory.getLog(PcCommonAppPlugin.class);
    private static final String IMAGEKEY = "imagekey";
    private static final String CONTENTFLEXPANELAP = "contentflexpanelap";
    private static final String APP_FLEX = "appflex";
    private static final String TITLEFLEXPANELAP = "titleflexpanelap";
    private static final String TITLELABELAP = "titlelabelap";
    private static final String LABEL_NAME = "labelname";

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (key.startsWith(APP_FLEX)) {
            this.showPcView(key);
        }
    }

    private void showPcView(String flexKey) {
        String[] splitStr = flexKey.split("#");
        String formId = splitStr[1];
        if (formId.equalsIgnoreCase("formId")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u5e94\u7528\u5904\u7406\u9875\u9762\uff0c\u65e0\u6cd5\u8df3\u8f6c", (String)"PcCommonAppPlugin_1", (String)"hrmp-hrobs-formplugin", (Object[])new Object[0]));
            return;
        }
        String appSource = splitStr[2];
        String modelType = splitStr[3];
        Long appConfigId = Long.valueOf(splitStr[4]);
        Map appCustomParams = IAppConfigService.getInstance().getCustomParams(appConfigId, "0");
        if (HRStringUtils.equals((String)appSource, (String)"0")) {
            FormShowParameter formShowParameter;
            String showType = splitStr[5];
            String pageId = this.getView().getFormShowParameter().getParentPageId() + formId;
            switch (modelType) {
                case "baseformmodel": {
                    formShowParameter = ShowFormUtils.buildBaseModel(showType, formId);
                    break;
                }
                case "billformmodel": {
                    formShowParameter = ShowFormUtils.buildBillModel(showType, formId);
                    break;
                }
                case "querylistmodel": {
                    formShowParameter = ShowFormUtils.buildQueryListFormModel(formId);
                    break;
                }
                default: {
                    formShowParameter = ShowFormUtils.buildDynamicModel(formId);
                }
            }
            if (formShowParameter != null) {
                LOGGER.info("IAppConfigService showPcView entityNumber: {}", (Object)formShowParameter.getFormId());
                formShowParameter.setCustomParams(appCustomParams);
                ShowFormUtils.mainTabOpenPage(this.getView(), formShowParameter, pageId);
            }
        } else if (HRStringUtils.equals((String)appSource, (String)"1")) {
            Map map = IAppConfigService.getInstance().getAppConfigById(appConfigId, "0");
            LOGGER.info("IAppConfigService_getAppConfigByFormId: {}", (Object)map);
            this.getView().openUrl(String.valueOf(map.get("entryentity.url")));
        }
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = String.valueOf(args.getKey());
        if (key.startsWith(APP_FLEX)) {
            Container container = new Container();
            container.setKey(key);
            container.setView(this.getView());
            container.addClickListener((ClickListener)this);
            args.setControl((Control)container);
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        FlexPanelAp rootflexpanelap = HrobsPageUtil.customFlexPane("rootflexpanelap", null, null, null, null, "150px");
        HrobsPageUtil.setFlexGrowAndShrink(rootflexpanelap, 0, 0);
        rootflexpanelap.setOverflow("visible");
        HrobsPageUtil.setFlexDirection(rootflexpanelap, "column", false, "flex-start", "stretch");
        FlexPanelAp cardTitle = this.buildCardTitle(args);
        rootflexpanelap.getItems().add(cardTitle);
        FlexPanelAp allApp = this.buildAllApp(args);
        rootflexpanelap.getItems().add(allApp);
        this.addFlexPanel("rootflexpanelap", rootflexpanelap, args);
    }

    private FlexPanelAp buildCardTitle(LoadCustomControlMetasArgs args) {
        FlexPanelAp titleFlex = new FlexPanelAp();
        titleFlex.setKey(TITLEFLEXPANELAP);
        titleFlex.setHeight(new LocaleString("32px"));
        HrobsPageUtil.setFlexGrowAndShrink(titleFlex, 0, 0);
        titleFlex.setOverflow("visible");
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        String cardIdStr = (String)formShowParameter.getOpenStyle().getCustParam().get("cardId");
        if (StringUtils.isBlank((CharSequence)cardIdStr)) {
            return titleFlex;
        }
        Long cardId = Long.valueOf(cardIdStr);
        String title = IAppConfigService.getInstance().getCardTitle(cardId);
        if (StringUtils.isEmpty((CharSequence)title)) {
            return titleFlex;
        }
        LabelAp appFlex = this.getTitleFlex(title);
        titleFlex.getItems().add(appFlex);
        return titleFlex;
    }

    private LabelAp getTitleFlex(String title) {
        Style style = new Style();
        Margin margin = new Margin();
        margin.setTop("10px");
        margin.setLeft("20px");
        style.setMargin(margin);
        LabelAp titleLabelAp = HrobsPageUtil.customLabel(TITLELABELAP, new LocaleString(title), 14, "#212121");
        titleLabelAp.setStyle(style);
        titleLabelAp.setClickable(true);
        return titleLabelAp;
    }

    private FlexPanelAp buildAllApp(LoadCustomControlMetasArgs args) {
        Padding padding = new Padding();
        padding.setLeft("20px");
        padding.setRight("20px");
        padding.setTop("8px");
        padding.setBottom("20px");
        FlexPanelAp appListFlex = HrobsPageUtil.customFlexPane(CONTENTFLEXPANELAP, null, padding, null, null, "118px");
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        String cardIdStr = (String)formShowParameter.getOpenStyle().getCustParam().get("cardId");
        String cardLayoutIdStr = (String)formShowParameter.getOpenStyle().getCustParam().get("cardLayoutId");
        if (StringUtils.isBlank((CharSequence)cardIdStr) || StringUtils.isBlank((CharSequence)cardLayoutIdStr)) {
            return appListFlex;
        }
        Long cardId = Long.valueOf(cardIdStr);
        Long cardLayoutId = Long.valueOf(cardLayoutIdStr);
        LOGGER.warn("cardLayoutId:" + cardLayoutId);
        List appConfigList = IAppConfigService.getInstance().getCardLayoutApps("0", cardId, cardLayoutId);
        if (appConfigList == null || appConfigList.isEmpty()) {
            return appListFlex;
        }
        long userId = RequestContext.get().getCurrUserId();
        String view = "47150e89000000ac";
        for (int i = 0; i < appConfigList.size(); ++i) {
            Map appConfig = (Map)appConfigList.get(i);
            if ("0".equals(appConfig.get("appsource"))) {
                String formId = (String)appConfig.get("formId");
                boolean checkPermission = PermissionServiceHelper.checkPermission((Long)userId, (String)"hssc", (String)formId, (String)view);
                LOGGER.info("checkPermission userId:{},formId:{} result:{}", new Object[]{userId, formId, checkPermission});
                if (!checkPermission) {
                    LOGGER.info("{} permission verification fail!", (Object)formId);
                    continue;
                }
            }
            FlexPanelAp appFlex = this.getAppFlex(appConfig, i);
            appListFlex.getItems().add(appFlex);
        }
        appListFlex.setOverflow("auto");
        return appListFlex;
    }

    private FlexPanelAp getAppFlex(Map<String, Object> appConfigDy, int index) {
        Margin margin = new Margin();
        margin.setTop("16px");
        margin.setRight("10px");
        String apKey = String.join((CharSequence)"#", APP_FLEX, appConfigDy.get("formId") + "", appConfigDy.get("appsource") + "", appConfigDy.get("modeltype") + "", appConfigDy.get("id") + "", appConfigDy.get("businessobjecttype") + "");
        FlexPanelAp appFlex = HrobsPageUtil.customFlexPane(apKey, margin, null, null, "96px", "74px");
        appFlex.setOverflow("visible");
        HrobsPageUtil.setFlexGrowAndShrink(appFlex, 0, 0);
        HrobsPageUtil.setFlexDirection(appFlex, "column", false, "flex-start", "stretch");
        appFlex.setBackColor("#ffffff");
        appFlex.setClickable(true);
        Style style = new Style();
        Margin imageMargin = new Margin();
        imageMargin.setBottom("6px");
        style.setMargin(imageMargin);
        FlexPanelAp appImageFlex = HrobsPageUtil.customFlexPane("appImageFlex", imageMargin, null, null, null, "48px");
        HrobsPageUtil.setFlexGrowAndShrink(appImageFlex, 0, 0);
        appImageFlex.setOverflow("hidden");
        HrobsPageUtil.setFlexDirection(appImageFlex, "column", false, "center", "center");
        ImageAp imageAp = this.buildImageAp((String)appConfigDy.get("systemicon"), index);
        appImageFlex.getItems().add(imageAp);
        FlexPanelAp appTitleFlex = HrobsPageUtil.customFlexPane("appTitleFlex", null, null, null, null, null);
        HrobsPageUtil.setFlexGrowAndShrink(appTitleFlex, 0, 0);
        appTitleFlex.setOverflow("hidden");
        HrobsPageUtil.setFlexDirection(appTitleFlex, "row", false, "center", "flex-start");
        LabelAp titleLabel = this.buildAppTitleLabel(new LocaleString(appConfigDy.get("name").toString()), index);
        titleLabel.setGrow(0);
        titleLabel.setGrow(1);
        titleLabel.setWidth(new LocaleString("96px"));
        appTitleFlex.getItems().add(titleLabel);
        appFlex.getItems().add(appImageFlex);
        appFlex.getItems().add(appTitleFlex);
        return appFlex;
    }

    private ImageAp buildImageAp(String imageUrl, int index) {
        ImageAp imageAp = new ImageAp();
        imageAp.setImageKey(imageUrl);
        imageAp.setKey(IMAGEKEY + index);
        imageAp.setHeight(new LocaleString("48px"));
        imageAp.setWidth(new LocaleString("48px"));
        return imageAp;
    }

    private LabelAp buildAppTitleLabel(LocaleString title, int index) {
        LabelAp titleLabelAp = HrobsPageUtil.customLabel(LABEL_NAME + index, title, 12, "#666666");
        titleLabelAp.setGrow(0);
        titleLabelAp.setShrink(1);
        titleLabelAp.setTextAlign("center");
        titleLabelAp.setAutoTextWrap(true);
        return titleLabelAp;
    }

    private void addFlexPanel(String id, FlexPanelAp flexPanelAp, LoadCustomControlMetasArgs args) {
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("id", id);
        params.put("items", (String)flexPanelAp.createControl().get("items"));
        args.getItems().add(params);
    }
}

