/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrobs.formplugin.portal.pc;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.LogPrivacyUtil;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hrmp.hrobs.business.domain.service.corporateculture.ICorporateCultureService;
import kd.hrmp.hrobs.business.domain.service.portal.IEmpInfoService;
import org.apache.commons.lang3.StringUtils;

public class PcEmpInfoPlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOGGER = LogFactory.getLog(PcEmpInfoPlugin.class);
    private static final String J_ICON = "j_icon";
    private static final String JOB_ICON = "job_icon";
    private static final String P_ICON = "p_icon";
    private static final String STD_ICON = "std_icon";
    private static final String FLEXPANELAP_11 = "flexpanelap11";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long startTime = System.currentTimeMillis();
        this.initHeadCard();
        Long endTime = System.currentTimeMillis();
        LOGGER.info("PcEmpInfoPlugin_initHeadCard total time : {}", (Object)(endTime - startTime));
    }

    private void initHeadCard() {
        Label lblPosition;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Long startTime = System.currentTimeMillis();
        Map personInfo = IEmpInfoService.getInstance().getPersonInfo();
        Long endTime = System.currentTimeMillis();
        LOGGER.info("PcEmpInfoPlugin_personInfo total time : {}", (Object)(endTime - startTime));
        LOGGER.info("PcEmpInfoPlugin_personInfo:{}", (Object)LogPrivacyUtil.filterPrivacyProp((Map)personInfo, (List)Lists.newArrayList((Object[])new String[]{"aphone", "aemail", "bphone", "bemail", "phone", "email", "headsculpture"})));
        if (personInfo == null) {
            return;
        }
        model.setValue("headsculpture", personInfo.get("headsculpture"));
        Label lblCompany = (Label)this.getView().getControl("company");
        String company = personInfo.get("company") == null ? "" : (String)personInfo.get("company");
        lblCompany.setText(company);
        Label lblAdminOrg = (Label)this.getView().getControl("adminorg");
        String adminOrg = personInfo.get("adminorg") == null ? "" : (String)personInfo.get("adminorg");
        lblAdminOrg.setText(adminOrg);
        String position = personInfo.get("position") == null ? "" : (String)personInfo.get("position");
        String stdposition = personInfo.get("stdposition") == null ? "" : (String)personInfo.get("stdposition");
        String positionType = (String)personInfo.get("apositiontype");
        String job = personInfo.get("job") == null ? "" : (String)personInfo.get("job");
        model.setValue("name", (Object)("Hi, " + personInfo.get("name")));
        view.setVisible(Boolean.valueOf(false), new String[]{"job", JOB_ICON, STD_ICON, P_ICON, J_ICON});
        if (HRStringUtils.isNotEmpty((String)positionType) && HRStringUtils.equals((String)positionType, (String)"0")) {
            lblPosition = (Label)this.getView().getControl("position");
            lblPosition.setText(stdposition);
            view.setVisible(Boolean.valueOf(true), new String[]{STD_ICON});
            if (HRStringUtils.isNotEmpty((String)job)) {
                view.setVisible(Boolean.valueOf(true), new String[]{JOB_ICON, "job"});
                Label lblJob = (Label)this.getView().getControl("job");
                lblJob.setText(job);
            }
        } else if (HRStringUtils.isNotEmpty((String)positionType) && HRStringUtils.equals((String)positionType, (String)"1")) {
            lblPosition = (Label)this.getView().getControl("position");
            lblPosition.setText(position);
            view.setVisible(Boolean.valueOf(true), new String[]{P_ICON});
            if (HRStringUtils.isNotEmpty((String)job)) {
                view.setVisible(Boolean.valueOf(true), new String[]{JOB_ICON, "job"});
                Label lblJob = (Label)this.getView().getControl("job");
                lblJob.setText(job);
            }
        } else if (HRStringUtils.isNotEmpty((String)positionType) && HRStringUtils.equals((String)positionType, (String)"2")) {
            view.setVisible(Boolean.valueOf(true), new String[]{J_ICON});
            lblPosition = (Label)this.getView().getControl("position");
            lblPosition.setText(job);
        } else {
            LOGGER.error("error when drawing personCard , please check the positionType and the value under this type ");
        }
        model.setValue("entrydays", (Object)PcEmpInfoPlugin.getEntryDays((Date)personInfo.get("startdate")));
        String corporateculture = ICorporateCultureService.getInstance().getCorporateCulture();
        if (StringUtils.isNotBlank((CharSequence)corporateculture)) {
            model.setValue("corporateculture", (Object)corporateculture);
        } else {
            view.setVisible(Boolean.FALSE, new String[]{FLEXPANELAP_11});
        }
    }

    public static String getEntryDays(Date startdate) {
        long diffDay = startdate == null ? 0L : HRDateTimeUtils.dateDiff((Date)startdate, (Date)new Date()) / 86400000L + 1L;
        return ResManager.loadKDString((String)"\u6211\u4eec\u5df2\u643a\u624b\u540c\u884c%s\u5929", (String)"PcEmpInfoPlugin_0", (String)"hrmp-hrobs-formplugin", (Object[])new Object[]{diffDay});
    }
}

