/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrobs.formplugin.portal.pc;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.portal.pluginnew.GridCardPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrobs.business.domain.repository.CardProcessRepository;
import kd.hrmp.hrobs.business.domain.repository.CardRepository;
import kd.hrmp.hrobs.business.domain.service.process.IMessageCenterService;
import kd.hrmp.hrobs.common.enums.AlignItemsEnum;
import kd.hrmp.hrobs.common.enums.DirectionEnum;
import kd.hrmp.hrobs.common.enums.JustifyContentEnum;
import kd.hrmp.hrobs.common.enums.ProcessTypeEnum;
import kd.hrmp.hrobs.common.enums.TerminalEnum;
import kd.hrmp.hrobs.common.utils.ComboUtils;
import kd.hrmp.hrobs.formplugin.utils.CustomControlUtils;
import kd.hrmp.hrobs.formplugin.utils.ShowFormUtils;

public class ProcessCardPlugin
extends GridCardPlugin {
    private static final Log LOGGER = LogFactory.getLog(ProcessCardPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"freshvectorap"});
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        IFormView formView = this.getView();
        if (HRStringUtils.startsWithIgnoreCase((String)key, (String)"processcountlabelap")) {
            Container container = new Container();
            container.setKey(key);
            container.setView(formView);
            container.addClickListener((ClickListener)this);
            args.setControl((Control)container);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        IFormView formView = this.getView();
        if (HRStringUtils.equals((String)key, (String)"freshvectorap")) {
            formView.updateView();
            return;
        }
        if (HRStringUtils.startsWithIgnoreCase((String)key, (String)"processcountlabelap")) {
            FormShowParameter formShowParameter = ShowFormUtils.buildFormShowParameter("_submaintab_", "hrobs_pc_messagecenter", ShowType.MainNewTabPage, OperationStatus.VIEW);
            String[] split = key.split("_");
            formShowParameter.setCustomParam("cardId", (Object)Long.valueOf(split[1]));
            formShowParameter.setCustomParam("selectProcessType", (Object)split[2]);
            String pageId = formView.getFormShowParameter().getParentPageId() + "hrobs_pc_messagecenter";
            ShowFormUtils.mainTabOpenPage(formView, formShowParameter, pageId);
            IFormView messageCenterView = formView.getView(pageId);
            if (messageCenterView != null) {
                IPageCache pageCache = messageCenterView.getPageCache();
                pageCache.put("selectProcessType", split[2]);
                messageCenterView.invokeOperation("refresh");
                this.getView().sendFormAction(messageCenterView);
            }
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        String cardIdStr = this.getCardId();
        if (HRStringUtils.isEmpty((String)cardIdStr)) {
            LOGGER.info("cardId is null");
            return;
        }
        Long cardId = Long.valueOf(cardIdStr);
        FlexPanelAp titleNameFlexPanelAp = CustomControlUtils.customFlexPane("titlenameflexpanelap", null, null, null, null, null);
        CustomControlUtils.setControlApGrowAndShrink((ControlAp)titleNameFlexPanelAp, 0, 1);
        DynamicObject card = CardRepository.getRepository().queryOne("name", (Object)cardId);
        String titleName = card.getString("name");
        LabelAp titleLabelAp = CustomControlUtils.customLabel("titlelabelap", new LocaleString(titleName), 14, "#212121", false);
        CustomControlUtils.setControlApGrowAndShrink((ControlAp)titleLabelAp, 0, 1);
        titleNameFlexPanelAp.getItems().add(titleLabelAp);
        HashMap<String, String> titleLabelApParams = new HashMap<String, String>(16);
        titleLabelApParams.put("id", "titlenameflexpanelap");
        titleLabelApParams.put("items", (String)titleNameFlexPanelAp.createControl().get("items"));
        this.getView().updateControlMetadata("titlenameflexpanelap", titleLabelApParams);
        FlexPanelAp contentFlexPanelAp = this.customContentFlexPanelAp(cardId);
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("id", "contentflexpanelap");
        params.put("items", (String)contentFlexPanelAp.createControl().get("items"));
        this.getView().updateControlMetadata("contentflexpanelap", params);
    }

    private FlexPanelAp customContentFlexPanelAp(Long cardId) {
        DynamicObject[] cardProcessArrays = CardProcessRepository.getRepository().queryByCardId(cardId, TerminalEnum.PC, "processtype,color");
        Padding flexPanelApPadding = CustomControlUtils.buildPadding("7px", "20px", "10px", "10px");
        FlexPanelAp flexPanelAp = CustomControlUtils.customFlexPane("contentflexpanelap", null, flexPanelApPadding, null, null, null);
        CustomControlUtils.setControlApGrowAndShrink((ControlAp)flexPanelAp, 0, 1);
        CustomControlUtils.setFlexDirection(flexPanelAp, DirectionEnum.ROW, true, null, null, null);
        if (cardProcessArrays.length == 0) {
            LOGGER.info("cardProcessArrays is null");
            return flexPanelAp;
        }
        for (int i = 0; i < cardProcessArrays.length; ++i) {
            DynamicObject cardProcess = cardProcessArrays[i];
            ProcessTypeEnum processType = ProcessTypeEnum.getByValue((String)cardProcess.getString("processtype"));
            String leftBorder = CustomControlUtils.getBorderStyle(null, null, "#D9D9D9");
            Border border = null;
            if (i != 0) {
                border = CustomControlUtils.buildBorder(null, null, leftBorder, null);
            }
            String processTypeValue = processType.getValue();
            String processFlexPanelApKey = String.format("processflexpanelap_%s_%s", cardId, processTypeValue);
            FlexPanelAp processFlexPanelAp = CustomControlUtils.customFlexPane(processFlexPanelApKey, null, null, border, null, "86px");
            CustomControlUtils.setControlApGrowAndShrink((ControlAp)processFlexPanelAp, 1, 1);
            CustomControlUtils.setFlexDirection(processFlexPanelAp, DirectionEnum.COLUMN, false, JustifyContentEnum.CENTER, AlignItemsEnum.CENTER, null);
            flexPanelAp.getItems().add(processFlexPanelAp);
            int count = IMessageCenterService.getInstance().getTaskCountByType(processType, TerminalEnum.PC, null);
            String processCountLabelApKey = String.format("processcountlabelap_%s_%s", cardId, processTypeValue);
            String processColor = cardProcess.getString("color");
            LabelAp processCountLabelAp = CustomControlUtils.customLabel(processCountLabelApKey, new LocaleString(IMessageCenterService.getInstance().getDisplayCount(count)), 48, processColor, true);
            CustomControlUtils.setControlApGrowAndShrink((ControlAp)processCountLabelAp, 0, 1);
            processFlexPanelAp.getItems().add(processCountLabelAp);
            LocaleString processTypeName = ComboUtils.getComboOptionName((DynamicObject)cardProcess, (String)"processtype");
            String processNameLabelApKey = String.format("processnamelabelap_%s_%s", cardId, processTypeValue);
            LabelAp processNameLabelAp = CustomControlUtils.customLabel(processNameLabelApKey, processTypeName, 14, "#666666", false);
            CustomControlUtils.setControlApGrowAndShrink((ControlAp)processNameLabelAp, 0, 1);
            processFlexPanelAp.getItems().add(processNameLabelAp);
        }
        return flexPanelAp;
    }
}

