/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrobs.formplugin.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hrobs.business.domain.repository.ProcessConfigRepository;
import kd.hrmp.hrobs.business.domain.service.portal.IAppConfigService;
import org.apache.commons.lang3.ObjectUtils;

public class ProcessManagementListPlugin
extends AbstractListPlugin {
    private static final Log LOGGER = LogFactory.getLog(ProcessManagementListPlugin.class);
    public static final String ENTRABILL = "entrabill";
    public static final String PUBLISH = "publish";
    public static final String APPLICATIONID = "applicationid";
    public static final String WF_MODEL = "wf_model";
    public static final String BOS_ENTITYOBJECT = "bos_entityobject";
    public static final String HROBS_SYNC_PROCESS = "hrobs_sync_process";
    public static final String SYNC_CONFIRM_CALLBACK = "sync_confirm_callback";
    private static final DLock LOCK = DLock.create((String)"hrobs_sync_process", (String)"sync process");
    public static final String BIZCLOUD = "bizcloud";

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("donothing_sync".equals(operateKey)) {
            this.syncProcess();
        }
    }

    private void syncProcess() {
        DynamicObject[] syncProcess;
        LOGGER.info("ProcessManagementListPlugin_sync1 process lock info : {}", (Object)String.valueOf(DLock.getLockInfo((String)HROBS_SYNC_PROCESS)));
        DLockInfo dLockInfo = DLock.getLockInfo((String)HROBS_SYNC_PROCESS);
        if (ObjectUtils.isEmpty((Object)dLockInfo)) {
            LOGGER.info("ProcessManagementListPlugin_sync process lock info : {}", (Object)String.valueOf(DLock.getLockInfo((String)HROBS_SYNC_PROCESS)));
            syncProcess = this.getSyncProcess();
            if (syncProcess == null || ObjectUtils.isEmpty((Object)syncProcess)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ecf\u68c0\u6d4b\uff0c\u6682\u65e0\u65b0\u7684HR\u670d\u52a1\u6d41\u7a0b\u5bf9\u8c61\u9700\u540c\u6b65\u3002", (String)"ProcessManagementListPlugin_1", (String)"hrmp-hrobs-formplugin", (Object[])new Object[0]));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6709\u5176\u4ed6\u7528\u6237\u6b63\u5728\u540c\u6b65HR\u670d\u52a1\u6d41\u7a0b\u5bf9\u8c61\uff0c\u65e0\u9700\u91cd\u590d\u6267\u884c\u3002", (String)"ProcessManagementListPlugin_2", (String)"hrmp-hrobs-formplugin", (Object[])new Object[0]));
        }
        this.showConfirmPopup(syncProcess.length);
        LOGGER.info("ProcessManagementListPlugin_will sync process: {} ", (Object)syncProcess.length);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String resultValue = messageBoxClosedEvent.getResultValue();
        if (!MessageBoxResult.Yes.name().equals(resultValue) && !MessageBoxResult.OK.name().equals(resultValue)) {
            return;
        }
        String actionId = messageBoxClosedEvent.getCallBackId();
        if (SYNC_CONFIRM_CALLBACK.equalsIgnoreCase(actionId)) {
            try {
                boolean b = LOCK.tryLock();
                if (!b) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6709\u5176\u4ed6\u7528\u6237\u6b63\u5728\u540c\u6b65HR\u670d\u52a1\u6d41\u7a0b\u5bf9\u8c61\uff0c\u65e0\u9700\u91cd\u590d\u6267\u884c\u3002", (String)"ProcessManagementListPlugin_4", (String)"hrmp-hrobs-formplugin", (Object[])new Object[0]));
                }
                this.startSyncProcess();
            }
            catch (IllegalStateException e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6709\u5176\u4ed6\u7528\u6237\u6b63\u5728\u540c\u6b65HR\u670d\u52a1\u6d41\u7a0b\u5bf9\u8c61\uff0c\u65e0\u9700\u91cd\u590d\u6267\u884c\u3002", (String)"ProcessManagementListPlugin_7", (String)"hrmp-hrobs-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void startSyncProcess() {
        try {
            DynamicObject[] syncProcess = this.getSyncProcess();
            if (syncProcess == null || ObjectUtils.isEmpty((Object)syncProcess)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6709\u5176\u4ed6\u7528\u6237\u5df2\u540c\u6b65\u5f53\u524d\u7684HR\u670d\u52a1\u6d41\u7a0b\u5bf9\u8c61\uff0c\u65e0\u9700\u91cd\u590d\u6267\u884c\u3002", (String)"ProcessManagementListPlugin_6", (String)"hrmp-hrobs-formplugin", (Object[])new Object[0]));
            }
            this.doSyncProcess(syncProcess);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        finally {
            LOCK.unlock();
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f", (String)"ProcessManagementListPlugin_3", (String)"hrmp-hrobs-formplugin", (Object[])new Object[0]));
        this.getView().updateView();
    }

    private DynamicObject[] getSyncProcess() {
        List<DynamicObject> existProcess = this.queryExistProcess();
        List<String> existProcessNumbers = new ArrayList<String>();
        if (ObjectUtils.isNotEmpty(existProcess)) {
            existProcessNumbers = existProcess.stream().filter(e -> e != null && e.get("number") != null).map(e -> String.valueOf(e.get("number"))).collect(Collectors.toList());
        }
        return this.querySyncProcess(existProcessNumbers);
    }

    private void showConfirmPopup(int length) {
        ConfirmCallBackListener confirm = new ConfirmCallBackListener(SYNC_CONFIRM_CALLBACK, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u672c\u6b21\u6267\u884c\u3010\u540c\u6b65\u6d41\u7a0b\u3011\u540e\u589e\u52a0\uff1a%s\u4e2a\u3010\u4f7f\u7528\u72b6\u6001=\u5f85\u542f\u7528\u3011HR\u670d\u52a1\u6d41\u7a0b\u5bf9\u8c61\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProcessManagementListPlugin_5", (String)"hrmp-hrobs-formplugin", (Object[])new Object[]{length}), MessageBoxOptions.OKCancel, confirm);
    }

    private List<DynamicObject> queryExistProcess() {
        DynamicObject[] dynamicObjects = ProcessConfigRepository.getRepository().loadDynamicObjectArray(new QFilter[0]);
        return Arrays.stream(dynamicObjects).filter(Objects::nonNull).map(e -> e.getDynamicObject("businessobject")).collect(Collectors.toList());
    }

    private DynamicObject[] querySyncProcess(List<String> existProcessNumbers) {
        List appIds = IAppConfigService.getInstance().getHrAppIds();
        if (CollectionUtils.isEmpty((Collection)appIds)) {
            return null;
        }
        HRBaseServiceHelper modelServiceHelper = new HRBaseServiceHelper(WF_MODEL);
        QFilter appIdFilter = new QFilter(APPLICATIONID, "in", (Object)appIds);
        QFilter pFilter = new QFilter(PUBLISH, "=", (Object)"1");
        QFilter dFilter = new QFilter("discard", "=", (Object)"0");
        QFilter eFilter = new QFilter(ENTRABILL, "not in", existProcessNumbers);
        DynamicObject[] dynamicObjects = modelServiceHelper.loadDynamicObjectArray(new QFilter[]{appIdFilter, pFilter, dFilter, eFilter});
        Set set = Arrays.stream(dynamicObjects).map(e -> e.getString(ENTRABILL)).collect(Collectors.toSet());
        HRBaseServiceHelper entityObjectHelper = new HRBaseServiceHelper(BOS_ENTITYOBJECT);
        QFilter numFilter = new QFilter("number", "in", set);
        QFilter appFilter = new QFilter("bizappid", "!=", null);
        DynamicObject[] entityObjects = entityObjectHelper.loadDynamicObjectArray(new QFilter[]{numFilter, appFilter});
        LOGGER.info("ProcessManagementListPlugin_wf_model list: {} ", (Object)dynamicObjects.length);
        return entityObjects;
    }

    private void doSyncProcess(DynamicObject[] syncProcess) {
        DynamicObjectCollection processConfigs = new DynamicObjectCollection();
        for (DynamicObject entityObject : syncProcess) {
            DynamicObject emptyDynamicObject = ProcessConfigRepository.getRepository().generateEmptyDynamicObject();
            DynamicObject bizappid = entityObject.getDynamicObject("bizappid");
            DynamicObject bizcloud = bizappid.getDynamicObject(BIZCLOUD);
            emptyDynamicObject.set("number", entityObject.get("number"));
            emptyDynamicObject.set("name", entityObject.get("name"));
            emptyDynamicObject.set("businessobject", (Object)entityObject);
            emptyDynamicObject.set("appid", bizappid.get("name"));
            emptyDynamicObject.set("cloudid", bizcloud.get("name"));
            emptyDynamicObject.set("enable", (Object)"10");
            processConfigs.add((Object)emptyDynamicObject);
        }
        LOGGER.info("ProcessManagementListPlugin_processConfigs: {} ", (Object)processConfigs.size());
        ProcessConfigRepository.getRepository().save(processConfigs);
    }
}

