/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrobs.formplugin.provider;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hrobs.business.domain.service.portal.IAppConfigService;
import kd.hrmp.hrobs.common.constants.HROBSConstants;
import kd.hrmp.hrobs.common.enums.HROBSTerminalEnum;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class AppConfigListProvider
extends ListDataProvider {
    private static final Log LOGGER = LogFactory.getLog(AppConfigListProvider.class);
    public static final String BIZCLOUD_NAME = "bizcloud.name";

    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection rows = super.getData(start, limit);
        if (rows.isEmpty()) {
            return rows;
        }
        this.addAppConfigDynamicProperty(rows);
        return rows;
    }

    private void addAppConfigDynamicProperty(DynamicObjectCollection rows) {
        DynamicSimpleProperty allTerminal = new DynamicSimpleProperty("allterminal", String.class, null);
        DynamicSimpleProperty bizCloud = new DynamicSimpleProperty("bizcloud", String.class, null);
        DynamicSimpleProperty bizApp = new DynamicSimpleProperty("bizapp", String.class, null);
        rows.getDynamicObjectType().addProperty((DynamicProperty)allTerminal);
        rows.getDynamicObjectType().addProperty((DynamicProperty)bizCloud);
        rows.getDynamicObjectType().addProperty((DynamicProperty)bizApp);
        List ids = rows.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
        DynamicObject[] appConfigList = IAppConfigService.getInstance().getAppConfigByIds(ids);
        for (DynamicObject row : rows) {
            Optional<DynamicObject> optional = Arrays.stream(appConfigList).filter(e -> e.get("id").equals(row.get("id"))).findFirst();
            if (!optional.isPresent()) continue;
            DynamicObject dynamicObject = optional.get();
            LOGGER.info("parseDyObject_dynamicObject:{}", (Object)dynamicObject.getDynamicObjectCollection("entryentity"));
            List<DynamicObject> entryDyCollection = dynamicObject.getDynamicObjectCollection("entryentity").stream().sorted(Comparator.comparing(e -> e.get("terminal").toString())).collect(Collectors.toList());
            dynamicObject.set("entryentity", entryDyCollection);
            Map<String, String> statisticsMap = this.parseDyObject(entryDyCollection, dynamicObject.getString("appsource"));
            row.set("allterminal", (Object)statisticsMap.get("allterminal"));
            row.set("bizcloud", (Object)statisticsMap.get("bizcloud"));
            row.set("bizapp", (Object)statisticsMap.get("bizapp"));
        }
    }

    private Map<String, String> parseDyObject(List<DynamicObject> entryDyCollection, String appSource) {
        HashMap<String, String> statisticsMap = new HashMap<String, String>(16);
        String allterminal = "";
        String bizapp = "";
        String bizcloud = "";
        if (ObjectUtils.isNotEmpty(entryDyCollection)) {
            Optional<DynamicObject> dynamicObjectOptional;
            for (DynamicObject dynamicObject : entryDyCollection) {
                LOGGER.info("AppConfigListProvider_parseDyObject_dynamicObject:{}", (Object)dynamicObject);
                if ("0".equals(appSource) && ObjectUtils.isEmpty((Object)dynamicObject.get("form")) || "1".equals(appSource) && ObjectUtils.isEmpty((Object)dynamicObject.get("url"))) continue;
                if (StringUtils.isBlank((CharSequence)allterminal)) {
                    allterminal = HROBSTerminalEnum.getName((String)dynamicObject.getString("terminal"));
                    continue;
                }
                allterminal = String.join(HROBSConstants.CN_COMMA, allterminal, HROBSTerminalEnum.getName((String)dynamicObject.getString("terminal")));
            }
            DynamicObject dynamicObject = new DynamicObject();
            LOGGER.info("AppConfigListProvider_entryDyCollection.size():{}", (Object)entryDyCollection.size());
            if (entryDyCollection.size() == 1) {
                dynamicObject = entryDyCollection.get(0);
            } else if (entryDyCollection.size() >= 2 && (dynamicObjectOptional = entryDyCollection.stream().filter(e -> e.get("terminal").equals("0")).findFirst()).isPresent()) {
                dynamicObject = dynamicObjectOptional.get();
                LOGGER.info("AppConfigListProvider_entryDyCollection.size():{}", (Object)entryDyCollection.size());
                if (ObjectUtils.isEmpty((Object)dynamicObject.get("form"))) {
                    dynamicObject = entryDyCollection.get(1);
                }
            }
            if (ObjectUtils.isNotEmpty((Object)dynamicObject)) {
                DynamicObject form = dynamicObject.getDynamicObject("form");
                if (ObjectUtils.isEmpty((Object)form)) {
                    LOGGER.info("form is null ,appInfo:{}", (Object)form);
                    statisticsMap.put("allterminal", allterminal);
                    return statisticsMap;
                }
                DynamicObject bizApp = this.getBizApp(form.get("bizappid"));
                LOGGER.info("getBizCloud_Info:{}", (Object)bizApp);
                bizapp = bizApp.getString("name");
                bizcloud = bizApp.getString(BIZCLOUD_NAME);
            }
        }
        statisticsMap.put("allterminal", allterminal);
        statisticsMap.put("bizapp", bizapp);
        statisticsMap.put("bizcloud", bizcloud);
        return statisticsMap;
    }

    private DynamicObject getBizApp(Object bizAppId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
        return serviceHelper.queryOne(BIZCLOUD_NAME, new QFilter("id", "=", bizAppId));
    }
}

