/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrobs.formplugin.utils;

import com.alibaba.fastjson.JSONObject;
import java.util.Base64;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrobs.common.enums.AlignContentEnum;
import kd.hrmp.hrobs.common.enums.AlignItemsEnum;
import kd.hrmp.hrobs.common.enums.ButtonStyleEnum;
import kd.hrmp.hrobs.common.enums.DirectionEnum;
import kd.hrmp.hrobs.common.enums.JustifyContentEnum;
import kd.hrmp.hrobs.common.enums.TabDirectionEnum;

public class CustomControlUtils {
    public static FlexPanelAp customFlexPane(String key, Margin margin, Padding padding, Border border, String width, String height) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(key);
        CustomControlUtils.setControlApStyle((ControlAp)flexPanelAp, margin, padding, border);
        CustomControlUtils.setControlApSimpleStyle((ControlAp)flexPanelAp, 0, null, null, height, width);
        return flexPanelAp;
    }

    public static void setControlApStyle(ControlAp controlAp, Margin margin, Padding padding, Border border) {
        Style style = new Style();
        if (margin != null) {
            style.setMargin(margin);
        }
        if (padding != null) {
            style.setPadding(padding);
        }
        if (border != null) {
            style.setBorder(border);
        }
        controlAp.setStyle(style);
    }

    public static LabelAp customLabel(String key, LocaleString name, int fontSize, String fontColor, boolean clickable) {
        LabelAp labelAp = new LabelAp();
        CustomControlUtils.setControlApKeyAndName((ControlAp)labelAp, key, name);
        CustomControlUtils.setControlApSimpleStyle((ControlAp)labelAp, fontSize, fontColor, null, null, null);
        labelAp.setClickable(clickable);
        return labelAp;
    }

    public static VectorAp customVectorAp(String key, String foreColor, String fontClass, int fontSize, boolean clickable) {
        VectorAp vectorAp = new VectorAp();
        vectorAp.setKey(key);
        CustomControlUtils.setControlApGrowAndShrink((ControlAp)vectorAp, 0, 1);
        CustomControlUtils.setControlApSimpleStyle((ControlAp)vectorAp, fontSize, foreColor, null, null, null);
        if (fontClass != null) {
            vectorAp.setfontClass(fontClass);
        }
        vectorAp.setAlignSelf("center");
        vectorAp.setClickable(clickable);
        return vectorAp;
    }

    public static ButtonAp customButtonAp(String key, LocaleString name, ButtonStyleEnum buttonStyle, int fontsize, String foreColor, String fontClass, String width, String height) {
        ButtonAp buttonAp = new ButtonAp();
        CustomControlUtils.setControlApKeyAndName((ControlAp)buttonAp, key, name);
        buttonAp.setButtonStyle(buttonStyle.getValue());
        buttonAp.setfontClass(fontClass);
        CustomControlUtils.setControlApSimpleStyle((ControlAp)buttonAp, fontsize, foreColor, null, height, width);
        return buttonAp;
    }

    public static void setControlApGrowAndShrink(ControlAp controlAp, int grow, int shrink) {
        controlAp.setGrow(grow);
        controlAp.setShrink(shrink);
    }

    public static void setControlApKeyAndName(ControlAp controlAp, String key, LocaleString name) {
        controlAp.setKey(key);
        if (name != null) {
            controlAp.setName(name);
        }
    }

    public static Padding buildPadding(String top, String bottom, String left, String right) {
        Padding padding = new Padding();
        if (HRStringUtils.isNotEmpty((String)top)) {
            padding.setTop(top);
        }
        if (HRStringUtils.isNotEmpty((String)bottom)) {
            padding.setBottom(bottom);
        }
        if (HRStringUtils.isNotEmpty((String)left)) {
            padding.setLeft(left);
        }
        if (HRStringUtils.isNotEmpty((String)right)) {
            padding.setRight(right);
        }
        return padding;
    }

    public static Padding buildPadding(String padding) {
        return CustomControlUtils.buildPadding(padding, padding, padding, padding);
    }

    public static Padding buildPadding(String top, String left) {
        return CustomControlUtils.buildPadding(top, top, left, left);
    }

    public static Margin buildMargin(String top, String bottom, String left, String right) {
        Margin margin = new Margin();
        if (HRStringUtils.isNotEmpty((String)top)) {
            margin.setTop(top);
        }
        if (HRStringUtils.isNotEmpty((String)bottom)) {
            margin.setBottom(bottom);
        }
        if (HRStringUtils.isNotEmpty((String)left)) {
            margin.setLeft(left);
        }
        if (HRStringUtils.isNotEmpty((String)right)) {
            margin.setRight(right);
        }
        return margin;
    }

    public static Margin buildMargin(String margin) {
        return CustomControlUtils.buildMargin(margin, margin, margin, margin);
    }

    public static Border buildBorder(String top, String bottom, String left, String right) {
        Border border = new Border();
        if (HRStringUtils.isNotEmpty((String)top)) {
            border.setTop(top);
        }
        if (HRStringUtils.isNotEmpty((String)bottom)) {
            border.setBottom(bottom);
        }
        if (HRStringUtils.isNotEmpty((String)left)) {
            border.setLeft(left);
        }
        if (HRStringUtils.isNotEmpty((String)right)) {
            border.setRight(right);
        }
        return border;
    }

    public static Border buildBorder(String border) {
        return CustomControlUtils.buildBorder(border, border, border, border);
    }

    public static String getBorderStyle(String lineSize, String lineStyle, String lineColor) {
        lineSize = HRStringUtils.isNotEmpty((String)lineSize) ? lineSize : "1px";
        lineStyle = HRStringUtils.isNotEmpty((String)lineStyle) ? lineStyle : "solid";
        lineColor = HRStringUtils.isNotEmpty((String)lineColor) ? lineColor : "themeColor";
        return String.format("%s_%s_%s", lineSize, lineColor, lineStyle);
    }

    public static void setFlexDirection(FlexPanelAp flexPanelAp, DirectionEnum direction, boolean flexWrap, JustifyContentEnum justifyContent, AlignItemsEnum alignItems, AlignContentEnum alignContent) {
        if (direction != null) {
            flexPanelAp.setDirection(direction.getValue());
        }
        flexPanelAp.setWrap(flexWrap);
        if (justifyContent != null) {
            flexPanelAp.setJustifyContent(justifyContent.getValue());
        }
        if (alignItems != null) {
            flexPanelAp.setAlignItems(alignItems.getValue());
        }
        if (alignContent != null) {
            flexPanelAp.setAlignContent(alignContent.getValue());
        }
    }

    public static void setControlApSimpleStyle(ControlAp controlAp, int fontsize, String foreColor, String backColor, String height, String width) {
        if (fontsize != 0) {
            controlAp.setFontSize(fontsize);
        }
        if (HRStringUtils.isNotEmpty((String)foreColor)) {
            controlAp.setForeColor(foreColor);
        }
        if (HRStringUtils.isNotEmpty((String)backColor)) {
            controlAp.setBackColor(backColor);
        }
        if (HRStringUtils.isNotEmpty((String)height)) {
            controlAp.setHeight(new LocaleString(height));
        }
        if (HRStringUtils.isNotEmpty((String)width)) {
            controlAp.setWidth(new LocaleString(width));
        }
    }

    public static TabAp customTabAp(String apKey, TabDirectionEnum tabDirection, int tabStyle) {
        TabAp tabAp = new TabAp();
        tabAp.setId(apKey);
        tabAp.setKey(apKey);
        tabAp.setClickable(true);
        tabAp.setCanSlide(true);
        tabAp.setTabStyle(tabStyle);
        if (tabDirection != null) {
            tabAp.setTabDirection(tabDirection.getValue());
        }
        return tabAp;
    }

    public static TabPageAp customTabPageAp(String apKey, LocaleString name, String parentId) {
        TabPageAp tabPageAp = new TabPageAp();
        tabPageAp.setKey(apKey);
        tabPageAp.setName(name);
        tabPageAp.setId(apKey);
        tabPageAp.setParentId(parentId);
        return tabPageAp;
    }

    public static void setControlApCustomStyle(ControlAp controlAp, String customStyle) {
        JSONObject customStyleMap = new JSONObject();
        customStyleMap.put("type", (Object)"0");
        customStyleMap.put("content", (Object)customStyle);
        String customStyleBase64 = Base64.getEncoder().encodeToString(customStyleMap.toJSONString().getBytes());
        controlAp.setCustomeStyles(customStyleBase64);
    }
}

