/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrobs.formplugin.utils;

import java.util.Objects;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;

public class ShowFormUtils {
    public static MobileFormShowParameter buildMobileFormShowParameter(String targetKey, String formId, ShowType showType, OperationStatus status) {
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setFormId(formId);
        if (status != null) {
            formShowParameter.setStatus(status);
        }
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setTargetKey(targetKey);
        openStyle.setShowType(showType != null ? showType : ShowType.InContainer);
        return formShowParameter;
    }

    public static FormShowParameter buildFormShowParameter(String targetKey, String formId, ShowType showType, OperationStatus status) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        if (status != null) {
            formShowParameter.setStatus(status);
        }
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setTargetKey(targetKey);
        openStyle.setShowType(showType != null ? showType : ShowType.MainNewTabPage);
        return formShowParameter;
    }

    public static ListShowParameter buildListShowParameter(String targetKey, String formId, ShowType showType, OperationStatus status) {
        ListShowParameter formShowParameter = new ListShowParameter();
        formShowParameter.setBillFormId(formId);
        if (status != null) {
            formShowParameter.setStatus(status);
        }
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setTargetKey(targetKey);
        openStyle.setShowType(showType != null ? showType : ShowType.MainNewTabPage);
        return formShowParameter;
    }

    public static MobileListShowParameter buildMobileListShowParameter(String targetKey, String formId, ShowType showType, OperationStatus status) {
        MobileListShowParameter formShowParameter = new MobileListShowParameter();
        formShowParameter.setBillFormId(formId);
        if (status != null) {
            formShowParameter.setStatus(status);
        }
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setTargetKey(targetKey);
        openStyle.setShowType(showType != null ? showType : ShowType.MainNewTabPage);
        return formShowParameter;
    }

    public static BillShowParameter buildBillShowParameter(String targetKey, String formId, ShowType showType, OperationStatus status) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(formId);
        if (status != null) {
            showParameter.setStatus(status);
        }
        OpenStyle openStyle = showParameter.getOpenStyle();
        openStyle.setTargetKey(targetKey);
        openStyle.setShowType(showType != null ? showType : ShowType.MainNewTabPage);
        showParameter.setClientParam("requestBeforeClose", (Object)Boolean.TRUE);
        return showParameter;
    }

    public static MobileBillShowParameter buildMobileBillShowParameter(String targetKey, String formId, ShowType showType, OperationStatus status) {
        MobileBillShowParameter showParameter = new MobileBillShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(showType);
        if (status != null) {
            showParameter.setStatus(status);
        }
        showParameter.setClientParam("requestBeforeClose", (Object)Boolean.TRUE);
        return showParameter;
    }

    public static void mainTabOpenPage(IFormView formView, FormShowParameter formShowParameter, String pageId) {
        formShowParameter.setPageId(pageId);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formView.showForm(formShowParameter);
    }

    public static FormShowParameter buildBillListShowParameter(String targetKey, String formId, ShowType showType, OperationStatus status) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(formId);
        listShowParameter.setFormId("bos_list");
        if (status != null) {
            listShowParameter.setStatus(status);
        }
        OpenStyle openStyle = listShowParameter.getOpenStyle();
        openStyle.setTargetKey(targetKey);
        openStyle.setShowType(showType != null ? showType : ShowType.MainNewTabPage);
        listShowParameter.setClientParam("requestBeforeClose", (Object)Boolean.TRUE);
        return listShowParameter;
    }

    public static FormShowParameter buildMobListShowParameter(String targetKey, String formId, ShowType showType, OperationStatus status) {
        MobileListShowParameter listShowParameter = new MobileListShowParameter();
        listShowParameter.setBillFormId(formId);
        listShowParameter.setFormId("bos_moblist");
        if (status != null) {
            listShowParameter.setStatus(status);
        }
        OpenStyle openStyle = listShowParameter.getOpenStyle();
        openStyle.setTargetKey(targetKey);
        openStyle.setShowType(showType != null ? showType : ShowType.MainNewTabPage);
        listShowParameter.setClientParam("requestBeforeClose", (Object)Boolean.TRUE);
        return listShowParameter;
    }

    public static FormShowParameter buildBaseFormShowParameter(String targetKey, String formId, ShowType showType, OperationStatus status) {
        BaseShowParameter formShowParameter = new BaseShowParameter();
        formShowParameter.setFormId(formId);
        if (status != null) {
            formShowParameter.setStatus(status);
        }
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setTargetKey(targetKey);
        openStyle.setShowType(showType != null ? showType : ShowType.MainNewTabPage);
        return formShowParameter;
    }

    public static FormShowParameter buildDynamicModel(String formId) {
        return ShowFormUtils.buildFormShowParameter("_submaintab_", formId, ShowType.Floating, null);
    }

    public static FormShowParameter buildBaseModel(String showType, String formId) {
        if (Objects.equals(showType, "0")) {
            return ShowFormUtils.buildBaseFormShowParameter("_submaintab_", formId, ShowType.MainNewTabPage, null);
        }
        if (Objects.equals(showType, "1")) {
            return ShowFormUtils.buildListShowParameter("_submaintab_", formId, ShowType.MainNewTabPage, null);
        }
        return null;
    }

    public static FormShowParameter buildBillModel(String showType, String formId) {
        if (Objects.equals(showType, "0")) {
            return ShowFormUtils.buildBillShowParameter("_submaintab_", formId, ShowType.MainNewTabPage, null);
        }
        if (Objects.equals(showType, "1")) {
            return ShowFormUtils.buildBillListShowParameter("_submaintab_", formId, ShowType.MainNewTabPage, null);
        }
        return null;
    }

    public static FormShowParameter buildBaseFormMobModel(String showType, String formId) {
        if (Objects.equals(showType, "0")) {
            formId = String.format("%s_mob", formId);
            return ShowFormUtils.buildMobileFormShowParameter(null, formId, ShowType.Floating, null);
        }
        if (Objects.equals(showType, "1")) {
            return ShowFormUtils.buildMobListShowParameter(null, formId, ShowType.Floating, null);
        }
        return null;
    }

    public static FormShowParameter buildQueryListFormModel(String formId) {
        return ShowFormUtils.buildListShowParameter("_submaintab_", formId, ShowType.Floating, null);
    }

    public static FormShowParameter buildBillFormModel(String showType, String formId) {
        if (Objects.equals(showType, "0")) {
            formId = String.format("%s_mob", formId);
            return ShowFormUtils.buildMobileBillShowParameter(null, formId, ShowType.Floating, null);
        }
        if (Objects.equals(showType, "1")) {
            return ShowFormUtils.buildMobListShowParameter(null, formId, ShowType.Floating, null);
        }
        return null;
    }

    public static FormShowParameter buildMobileBillFormModel(String showType, String formId) {
        if (Objects.equals(showType, "0")) {
            return ShowFormUtils.buildMobileBillShowParameter(null, formId, ShowType.Floating, null);
        }
        if (Objects.equals(showType, "1")) {
            return ShowFormUtils.buildMobListShowParameter(null, formId, ShowType.Floating, null);
        }
        return null;
    }

    public static FormShowParameter buildMobileFormModel(String formId) {
        return ShowFormUtils.buildMobileFormShowParameter(null, formId, ShowType.Floating, null);
    }
}

