/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.common.util;

import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.hr.hbp.business.util.OrgServiceUtil;
import kd.hr.hbp.common.util.HRStringUtils;

public class HRReportParamUtils {
    private static final Log LOGGER = LogFactory.getLog(HRReportParamUtils.class);
    public static final String ADMIN_ORG_SUMMARY_TYPE = "orgsummarytype";
    public static final String ORG_PERM_CONTROL = "orgpermcontrol";
    public static final String ADMIN_ORG_SUMMARY_TYPE_VAL10 = "10";
    public static final String ADMIN_ORG_SUMMARY_TYPE_VAL20 = "20";
    private static final String OPEN_EXTRACT = "openextract";
    private static final String CHART_QUERY_THRESHOLD = "chartquerythreshold";
    private static final String PIVOT_DIM_COUNT_THRESH = "pivotdimcountthresh";
    private static final int DEFAULT_CHART_QUERY_THRESHOLD = 2000;
    private static final int DEFAULT_PIVOT_DIM_COUNT_THRESHOLD = 500;

    public static String getAdminOrgSummaryTYpe() {
        Map<String, Object> systemParam = HRReportParamUtils.getConfigParams();
        String summaryType = ADMIN_ORG_SUMMARY_TYPE_VAL10;
        if (systemParam != null && !Objects.isNull(systemParam.get(ADMIN_ORG_SUMMARY_TYPE))) {
            summaryType = (String)systemParam.get(ADMIN_ORG_SUMMARY_TYPE);
        }
        LOGGER.info("RequestContext.get().getOrgId():{},{}", (Object)RequestContext.get().getOrgId(), (Object)summaryType);
        return summaryType;
    }

    public static boolean isOrgPermControl() {
        Map<String, Object> systemParam = HRReportParamUtils.getConfigParams();
        boolean permControl = false;
        if (systemParam != null && !Objects.isNull(systemParam.get(ORG_PERM_CONTROL))) {
            permControl = (Boolean)systemParam.get(ORG_PERM_CONTROL);
        }
        return permControl;
    }

    public static boolean isOpenExtract() {
        String tenantId = RequestContext.get().getTenantId();
        String enableExtract = SystemPropertyUtils.getProptyByTenant((String)"HR_REPORT_EXTRACT_ENABLE", (String)tenantId);
        LOGGER.info("HRReportParamUtils.isOpenExtract tenantId:{}, enableExtract:{}", (Object)tenantId, (Object)enableExtract);
        if (!HRStringUtils.equals((String)enableExtract, (String)"true")) {
            return false;
        }
        Map<String, Object> configParams = HRReportParamUtils.getConfigParams();
        Boolean openExtract = (Boolean)configParams.get(OPEN_EXTRACT);
        if (openExtract == null) {
            return false;
        }
        return openExtract;
    }

    public static int getChartQueryThreshold() {
        Map<String, Object> configParams = HRReportParamUtils.getConfigParams();
        Integer threshold = (Integer)configParams.get(CHART_QUERY_THRESHOLD);
        if (threshold == null) {
            return 2000;
        }
        return threshold;
    }

    private static Map<String, Object> getConfigParams() {
        long orgId = RequestContext.get().getOrgId() == 0L ? OrgServiceUtil.getHRRootOrgId() : RequestContext.get().getOrgId();
        AppParam appParam = new AppParam("2VKJ94YEM7AU", Long.valueOf(orgId));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
    }

    public static boolean enableHRReportExtract() {
        String tenantId = RequestContext.get().getTenantId();
        String enableExtract = SystemPropertyUtils.getProptyByTenant((String)"HR_REPORT_EXTRACT_ENABLE", (String)tenantId);
        return "true".equals(enableExtract);
    }

    public static int getPivotDimCountThresh() {
        Map<String, Object> configParams = HRReportParamUtils.getConfigParams();
        Integer threshold = (Integer)configParams.get(PIVOT_DIM_COUNT_THRESH);
        if (threshold == null) {
            return 500;
        }
        return threshold;
    }
}

