/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.common.util;

import com.google.common.collect.Maps;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.IAttachmentService;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.bos.web.DispatchServiceHelper;
import kd.bos.web.actions.utils.FilePathUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.common.constant.expimp.HREXPImpEnum;
import kd.hr.hrptmc.common.util.HRImpDuplicateData;
import org.apache.commons.io.FileUtils;
import org.xml.sax.SAXException;

public class ImportFileUtil {
    private static final Log logger = LogFactory.getLog(ImportFileUtil.class);

    public static String downloadTempFileForSource(String tempUrl) throws IOException {
        File tempFile = File.createTempFile(UUID.randomUUID().toString(), ".xlsx");
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        String[] queryParams = new URL(tempUrl).getQuery().split("&");
        HashMap downloadFileParams = Maps.newHashMapWithExpectedSize((int)queryParams.length);
        for (String queryParam : queryParams) {
            String[] p = queryParam.split("=");
            downloadFileParams.put(p[0], p[1]);
        }
        TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
        try (InputStream in = content.getInputStream();){
            FileUtils.copyInputStreamToFile((InputStream)in, (File)tempFile);
        }
        return tempFile.getPath();
    }

    public static String downloadFile(String servePath) throws IOException {
        FileService service = FileServiceFactory.getAttachmentFileService();
        File tempFile = File.createTempFile(UUID.randomUUID().toString(), ".xlsx");
        try (InputStream in = service.getInputStream(servePath);){
            FileUtils.copyInputStreamToFile((InputStream)in, (File)tempFile);
        }
        return tempFile.getPath();
    }

    public static Map<String, String> uploadFile(String fileName, String localPath) throws IOException {
        FileItem fileItem = null;
        InputStream inputStream = null;
        BufferedInputStream buffInputStream = null;
        try {
            File file = new File(ImportFileUtil.checkUrl(localPath));
            inputStream = new FileInputStream(file);
            buffInputStream = new BufferedInputStream(inputStream);
            fileItem = new FileItem(fileName, localPath, (InputStream)buffInputStream);
            String serverUrl = ImportFileUtil.getNewFilePath(fileItem.getFileName(), fileItem.getFileName());
            serverUrl = FilePathUtil.dealPath((String)serverUrl, (String)"attach");
            if (serverUrl.contains("+")) {
                serverUrl = serverUrl.replace('+', '_');
            }
            fileItem.setPath(serverUrl);
            FileService service = FileServiceFactory.getAttachmentFileService();
            String uploadId = service.upload(fileItem);
            String clientUrl = UrlService.getAttachmentFullUrl((String)uploadId);
            HashMap result = Maps.newHashMapWithExpectedSize((int)2);
            result.put("uploadId", uploadId);
            result.put("serverUrl", serverUrl);
            result.put("clientUrl", clientUrl);
            HashMap hashMap = result;
            return hashMap;
        }
        catch (Throwable e) {
            logger.error(e);
            throw e;
        }
        finally {
            if (fileItem != null) {
                fileItem.close();
            }
            if (buffInputStream != null) {
                buffInputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static String checkUrl(String url) {
        if (HRStringUtils.isEmpty((String)url)) {
            return "temp";
        }
        return url;
    }

    public static String downloadTempFile(String tempUrl) throws IOException {
        FileItem fileItem = null;
        BufferedInputStream buffInputStream = null;
        String serverUrl = null;
        InputStream inputStream = null;
        try {
            File tempFile = File.createTempFile(UUID.randomUUID().toString(), ".xlsx");
            TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
            String[] queryParams = new URL(tempUrl).getQuery().split("&");
            HashMap downloadFileParams = Maps.newHashMapWithExpectedSize((int)queryParams.length);
            for (String queryParam : queryParams) {
                String[] p = queryParam.split("=");
                downloadFileParams.put(p[0], p[1]);
            }
            TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
            FileService service = FileServiceFactory.getAttachmentFileService();
            try (InputStream in = content.getInputStream();){
                FileUtils.copyInputStreamToFile((InputStream)in, (File)tempFile);
            }
            inputStream = new FileInputStream(tempFile);
            buffInputStream = new BufferedInputStream(inputStream);
            fileItem = new FileItem(tempFile.getName(), tempFile.getPath(), (InputStream)buffInputStream);
            serverUrl = ImportFileUtil.getNewFilePath(fileItem.getFileName(), fileItem.getFileName());
            serverUrl = FilePathUtil.dealPath((String)serverUrl, (String)"attach");
            if (serverUrl.contains("+")) {
                serverUrl = serverUrl.replace('+', '_');
            }
            fileItem.setPath(serverUrl);
            service.upload(fileItem);
        }
        catch (Throwable e) {
            logger.error(e);
            throw e;
        }
        finally {
            if (fileItem != null) {
                fileItem.close();
            }
            if (buffInputStream != null) {
                buffInputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return serverUrl;
    }

    private static String getNewFilePath(String oldPath, String fileName) {
        String selfPath = oldPath;
        boolean encrptyPath = Boolean.parseBoolean(String.valueOf(DispatchServiceHelper.invokeBOSService((String)IAttachmentService.class.getSimpleName(), (String)"isEncrptyPath", (Object[])new Object[0])));
        if (oldPath == null || !oldPath.contains("/")) {
            selfPath = ImportFileUtil.generateAttPath(fileName);
        }
        return !encrptyPath ? selfPath : ImportFileUtil.generateAttPath(fileName);
    }

    private static String generateAttPath(String fileName) {
        String rootPath = System.getProperty("attachment.rootpath", "/");
        if (!rootPath.startsWith("/")) {
            rootPath = "/" + rootPath;
        }
        if (rootPath.endsWith("/")) {
            rootPath = rootPath.substring(0, rootPath.length() - 1);
        }
        String uuid = UUID.randomUUID().toString().replace("-", "");
        RequestContext rc = RequestContext.get();
        return rootPath + FileNameUtils.getAttachmentFileName((String)rc.getTenantCode(), (String)rc.getAccountId(), (Object)uuid, (String)fileName);
    }

    public static void parseTempFile(String tempUrl, String formId, List<HRImpDuplicateData> originNumberList) throws Exception {
        String entityName = HREXPImpEnum.getByNumber(formId).getName().loadKDString();
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        String[] queryParams = new URL(tempUrl).getQuery().split("&");
        HashMap downloadFileParams = Maps.newHashMapWithExpectedSize((int)queryParams.length);
        for (String queryParam : queryParams) {
            String[] p = queryParam.split("=");
            downloadFileParams.put(p[0], p[1]);
        }
        TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
        HashMap headStringMap = Maps.newHashMapWithExpectedSize((int)16);
        try (InputStream in = content.getInputStream();){
            ImportFileUtil.parseExcelNumber(in, entityName, originNumberList, headStringMap);
        }
    }

    public static void parseExcel(String url, String formId, List<HRImpDuplicateData> originNumberList) throws Exception {
        String entityName = HREXPImpEnum.getByNumber(formId).getName().loadKDString();
        FileService service = FileServiceFactory.getAttachmentFileService();
        HashMap headStringMap = Maps.newHashMapWithExpectedSize((int)16);
        try (InputStream in = service.getInputStream(url);){
            ImportFileUtil.parseExcelNumber(in, entityName, originNumberList, headStringMap);
        }
    }

    public static void parseExcelNumber(InputStream in, final String entityName, final List<HRImpDuplicateData> originNumberList, final Map<String, Integer> headStringMap) throws Exception {
        new ExcelReader().read(in, new SheetHandler(){

            public void handleRow(SheetHandler.ParsedRow row) {
                if (!entityName.equalsIgnoreCase(this.getSheetName())) {
                    return;
                }
                if (row.getRowNum() == 0) {
                    Map headMap = row.getData();
                    for (Map.Entry headEntry : headMap.entrySet()) {
                        if (!HRStringUtils.equalsIgnoreCase((String)((String)headEntry.getValue()), (String)"id") && !HRStringUtils.equalsIgnoreCase((String)((String)headEntry.getValue()), (String)"number") && !HRStringUtils.equalsIgnoreCase((String)((String)headEntry.getValue()), (String)"name.zh_CN")) continue;
                        headStringMap.put(headEntry.getValue(), headEntry.getKey());
                    }
                }
                if (row.getRowNum() > 1 && !row.isEmpty()) {
                    HRImpDuplicateData data = new HRImpDuplicateData();
                    String dataId = row.get((Integer)headStringMap.get("id"));
                    String dataNumber = row.get((Integer)headStringMap.get("number"));
                    String dataName = row.get((Integer)headStringMap.get("name.zh_CN"));
                    if (!(HRStringUtils.isNotEmpty((String)dataId) || HRStringUtils.isNotEmpty((String)dataNumber) || HRStringUtils.isNotEmpty((String)dataName))) {
                        return;
                    }
                    if (!HRStringUtils.isNotEmpty((String)dataId)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u5185\u7801\u4e3a\u7a7a\uff0c\u4e0d\u5f97\u5bfc\u5165", (String)"ImportFileUtil_1", (String)"hrmp-hrptmc-common", (Object[])new Object[0]));
                    }
                    data.setId(dataId);
                    if (HRStringUtils.isNotEmpty((String)dataNumber)) {
                        data.setNumber(dataNumber);
                    }
                    if (HRStringUtils.isNotEmpty((String)dataName)) {
                        data.setName(dataName);
                    }
                    originNumberList.add(data);
                }
            }

            public void endDocument() throws SAXException {
                super.endDocument();
                this.setInterrupt(false);
            }
        });
    }
}

