/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.common.util;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.SerializationUtils;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.labelandreport.EntityRelationCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinEntityCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.labelandreport.ComplexObjTransferUtil;
import kd.hr.hrptmc.common.constant.anobj.AnalyseObjectConstants;
import kd.hr.hrptmc.common.model.anobj.EntityRelationBo;
import kd.hr.hrptmc.common.model.anobj.JoinEntityBo;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;

public class ReportComplexObjTransferUtil
implements AnalyseObjectConstants {
    public static HRComplexObjContext transferToComplexObjContext(List<JoinEntityBo> joinEntities, List<QueryFieldBo> queryFields, List<EntityRelationBo> entityRelations, List<CalculateFieldBo> calculateFields, List<QFilter> qFilters) {
        List<JoinEntityCommonBo> joinEntityCommonBos = ReportComplexObjTransferUtil.transferJoinEntityBos(joinEntities);
        List<QueryFieldCommonBo> queryFieldCommonBos = ReportComplexObjTransferUtil.transferQueryFieldBos(queryFields);
        Map relationBoMap = entityRelations.stream().collect(Collectors.toMap(EntityRelationCommonBo::getJoinEntityAlias, Function.identity()));
        ArrayList sortedEntityRelations = Lists.newArrayListWithExpectedSize((int)10);
        for (JoinEntityBo joinEntity : joinEntities) {
            String longNumber = joinEntity.getLongNumber();
            if (HRStringUtils.equals((String)longNumber, (String)"0")) continue;
            EntityRelationBo entityRelationBo = (EntityRelationBo)((Object)relationBoMap.get(joinEntity.getEntityAlias()));
            sortedEntityRelations.add(entityRelationBo);
        }
        List<EntityRelationCommonBo> entityRelationCommonBos = ReportComplexObjTransferUtil.transferEntityRelationBos(sortedEntityRelations);
        HRComplexObjContext context = ComplexObjTransferUtil.transferToComplexObjContext(joinEntityCommonBos, queryFieldCommonBos, entityRelationCommonBos, qFilters);
        if (context == null) {
            return null;
        }
        calculateFields = calculateFields.stream().sorted(Comparator.comparingInt(CalculateFieldBo::getOrder)).collect(Collectors.toList());
        List complexObjFieldInfoList = context.getComplexObjFieldInfoList();
        for (CalculateFieldBo calField : calculateFields) {
            String type = HRStringUtils.equals((String)"simple", (String)calField.getType()) ? "2" : "3";
            HRComplexObjFieldInfo fieldInfo = new HRComplexObjFieldInfo(calField.getExpr(), type, calField.getFieldNumber());
            fieldInfo.setDataType(DataTypeEnum.of((String)calField.getValueType()));
            List<String> refEntityFields = calField.getRefEntityFields();
            List<CalculateFieldBo> refCalculateFields = calField.getRefCalculateFields();
            HashSet refFieldAliasSet = Sets.newHashSetWithExpectedSize((int)(refEntityFields.size() + refCalculateFields.size()));
            refFieldAliasSet.addAll(refEntityFields);
            refCalculateFields.forEach(field -> refFieldAliasSet.add(field.getFieldNumber()));
            fieldInfo.setRefFieldAliasSet((Set)refFieldAliasSet);
            complexObjFieldInfoList.add(fieldInfo);
        }
        return context;
    }

    public static List<JoinEntityCommonBo> transferJoinEntityBos(List<JoinEntityBo> joinEntityBos) {
        return JSON.parseArray((String)SerializationUtils.toJsonString(joinEntityBos), JoinEntityCommonBo.class);
    }

    public static List<QueryFieldCommonBo> transferQueryFieldBos(List<QueryFieldBo> queryFieldBos) {
        return JSON.parseArray((String)SerializationUtils.toJsonString(queryFieldBos), QueryFieldCommonBo.class);
    }

    public static List<EntityRelationCommonBo> transferEntityRelationBos(List<EntityRelationBo> entityRelationBos) {
        return JSON.parseArray((String)SerializationUtils.toJsonString(entityRelationBos), EntityRelationCommonBo.class);
    }

    public static List<EntityRelationBo> reverseEntityRelationBos(List<EntityRelationCommonBo> entityRelationBos) {
        return JSON.parseArray((String)SerializationUtils.toJsonString(entityRelationBos), EntityRelationBo.class);
    }
}

