/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.bizcorehr.business.preindex.service.hpfs;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.FlatMapFunction;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.MapFunction;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.algox.output.AlgoxOutputHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.preindex.IPresetIndexService;
import kd.hr.hrptmc.business.preindex.model.PresetIndexBusinessServiceParam;
import kd.hr.hrptmc.business.repcalculate.org.func.AdminOrgFlatMapFunction;
import kd.hr.hrptmc.business.repcalculate.org.func.AdminOrgLongNumberMapFunction;
import kd.hr.hrptmc.business.repcalculate.org.func.AdminOrgReduceFunction;
import kd.hr.hrptmc.business.repdesign.info.AdminOrgSummaryInfo;

public class PersonflowPresetIndexService
implements IPresetIndexService {
    private static final Log LOGGER = LogFactory.getLog(PersonflowPresetIndexService.class);
    private static final String ALGO_KEY = "PersonflowPresetIndexService_calculate";
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("hrpi_empposorgrel");
    private static final Map<String, String> LATITUDE_FIELD_MAP = new HashMap<String, String>(16);
    private static final Map<String, String> FILTER_FIELD_MAP = new HashMap<String, String>(16);
    private static final String COUNT_FIELD = "count\u03b1sum";
    private static final String ADMINORG_ID = "adminorg.id";
    private static final String QUERYDATE = "querydate";

    public List<Object> calculate(PresetIndexBusinessServiceParam params) {
        long startTime = System.currentTimeMillis();
        LOGGER.info("[repcalculate-ALGOX] PersonflowPersetIndexService calculate params.getRowList():{}", (Object)params.getRowList());
        LOGGER.info("[repcalculate-ALGOX] PersonflowPersetIndexService calculate params.getColumnList():{}", (Object)params.getColumnList());
        LOGGER.info("[repcalculate-ALGOX] PersonflowPersetIndexService calculate params.getDimMap():{}", (Object)params.getDimMap());
        LOGGER.info("[repcalculate-ALGOX] PersonflowPersetIndexService calculate params.getValueList():{}", (Object)(params.getValueList() != null ? params.getValueList().size() : 0));
        LOGGER.info("[repcalculate-ALGOX] PersonflowPersetIndexService calculate params.getParamList():{}", (Object)params.getParamList());
        Map dimMap = params.getDimMap();
        List valueList = params.getValueList();
        AdminOrgSummaryInfo adminOrgSummaryInfo = params.getAdminOrgSummaryInfo();
        ArrayList<Object> resultList = new ArrayList<Object>(Arrays.asList(new Integer[valueList.size()]));
        if (CollectionUtils.isEmpty((Map)dimMap)) {
            return resultList;
        }
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        ArrayList<String> selectFieldList = new ArrayList<String>();
        this.parseSelectField(params, indexList, selectFieldList);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        this.parseQFilter(params, qFilterList);
        if (selectFieldList.size() > 0) {
            String selectProperties = String.join((CharSequence)",", selectFieldList);
            DataSet dataSet = SERVICE_HELPER.queryDataSet(ALGO_KEY, selectProperties, qFilterList.toArray(new QFilter[0]));
            dataSet = dataSet.groupBy(selectFieldList.toArray(new String[0])).count(COUNT_FIELD).finish();
            if (this.checkNeedOrgGroup(adminOrgSummaryInfo)) {
                dataSet = this.adminOrgReduceGroup(adminOrgSummaryInfo, dataSet);
            }
            this.addResultList(valueList, resultList, indexList, selectFieldList, dataSet);
        }
        LOGGER.info("[repcalculate-ALGOX] PersonflowPersetIndexService doHandler end resultList.size():{},costTime:{}", (Object)resultList.size(), (Object)(System.currentTimeMillis() - startTime));
        return resultList;
    }

    private boolean checkNeedOrgGroup(AdminOrgSummaryInfo adminOrgSummaryInfo) {
        return adminOrgSummaryInfo != null && (adminOrgSummaryInfo.getTreeShow() || adminOrgSummaryInfo.getIncludeSubOrg());
    }

    private DataSet adminOrgReduceGroup(AdminOrgSummaryInfo adminOrgSummaryInfo, DataSet dataSet) {
        String algoXJobKey = "PersonflowPersetIndexService";
        LOGGER.info("[repcalculate-ALGOX] PersonflowPersetIndexService adminOrgReduceGroup algoXJobKey:{}", (Object)algoXJobKey);
        if (adminOrgSummaryInfo.getAdminOrgIdMap() != null && adminOrgSummaryInfo.getAdminLongNumberMap() != null) {
            long startTime = System.currentTimeMillis();
            AlgoxOutputHelper outputHelper = new AlgoxOutputHelper(algoXJobKey);
            DataSetX dataSetX = outputHelper.getSession().fromInput((Input)new DataSetInput(dataSet));
            DataSetX addLongStructNumberDataSetX = dataSetX.map((MapFunction)new AdminOrgLongNumberMapFunction(adminOrgSummaryInfo, dataSetX.getRowMeta()));
            RowMeta newRowMeta = addLongStructNumberDataSetX.getRowMeta();
            DataSetX newResultDataSetX = addLongStructNumberDataSetX.flatMap((FlatMapFunction)new AdminOrgFlatMapFunction(adminOrgSummaryInfo, newRowMeta)).groupBy(new String[]{"ROW_FIELD_ADMIN_ORG_LONG_NUMBER"}).reduceGroup((GroupReduceFunction)new AdminOrgReduceFunction(newRowMeta, Collections.emptySet())).orderBy(new String[]{"ROW_FIELD_ADMIN_ORG_LONG_NUMBER"});
            dataSet = outputHelper.dataSetOutput(newResultDataSetX);
            LOGGER.info("[repcalculate-ALGOX] PersonflowPersetIndexService adminOrgReduceGroup costTime:{}", (Object)(System.currentTimeMillis() - startTime));
        }
        return dataSet;
    }

    private void parseSelectField(PresetIndexBusinessServiceParam params, List<Integer> indexList, List<String> selectFieldList) {
        String row;
        String latitudeField;
        Map dimRelationMap;
        int i;
        List rowList = params.getRowList();
        List columnList = params.getColumnList();
        Map dimMap = params.getDimMap();
        AdminOrgSummaryInfo adminOrgSummaryInfo = params.getAdminOrgSummaryInfo();
        int currIndex = 0;
        if (!CollectionUtils.isEmpty((Collection)rowList)) {
            for (i = 0; i < rowList.size(); ++i) {
                String row2 = (String)rowList.get(i);
                dimRelationMap = (Map)dimMap.get(row2);
                if (CollectionUtils.isEmpty((Map)dimRelationMap) || !HRStringUtils.isNotEmpty((String)(latitudeField = LATITUDE_FIELD_MAP.get(dimRelationMap.get("preindexparam"))))) continue;
                selectFieldList.add(latitudeField);
                indexList.add(i);
            }
            if (adminOrgSummaryInfo != null) {
                String adminOrgSelectField = adminOrgSummaryInfo.getAdminOrgSelectField();
                for (int i2 = 0; i2 < rowList.size(); ++i2) {
                    row = (String)rowList.get(i2);
                    if (!HRStringUtils.equals((String)adminOrgSelectField, (String)row)) continue;
                    selectFieldList.add(ADMINORG_ID);
                    indexList.add(i2);
                }
            }
            currIndex = rowList.size();
        }
        if (!CollectionUtils.isEmpty((Collection)columnList)) {
            for (i = 0; i < columnList.size(); ++i) {
                String column = (String)columnList.get(i);
                dimRelationMap = (Map)dimMap.get(column);
                if (CollectionUtils.isEmpty((Map)dimRelationMap) || !HRStringUtils.isNotEmpty((String)(latitudeField = LATITUDE_FIELD_MAP.get(dimRelationMap.get("preindexparam"))))) continue;
                selectFieldList.add(latitudeField);
                indexList.add(currIndex + i);
            }
            if (adminOrgSummaryInfo != null) {
                String adminOrgSelectField = adminOrgSummaryInfo.getAdminOrgSelectField();
                for (int i3 = 0; i3 < rowList.size(); ++i3) {
                    row = (String)rowList.get(i3);
                    if (!HRStringUtils.equals((String)adminOrgSelectField, (String)row)) continue;
                    selectFieldList.add(ADMINORG_ID);
                    indexList.add(currIndex + i3);
                }
            }
        }
    }

    private void parseQFilter(PresetIndexBusinessServiceParam params, List<QFilter> qFilterList) {
        Set<Long> authorityOrgIds;
        List paramList = params.getParamList();
        Map dimMap = params.getDimMap();
        AdminOrgSummaryInfo adminOrgSummaryInfo = params.getAdminOrgSummaryInfo();
        qFilterList.add(new QFilter("isprimary", "=", (Object)"1"));
        qFilterList.add(new QFilter("businessstatus", "=", (Object)"1"));
        qFilterList.add(new QFilter("iscurrentversion", "=", (Object)"1"));
        qFilterList.add(new QFilter("datastatus", "=", (Object)"1"));
        if (!CollectionUtils.isEmpty((Collection)paramList)) {
            for (QFilter qFilter : paramList) {
                this.analyzeFilter(qFilterList, dimMap, qFilter);
                List nestList = qFilter.getNests(false);
                for (QFilter.QFilterNest nest : nestList) {
                    this.analyzeFilter(qFilterList, dimMap, nest.getFilter());
                }
            }
        } else {
            Date currDate = HRDateTimeUtils.getNowDate();
            qFilterList.add(new QFilter("startdate", "<=", (Object)currDate));
            qFilterList.add(new QFilter("enddate", ">=", (Object)currDate));
        }
        if (adminOrgSummaryInfo != null && !CollectionUtils.isEmpty((Map)adminOrgSummaryInfo.getAdminOrgIdMap()) && CollectionUtils.isEmpty((Collection)adminOrgSummaryInfo._getQueryOrgIds())) {
            qFilterList.add(new QFilter(ADMINORG_ID, "in", (Object)adminOrgSummaryInfo._getQueryOrgIds()));
        }
        if (!CollectionUtils.isEmpty(authorityOrgIds = this.getAuthorityOrgIds(adminOrgSummaryInfo))) {
            qFilterList.add(new QFilter(ADMINORG_ID, "in", authorityOrgIds));
        }
        LOGGER.info("[repcalculate-ALGOX] PersonflowPersetIndexService parseQFilter:{}", qFilterList);
    }

    private void analyzeFilter(List<QFilter> qFilterList, Map<String, Map<String, String>> dimMap, QFilter qFilter) {
        String property = qFilter.getProperty();
        Object value = qFilter.getValue();
        if (HRStringUtils.equals((String)QUERYDATE, (String)property)) {
            Date date = PersonflowPresetIndexService.getQueryDate((Date)value);
            qFilterList.add(new QFilter("startdate", "<=", (Object)date));
            qFilterList.add(new QFilter("enddate", ">=", (Object)date));
        } else {
            String filterField;
            Map<String, String> dimRelationMap = dimMap.get(property);
            if (!CollectionUtils.isEmpty(dimRelationMap) && HRStringUtils.isNotEmpty((String)(filterField = FILTER_FIELD_MAP.get(dimRelationMap.get("preindexparam"))))) {
                QFilter copyFilter = qFilter.copy();
                copyFilter.__setProperty(filterField);
                qFilterList.add(copyFilter);
            }
        }
    }

    public static Date getQueryDate(Date queryDate) {
        if (queryDate == null) {
            queryDate = new Date();
        }
        try {
            queryDate = HRDateTimeUtils.parseDate((String)HRDateTimeUtils.format((Date)queryDate), (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", "PersonflowPresetIndexService queryDate format error."), new Object[0]);
        }
        return queryDate;
    }

    private Set<Long> getAuthorityOrgIds(AdminOrgSummaryInfo adminOrgSummaryInfo) {
        if (adminOrgSummaryInfo == null || CollectionUtils.isEmpty((Collection)adminOrgSummaryInfo.getAuthorityOrgIds())) {
            return new HashSet<Long>();
        }
        return adminOrgSummaryInfo.getAuthorityOrgIds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResultList(List<Object[]> valueList, ArrayList<Object> resultList, List<Integer> indexList, List<String> selectFieldList, DataSet dataSet) {
        List valueIndexList;
        HashMap<String, List> valueListMap = new HashMap<String, List>(valueList.size());
        for (int i = 0; i < valueList.size(); ++i) {
            Object[] valueArr = valueList.get(i);
            String compareValue = indexList.stream().map(valueListIndex -> String.valueOf(valueArr[valueListIndex])).collect(Collectors.joining("_"));
            valueIndexList = valueListMap.getOrDefault(compareValue, new ArrayList());
            valueIndexList.add(i);
            valueListMap.put(compareValue, valueIndexList);
        }
        LOGGER.info("[repcalculate-ALGOX] PersonflowPersetIndexService addResultList valueListMap.keySet():{}", valueListMap.keySet());
        try {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Object count = row.get(COUNT_FIELD);
                String latitudeFieldValue = selectFieldList.stream().map(arg_0 -> ((Row)row).getString(arg_0)).collect(Collectors.joining("_"));
                valueIndexList = (List)valueListMap.get(latitudeFieldValue);
                if (CollectionUtils.isEmpty((Collection)valueIndexList)) continue;
                for (Integer index : valueIndexList) {
                    resultList.set(index, count);
                }
            }
        }
        finally {
            dataSet.close();
        }
    }

    static {
        LATITUDE_FIELD_MAP.put("adminorg", "adminorg.name");
        FILTER_FIELD_MAP.put("adminorg", ADMINORG_ID);
        FILTER_FIELD_MAP.put(QUERYDATE, QUERYDATE);
        FILTER_FIELD_MAP.put("postype", "postype");
        FILTER_FIELD_MAP.put("laborreltype", "employee.laborreltype");
        FILTER_FIELD_MAP.put("issuborg", "issuborg");
    }
}

