/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.anobj;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hrptmc.business.anobj.AnObjDataStoreTaskService;
import kd.hr.hrptmc.business.datastore.DataStoreLogService;
import kd.hr.hrptmc.common.constant.dataextract.AnObjExtractConstants;

public class AnObjDataExtractTask
extends AbstractTask
implements AnObjExtractConstants {
    private static final Log LOGGER = LogFactory.getLog(AnObjDataExtractTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String anObjIdStr = (String)map.get("anObjId");
        if (anObjIdStr == null) {
            LOGGER.error("AnObjDataExtractTask execute error: anObjId param is null!");
            return;
        }
        long anObjId = Long.parseLong(anObjIdStr);
        LOGGER.info("AnObjDataExtractTask_execute,anObjId:{}", (Object)anObjId);
        AnObjDataStoreTaskService anObjDataStoreService = new AnObjDataStoreTaskService(anObjId);
        try {
            if (anObjDataStoreService.beforeExecute()) {
                anObjDataStoreService.execute();
            }
        }
        catch (Exception e) {
            DataStoreLogService dataStoreLogService = new DataStoreLogService(anObjId, false);
            dataStoreLogService.error(e.toString());
            throw new KDBizException(e.getMessage());
        }
    }
}

