/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.anobj;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.service.labelandreport.SelectEntityFieldUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.SelectFieldTreeNode;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnObjGroupFieldService;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.calfield.CalculateFieldService;
import kd.hr.hrptmc.common.constant.anobj.AnalyseObjectConstants;

public class AnObjDataMonitorService
implements AnalyseObjectConstants {
    private final Set<String> notExistEntityNumSet = Sets.newHashSetWithExpectedSize((int)16);
    private final Set<String> notExistFieldAliasSet = Sets.newHashSetWithExpectedSize((int)16);

    public boolean checkAnObj(long anObjId, boolean repair, StringBuilder errorMsg) {
        HRBaseServiceHelper analyseObjectHelper = new HRBaseServiceHelper("hrptmc_analyseobject");
        DynamicObject anObjDy = analyseObjectHelper.loadSingle((Object)anObjId);
        if (AnalyseObjectService.getInstance().isVirtualEntityAnObj(anObjDy.getString("objecttype"))) {
            errorMsg.append(ResManager.loadKDString((String)"\u865a\u5b9e\u4f53\u6682\u4e0d\u652f\u6301\u6570\u636e\u76d1\u6d4b\u3002", (String)"AnObjDataMonitorService_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
            return false;
        }
        DynamicObject[] joinEntities = AnalyseObjectService.getInstance().loadJoinEntities(anObjId);
        ArrayList notExistEntityList = Lists.newArrayListWithCapacity((int)10);
        this.handleJoinEntity(joinEntities, notExistEntityList, errorMsg, repair);
        DynamicObject[] relationDys = AnalyseObjectService.getInstance().loadEntityRelations(anObjId);
        ArrayList notExistRelationList = Lists.newArrayListWithCapacity((int)10);
        DynamicObject[] queryFields = AnalyseObjectService.getInstance().loadQueryFields(anObjId);
        ArrayList notExistFieldList = Lists.newArrayListWithCapacity((int)10);
        this.handleJoinRelationAndFields(notExistEntityList, relationDys, notExistRelationList, queryFields, notExistFieldList, repair);
        this.handleJoinRelation(relationDys, errorMsg, repair);
        this.handleFields(joinEntities, queryFields, notExistFieldList, errorMsg, repair);
        DynamicObject[] calculateFields = CalculateFieldService.getInstance().loadCalFieldsByAnObjId(anObjId);
        ArrayList notExistCalculateFields = Lists.newArrayListWithCapacity((int)10);
        this.handleCalculateFields(calculateFields, notExistCalculateFields, errorMsg, repair);
        this.handleDataFilter(anObjDy, notExistFieldList, notExistCalculateFields, errorMsg, repair);
        this.handleAnObjPivot(anObjDy, queryFields, errorMsg, repair);
        this.handleGroupFields(anObjDy, errorMsg, repair);
        return errorMsg.length() == 0;
    }

    private void handleJoinEntity(DynamicObject[] joinEntities, List<DynamicObject> notExistEntityList, StringBuilder tips, boolean repair) {
        StringBuilder entitySb = new StringBuilder();
        ArrayList notExistJoinEntityId = Lists.newArrayListWithCapacity((int)10);
        for (DynamicObject joinEntity : joinEntities) {
            String entityNumber = joinEntity.getString("entitynumber");
            try {
                EntityMetadataCache.getDataEntityType((String)entityNumber);
            }
            catch (Exception ex) {
                notExistEntityList.add(joinEntity);
                this.notExistEntityNumSet.add(entityNumber);
                entitySb.append(entityNumber).append(",");
                notExistJoinEntityId.add(joinEntity.getLong("id"));
            }
        }
        if (entitySb.length() > 0) {
            tips.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5206\u6790\u5bf9\u8c61\u4e2d\u5f15\u7528\u7684%s\u5b9e\u4f53\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"AnObjDataMonitorService_3", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), entitySb.substring(0, entitySb.length() - 1)));
            tips.append("\r\n");
        }
        if (repair && notExistJoinEntityId.size() > 0) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_anobjjoinentity");
            helper.deleteByFilter(new QFilter[]{new QFilter("id", "in", (Object)notExistJoinEntityId)});
        }
    }

    private void handleJoinRelationAndFields(List<DynamicObject> notExistEntityList, DynamicObject[] relationDys, List<DynamicObject> notExistRelationList, DynamicObject[] queryFields, List<DynamicObject> notExistFieldList, boolean repair) {
        for (DynamicObject joinEntity : notExistEntityList) {
            String entityType = joinEntity.getString("type");
            if (HRStringUtils.equals((String)entityType, (String)"main")) {
                throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5206\u6790\u5bf9\u8c61\u4e3b\u5b9e\u4f53%s\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u5220\u9664\u5206\u6790\u5bf9\u8c61\u540e\u91cd\u65b0\u914d\u7f6e\u3002", (String)"AnObjDataMonitorService_4", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), joinEntity.getString("entitynumber")));
            }
            long joinEntityId = joinEntity.getLong("id");
            String entityNumber = joinEntity.getString("entitynumber");
            Arrays.stream(relationDys).filter(dy -> dy.getDynamicObject("entityid").getLong("id") == joinEntityId).findAny().ifPresent(notExistRelationList::add);
            Arrays.stream(queryFields).filter(dy -> HRStringUtils.equals((String)dy.getString("entitynumber"), (String)entityNumber)).findAny().ifPresent(dy -> {
                notExistFieldList.add((DynamicObject)dy);
                String fieldAlias = dy.getString("fieldalias");
                this.notExistFieldAliasSet.add(fieldAlias);
            });
        }
        if (repair && notExistRelationList.size() > 0) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_anobjentityrel");
            List ids = notExistRelationList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
            helper.deleteByFilter(new QFilter[]{new QFilter("id", "in", ids)});
        }
    }

    private void handleJoinRelation(DynamicObject[] relationDys, StringBuilder tips, boolean repair) {
        StringBuilder notExistFieldName = new StringBuilder();
        for (DynamicObject joinDy : relationDys) {
            DynamicObject entityDy = joinDy.getDynamicObject("entityid");
            DynamicObject joinEntityDy = joinDy.getDynamicObject("joinentityid");
            if (entityDy == null || joinEntityDy == null || this.notExistEntityNumSet.contains(entityDy.getString("entitynumber")) || this.notExistEntityNumSet.contains(joinEntityDy.getString("entitynumber"))) continue;
            String entityNum = entityDy.getString("entitynumber");
            String joinEntityNum = joinEntityDy.getString("entitynumber");
            SelectFieldTreeNode entityFieldNode = SelectEntityFieldUtil.getEntityFields((String)entityNum, (String)entityDy.getString("entityalias"), (boolean)HRStringUtils.equals((String)entityDy.getString("type"), (String)"main"));
            SelectFieldTreeNode joinEntityFieldNode = SelectEntityFieldUtil.getEntityFields((String)joinEntityNum, (String)joinEntityDy.getString("entityalias"), (boolean)HRStringUtils.equals((String)joinEntityDy.getString("type"), (String)"main"));
            for (DynamicObject relationDy : relationDys) {
                DynamicObjectCollection conditionCol = relationDy.getDynamicObjectCollection("joinconditions");
                Iterator iterator = conditionCol.iterator();
                while (iterator.hasNext()) {
                    DynamicObject conditionDy = (DynamicObject)iterator.next();
                    String leftPropFieldAlias = conditionDy.getString("leftprop");
                    ArrayList result = Lists.newArrayListWithExpectedSize((int)1);
                    SelectEntityFieldUtil.findNode((String)leftPropFieldAlias, (SelectFieldTreeNode)entityFieldNode, (List)result);
                    if (result.isEmpty()) {
                        notExistFieldName.append(leftPropFieldAlias).append("\uff0c");
                        iterator.remove();
                        continue;
                    }
                    result.clear();
                    String rightPropType = conditionDy.getString("rightproptype");
                    if (!HRStringUtils.equals((String)rightPropType, (String)"field")) continue;
                    String rightPropFieldAlias = conditionDy.getString("rightprop");
                    SelectEntityFieldUtil.findNode((String)rightPropFieldAlias, (SelectFieldTreeNode)joinEntityFieldNode, (List)result);
                    if (!result.isEmpty()) continue;
                    notExistFieldName.append(rightPropFieldAlias).append("\uff0c");
                    iterator.remove();
                }
            }
        }
        if (notExistFieldName.length() > 0) {
            tips.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5206\u6790\u5bf9\u8c61\u5b9e\u4f53\u5173\u8054\u6761\u4ef6\u4e2d\u5f15\u7528\u7684\u5b57\u6bb5%s\u4e0d\u5b58\u5728\u3002", (String)"AnObjDataMonitorService_15", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), notExistFieldName.substring(0, notExistFieldName.length() - 1)));
            tips.append("\r\n");
            if (repair) {
                HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_anobjentityrel");
                helper.save(relationDys);
            }
        }
    }

    private void handleFields(DynamicObject[] joinEntities, DynamicObject[] queryFields, List<DynamicObject> notExistFieldList, StringBuilder tips, boolean repair) {
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        StringBuilder notExistFieldName = new StringBuilder();
        for (DynamicObject joinEntity : joinEntities) {
            String entityNum = joinEntity.getString("entitynumber");
            if (this.notExistEntityNumSet.contains(entityNum)) continue;
            MainEntityType mainEntityType = mainEntityTypeUtil.getMainEntityType(entityNum);
            Arrays.stream(queryFields).filter(dy -> HRStringUtils.equals((String)dy.getString("entitynumber"), (String)entityNum)).forEach(dy -> {
                boolean isExist = this.parseFieldPathFindProperty(mainEntityType, dy.getString("fieldpath"), dy.getString("complextype"));
                if (!isExist) {
                    notExistFieldList.add((DynamicObject)dy);
                    String name = dy.getLocaleString("fieldname").getLocaleValue();
                    String fieldAlias = dy.getString("fieldalias");
                    this.notExistFieldAliasSet.add(fieldAlias);
                    notExistFieldName.append(name).append("(").append(fieldAlias).append(")").append("\uff0c");
                }
            });
        }
        if (notExistFieldName.length() > 0) {
            tips.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5206\u6790\u5bf9\u8c61\u4e2d\u5f15\u7528\u7684\u5b57\u6bb5%s\u4e0d\u5b58\u5728\u3002", (String)"AnObjDataMonitorService_5", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), notExistFieldName.substring(0, notExistFieldName.length() - 1)));
            tips.append("\r\n");
            if (repair) {
                HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_anobjqueryfield");
                List ids = notExistFieldList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
                helper.deleteByFilter(new QFilter[]{new QFilter("id", "in", ids)});
            }
        }
    }

    private void handleCalculateFields(DynamicObject[] calculateFields, List<DynamicObject> notExistCalculateFields, StringBuilder tips, boolean repair) {
        List calculateFieldList = Arrays.stream(calculateFields).sorted(Comparator.comparing(field -> field.getInt("index"))).collect(Collectors.toList());
        StringBuilder notExistCalFieldSb = new StringBuilder();
        block0: for (DynamicObject calculateField : calculateFieldList) {
            String calculateName = calculateField.getLocaleString("name").getLocaleValue();
            String calculateNumber = calculateField.getString("number");
            DynamicObjectCollection refFieldEntry = calculateField.getDynamicObjectCollection("reffieldentry");
            for (DynamicObject refFieldDy : refFieldEntry) {
                String refType = refFieldDy.getString("reftype");
                String refNum = "";
                if (HRStringUtils.equals((String)refType, (String)"entityfield")) {
                    refNum = refFieldDy.getString("reffieldalias");
                } else if (HRStringUtils.equals((String)refType, (String)"calfield")) {
                    refNum = refFieldDy.getDynamicObject("refcalfield").getString("number");
                }
                if (!this.notExistFieldAliasSet.contains(refNum)) continue;
                notExistCalculateFields.add(calculateField);
                this.notExistFieldAliasSet.add(calculateNumber);
                notExistCalFieldSb.append(calculateName).append("(").append(calculateNumber).append(")").append("\uff0c");
                continue block0;
            }
        }
        if (notExistCalFieldSb.length() > 0) {
            tips.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5206\u6790\u5bf9\u8c61\u4e2d\u7684\u8ba1\u7b97\u5b57\u6bb5%s\u6570\u636e\u5f02\u5e38\u3002", (String)"AnObjDataMonitorService_6", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), notExistCalFieldSb.substring(0, notExistCalFieldSb.length() - 1)));
            tips.append("\r\n");
            if (repair) {
                HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_calculatefield");
                List ids = notExistCalculateFields.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
                helper.deleteByFilter(new QFilter[]{new QFilter("id", "in", ids)});
            }
        }
    }

    private void handleDataFilter(DynamicObject anObjDy, List<DynamicObject> notExistFieldList, List<DynamicObject> notExistCalculateFields, StringBuilder tips, boolean repair) {
        String dataFilter = anObjDy.getString("datafilter");
        if (HRStringUtils.isEmpty((String)dataFilter)) {
            return;
        }
        Set notExistFieldAlias = notExistFieldList.stream().map(field -> field.getString("fieldalias")).collect(Collectors.toSet());
        notExistFieldAlias.addAll(notExistCalculateFields.stream().map(field -> field.getString("number")).collect(Collectors.toSet()));
        RuleConditionInfo conditionInfo = (RuleConditionInfo)SerializationUtils.fromJsonString((String)dataFilter, RuleConditionInfo.class);
        List paramList = conditionInfo.getConditionList().stream().map(ConditionInfo::getParam).collect(Collectors.toList());
        List notExistFields = paramList.stream().filter(notExistFieldAlias::contains).collect(Collectors.toList());
        if (notExistFields.size() > 0) {
            tips.append(String.format(ResManager.loadKDString((String)"\u5206\u6790\u5bf9\u8c61\u6570\u636e\u8fc7\u6ee4\u4e2d\u5f15\u7528\u7684\u5b57\u6bb5%s\u4e0d\u5b58\u5728\u3002", (String)"AnObjDataMonitorService_7", (String)"hrmp-hrptmc-business", (Object[])new Object[]{String.join((CharSequence)",", notExistFields)}), new Object[0]));
            tips.append("\r\n");
            if (repair) {
                anObjDy.set("datafilter", null);
                HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_analyseobject");
                helper.saveOne(anObjDy);
            }
        }
    }

    private void handleAnObjPivot(DynamicObject anObjDy, DynamicObject[] queryFields, StringBuilder tips, boolean repair) {
        String pivotDim;
        List notExistIds;
        DynamicObject[] anObjPivotDys = AnalyseObjectService.getInstance().queryAnObjPivotDys(anObjDy.getLong("id"));
        if (anObjPivotDys == null || anObjPivotDys.length == 0) {
            return;
        }
        String dimField = anObjPivotDys[0].getString("pivotdim");
        Map queryFieldMap = Arrays.stream(queryFields).collect(Collectors.toMap(field -> field.getString("fieldalias"), Function.identity()));
        boolean needSaveAnObj = false;
        if (HRStringUtils.isNotEmpty((String)dimField) && this.notExistFieldAliasSet.contains(dimField)) {
            DynamicObject notExistFieldDy = (DynamicObject)queryFieldMap.get(dimField);
            String fieldName = notExistFieldDy.getLocaleString("fieldname").getLocaleValue() + "(" + notExistFieldDy.getString("fieldalias") + ")";
            tips.append(String.format(ResManager.loadKDString((String)"\u5206\u6790\u5bf9\u8c61\u884c\u5217\u8f6c\u7f6e\u4e2d\u5f15\u7528\u7684\u7ef4\u5ea6\u5b57\u6bb5%s\u4e0d\u5b58\u5728\u3002", (String)"AnObjDataMonitorService_8", (String)"hrmp-hrptmc-business", (Object[])new Object[]{fieldName}), new Object[0]));
            tips.append("\r\n");
            if (repair) {
                Arrays.stream(anObjPivotDys).forEach(pivotDy -> {
                    pivotDy.set("pivotdim", null);
                    pivotDy.set("pivotdimval", null);
                    pivotDy.set("pivotindexnum", null);
                });
                needSaveAnObj = true;
            }
        }
        List dimValues = Arrays.stream(anObjPivotDys).filter(pivotDy -> HRStringUtils.isNotEmpty((String)pivotDy.getString("pivotdimval"))).map(pivotDy -> pivotDy.getString("pivotdimval")).distinct().collect(Collectors.toList());
        DynamicObject fieldDy = (DynamicObject)queryFieldMap.get(dimField);
        IDataEntityProperty fieldProperty = AnalyseObjectService.getInstance().getFieldProperty(fieldDy.getString("entitynumber"), fieldDy.getString("fieldalias"), fieldDy.getString("complextype"));
        if (AnalyseObjectUtil.isEnumType((String)fieldDy.getString("controltype"))) {
            List comboItems = ((ComboProp)fieldProperty).getComboItems();
            Set itemSet = comboItems.stream().map(ValueMapItem::getValue).collect(Collectors.toSet());
            notExistIds = dimValues.stream().filter(id -> !itemSet.contains(id)).map(Object::toString).collect(Collectors.toList());
        } else {
            BasedataEntityType parent = (BasedataEntityType)fieldProperty.getParent();
            String fieldBaseDataNum = parent.getName();
            HRBaseServiceHelper helper = new HRBaseServiceHelper(fieldBaseDataNum);
            DynamicObject[] primaryKey = EntityMetadataCache.getDataEntityType((String)fieldBaseDataNum).getPrimaryKey();
            boolean isLongTypeId = primaryKey.getPropertyType() == Long.TYPE || primaryKey.getPropertyType() == Long.class;
            List ids = dimValues.stream().map(id -> {
                if (isLongTypeId) {
                    return Long.valueOf(id);
                }
                return id;
            }).collect(Collectors.toList());
            DynamicObjectCollection dyCol = helper.queryOriginalCollection("id", new QFilter[]{new QFilter("id", "in", ids)});
            Set existIds = dyCol.stream().map(dy -> dy.get("id")).collect(Collectors.toSet());
            notExistIds = ids.stream().filter(id -> !existIds.contains(id)).map(Object::toString).collect(Collectors.toList());
        }
        if (notExistIds.size() > 0) {
            tips.append(String.format(ResManager.loadKDString((String)"\u5206\u6790\u5bf9\u8c61\u884c\u5217\u8f6c\u7f6e\u4e2d\u5f15\u7528\u7684\u7ef4\u5ea6\u503c%s\u4e0d\u5b58\u5728\u3002", (String)"AnObjDataMonitorService_9", (String)"hrmp-hrptmc-business", (Object[])new Object[]{String.join((CharSequence)",", notExistIds)}), new Object[0]));
            tips.append("\r\n");
            if (repair) {
                List<DynamicObject> anObjPivotDyList = Arrays.stream(anObjPivotDys).collect(Collectors.toList());
                anObjPivotDyList.removeIf(pivotDy -> notExistIds.contains(pivotDy.getString("pivotdimval")));
                anObjPivotDys = anObjPivotDyList.toArray(new DynamicObject[0]);
                needSaveAnObj = true;
            }
        }
        List indexes = Arrays.stream(anObjPivotDys).filter(pivotDy -> HRStringUtils.isNotEmpty((String)pivotDy.getString("pivotindex"))).map(pivotDy -> pivotDy.getString("pivotdimval")).distinct().collect(Collectors.toList());
        List notExistIndexes = indexes.stream().filter(this.notExistFieldAliasSet::contains).collect(Collectors.toList());
        if (notExistIndexes.size() > 0) {
            tips.append(String.format(ResManager.loadKDString((String)"\u5206\u6790\u5bf9\u8c61\u884c\u5217\u8f6c\u7f6e\u4e2d\u5f15\u7528\u7684\u6307\u6807%s\u4e0d\u5b58\u5728\u3002", (String)"AnObjDataMonitorService_10", (String)"hrmp-hrptmc-business", (Object[])new Object[]{String.join((CharSequence)",", notExistIndexes)}), new Object[0]));
            tips.append("\r\n");
            if (repair) {
                Arrays.stream(anObjPivotDys).forEach(pivotDy -> {
                    pivotDy.set("pivotindex", null);
                    pivotDy.set("pivotindexnum", null);
                });
                needSaveAnObj = true;
            }
        }
        if (HRStringUtils.isNotEmpty((String)(pivotDim = anObjPivotDys[0].getString("pivotdim")))) {
            for (DynamicObject anObjPivotDy : anObjPivotDys) {
                String pivotIndex = anObjPivotDy.getString("pivotindex");
                String pivotDimVal = anObjPivotDy.getString("pivotdimval");
                if (HRStringUtils.isEmpty((String)pivotIndex) || HRStringUtils.isEmpty((String)pivotDimVal)) continue;
                String newIndexNum = anObjPivotDy.getString("pivotindexnum");
                if (!this.notExistFieldAliasSet.contains(pivotDim) && !notExistIds.contains(pivotDimVal) && !this.notExistFieldAliasSet.contains(pivotIndex)) continue;
                this.notExistFieldAliasSet.add(newIndexNum);
            }
        }
        if (needSaveAnObj) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_analyseobject");
            helper.saveOne(anObjDy);
        }
    }

    private void handleGroupFields(DynamicObject anObjDy, StringBuilder tips, boolean repair) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_anobjgroupfield");
        DynamicObject[] groupFields = helper.loadDynamicObjectArray(new QFilter[]{new QFilter("anobj", "=", (Object)anObjDy.getLong("id"))});
        if (groupFields.length == 0) {
            return;
        }
        ArrayList removeGroupFieldIds = Lists.newArrayListWithCapacity((int)10);
        for (DynamicObject groupField : groupFields) {
            DynamicObject anObjFieldDy = groupField.getDynamicObject("anobjfield");
            String fieldName = groupField.getLocaleString("name").getLocaleValue() + "(" + groupField.getString("number") + ")";
            if (anObjFieldDy == null) {
                this.notExistFieldAliasSet.add(groupField.getString("number"));
                tips.append(String.format(ResManager.loadKDString((String)"\u5206\u6790\u5bf9\u8c61\u5206\u7ec4\u8d4b\u503c\u5b57\u6bb5%s\u5f15\u7528\u7684\u7ef4\u5ea6\u5b57\u6bb5\u4e0d\u5b58\u5728\u3002", (String)"AnObjDataMonitorService_14", (String)"hrmp-hrptmc-business", (Object[])new Object[]{fieldName}), new Object[0]));
                tips.append("\r\n");
                removeGroupFieldIds.add(groupField.getLong("id"));
                continue;
            }
            String fieldAlias = anObjFieldDy.getString("fieldalias");
            if (this.notExistFieldAliasSet.contains(fieldAlias)) {
                this.notExistFieldAliasSet.add(groupField.getString("number"));
                tips.append(String.format(ResManager.loadKDString((String)"\u5206\u6790\u5bf9\u8c61\u5206\u7ec4\u8d4b\u503c\u5b57\u6bb5%1$s\u5f15\u7528\u7684\u7ef4\u5ea6\u5b57\u6bb5%2$s\u4e0d\u5b58\u5728\u3002", (String)"AnObjDataMonitorService_11", (String)"hrmp-hrptmc-business", (Object[])new Object[]{fieldName, fieldAlias}), new Object[0]));
                tips.append("\r\n");
                removeGroupFieldIds.add(groupField.getLong("id"));
                continue;
            }
            String dependQueryFieldTyp = AnObjGroupFieldService.getInstance().getDependQueryFieldTyp(fieldAlias, anObjFieldDy.getString("valuetype"), anObjFieldDy.getString("complextype"), anObjFieldDy.getString("controltype"));
            IDataEntityProperty fieldProperty = AnalyseObjectService.getInstance().getFieldProperty(anObjFieldDy.getString("entitynumber"), anObjFieldDy.getString("fieldalias"), anObjFieldDy.getString("complextype"));
            if (HRStringUtils.equals((String)dependQueryFieldTyp, (String)"baseData")) {
                this.handleBaseDataGroupField(fieldProperty, groupField, fieldName, tips);
                continue;
            }
            if (!HRStringUtils.equals((String)dependQueryFieldTyp, (String)"enum")) continue;
            this.handleEnumGroupField(fieldProperty, groupField, fieldName, tips);
        }
        if (repair) {
            this.repairGroupFields(groupFields, removeGroupFieldIds, anObjDy.getLong("id"));
        }
    }

    private void handleEnumGroupField(IDataEntityProperty fieldProperty, DynamicObject groupField, String fieldName, StringBuilder tips) {
        List comboItems = ((ComboProp)fieldProperty).getComboItems();
        Set existEnumItems = comboItems.stream().map(ValueMapItem::getValue).collect(Collectors.toSet());
        DynamicObjectCollection groupEntry = groupField.getDynamicObjectCollection("group");
        Iterator iterator = groupEntry.iterator();
        ArrayList notExistRefIds = Lists.newArrayListWithCapacity((int)10);
        while (iterator.hasNext()) {
            DynamicObject groupItemDy = (DynamicObject)iterator.next();
            String itemCondition = groupItemDy.getString("itemcondition");
            if (HRStringUtils.isEmpty((String)itemCondition)) continue;
            List refEnumItems = (List)SerializationUtils.fromJsonString((String)itemCondition, List.class);
            refEnumItems.removeIf(item -> {
                if (!existEnumItems.contains(item)) {
                    notExistRefIds.add(item);
                    return true;
                }
                return false;
            });
            if (notExistRefIds.size() <= 0) continue;
            if (refEnumItems.isEmpty()) {
                iterator.remove();
                continue;
            }
            groupItemDy.set("itemcondition", (Object)SerializationUtils.toJsonString((Object)refEnumItems));
        }
        if (notExistRefIds.size() > 0) {
            tips.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5206\u7ec4\u8d4b\u503c\u5b57\u6bb5%s\u5f15\u7528\u7684\u679a\u4e3e\u503c\u4e0d\u5b58\u5728\u3002", (String)"AnObjDataMonitorService_13", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), fieldName));
            tips.append("\r\n");
        }
    }

    private void handleBaseDataGroupField(IDataEntityProperty fieldProperty, DynamicObject groupField, String fieldName, StringBuilder tips) {
        DynamicObjectCollection existIds;
        HRBaseServiceHelper baseDataHelper = new HRBaseServiceHelper(((BasedataProp)fieldProperty).getBaseEntityId());
        boolean isStringTypeId = ((BasedataProp)fieldProperty).getRefIdProp().getPropertyType() == String.class;
        List refBaseDataIds = Lists.newArrayListWithCapacity((int)10);
        DynamicObjectCollection groupEntry = groupField.getDynamicObjectCollection("group");
        for (DynamicObject groupItemDy : groupEntry) {
            String itemCondition = groupItemDy.getString("itemcondition");
            if (HRStringUtils.isEmpty((String)itemCondition)) continue;
            refBaseDataIds = (List)SerializationUtils.fromJsonString((String)itemCondition, List.class);
        }
        if (!isStringTypeId) {
            List ids = refBaseDataIds.stream().map(Long::valueOf).collect(Collectors.toList());
            existIds = baseDataHelper.queryOriginalCollection("id", new QFilter[]{new QFilter("id", "in", ids)});
        } else {
            existIds = baseDataHelper.queryOriginalCollection("id", new QFilter[]{new QFilter("id", "in", (Object)refBaseDataIds)});
        }
        List existStrIds = existIds.stream().map(dy -> dy.getString("id")).collect(Collectors.toList());
        Iterator iterator = groupEntry.iterator();
        ArrayList notExistRefIds = Lists.newArrayListWithCapacity((int)10);
        while (iterator.hasNext()) {
            DynamicObject next = (DynamicObject)iterator.next();
            String itemCondition = next.getString("itemcondition");
            if (HRStringUtils.isEmpty((String)itemCondition)) continue;
            List baseDataList = (List)SerializationUtils.fromJsonString((String)itemCondition, List.class);
            baseDataList.removeIf(baseData -> {
                if (!existStrIds.contains(baseData)) {
                    notExistRefIds.add(baseData);
                    return true;
                }
                return false;
            });
            if (notExistRefIds.size() <= 0) continue;
            if (baseDataList.isEmpty()) {
                iterator.remove();
                continue;
            }
            next.set("itemcondition", (Object)SerializationUtils.toJsonString((Object)baseDataList));
        }
        if (notExistRefIds.size() > 0) {
            tips.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5206\u7ec4\u8d4b\u503c\u5b57\u6bb5%s\u5f15\u7528\u7684\u57fa\u7840\u8d44\u6599\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"AnObjDataMonitorService_12", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), fieldName));
            tips.append("\r\n");
        }
    }

    private void repairGroupFields(DynamicObject[] groupFields, List<Long> removeGroupFieldIds, long anObjId) {
        HRBaseServiceHelper groupFieldHelper = new HRBaseServiceHelper("hrptmc_anobjgroupfield");
        if (removeGroupFieldIds.size() > 0) {
            HRBaseServiceHelper sideBarHelper = new HRBaseServiceHelper("hrptmc_anobjsidebar");
            DynamicObject[] sideBarCol = sideBarHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("anobj", "=", (Object)anObjId)});
            Set delGroupFieldIds = Arrays.stream(sideBarCol).filter(sideBar -> sideBar.getDynamicObject("groupfield") != null && removeGroupFieldIds.contains(sideBar.getDynamicObject("groupfield").getLong("id"))).map(sideBar -> sideBar.getLong("id")).collect(Collectors.toSet());
            groupFieldHelper.deleteByFilter(new QFilter[]{new QFilter("id", "in", removeGroupFieldIds)});
            sideBarHelper.deleteByFilter(new QFilter[]{new QFilter("id", "in", delGroupFieldIds)});
        }
        groupFieldHelper.save(groupFields);
    }

    private boolean parseFieldPathFindProperty(MainEntityType mainEntityType, String fieldPath, String complexType) {
        if (fieldPath.endsWith(".id")) {
            return true;
        }
        String[] aliasArr = fieldPath.split("\\.");
        IDataEntityProperty property = null;
        String fieldName = aliasArr[aliasArr.length - 1];
        if (AnalyseObjectUtil.isBaseDataType((String)complexType)) {
            String parentFieldName = aliasArr[aliasArr.length - 2];
            if (aliasArr.length > 2) {
                String grandParentFieldName = aliasArr[aliasArr.length - 3];
                IDataEntityProperty grandParentProp = (IDataEntityProperty)mainEntityType.getAllFields().get(grandParentFieldName);
                if (grandParentProp instanceof BasedataProp) {
                    String grandParentEntityNum = ((BasedataProp)grandParentProp).getBaseEntityId();
                    MainEntityType grandParentBaseDataEntityType = EntityMetadataCache.getDataEntityType((String)grandParentEntityNum);
                    property = (IDataEntityProperty)grandParentBaseDataEntityType.getAllFields().get(parentFieldName);
                    MainEntityType parentBaseDataEntityType = EntityMetadataCache.getDataEntityType((String)((BasedataProp)property).getBaseEntityId());
                    property = (IDataEntityProperty)parentBaseDataEntityType.getAllFields().get(fieldName);
                }
            }
            if (property == null && (property = (IDataEntityProperty)mainEntityType.getAllFields().get(parentFieldName)) != null) {
                String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                MainEntityType baseDataEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
                property = (IDataEntityProperty)baseDataEntityType.getAllFields().get(fieldName);
            }
        } else {
            property = (IDataEntityProperty)mainEntityType.getAllFields().get(fieldName);
        }
        return property != null;
    }

    public Set<String> getNotExistEntityNumSet() {
        return this.notExistEntityNumSet;
    }

    public Set<String> getNotExistFieldAliasSet() {
        return this.notExistFieldAliasSet;
    }
}

