/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.anobj;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dts.configoperator.DtsConfigOperator;
import kd.bos.dts.configoperator.DtsConfigOperatorFactory;
import kd.bos.dts.configoperator.DtsConfigOperatorInfo;
import kd.bos.dts.enmu.DtsDestTypeEnum;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnObjDataExtractService;
import kd.hr.hrptmc.business.anobj.AnObjDataStoreTaskServiceHelper;
import kd.hr.hrptmc.business.anobj.AnObjGroupFieldService;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.anobj.datastore.AnObjDtsBusinessType;
import kd.hr.hrptmc.business.calfield.CalculateFieldService;
import kd.hr.hrptmc.business.datastore.DataStoreLogService;
import kd.hr.hrptmc.business.datastore.IDataStoreService;
import kd.hr.hrptmc.business.datastore.metadata.model.RptFormMetadataContent;
import kd.hr.hrptmc.business.datastore.metadata.model.RptMetaFieldMap;
import kd.hr.hrptmc.business.datastore.metadata.model.RptMetadataContentBaseMsg;
import kd.hr.hrptmc.business.datastore.metadata.service.RptMetadataService;
import kd.hr.hrptmc.business.datastore.model.BatchQueryAndSaveDataBo;
import kd.hr.hrptmc.business.datastore.physicaltable.PhysicalTableHandler;
import kd.hr.hrptmc.business.datastore.physicaltable.RptPhysicalTableHandlerCreator;
import kd.hr.hrptmc.business.datastore.physicaltable.model.DataStoreTableBo;
import kd.hr.hrptmc.business.datastore.queryservice.ReportDataExtractQueryService;
import kd.hr.hrptmc.business.repdesign.datastore.FieldDataStoreBO;
import kd.hr.hrptmc.business.repdesign.datastore.ReportDataStoreServiceHelper;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.common.constant.dataextract.AnObjExtractConstants;
import kd.hr.hrptmc.common.model.anobj.AnObjGroupField;
import kd.hr.hrptmc.common.model.anobj.PivotIndexFieldBo;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;
import kd.hr.hrptmc.common.model.dataextract.AnObjExtractConfigBo;

public class AnObjDataStoreTaskService
implements IDataStoreService,
AnObjExtractConstants {
    private static final Log LOGGER = LogFactory.getLog(AnObjDataStoreTaskService.class);
    private final DataStoreLogService dataStoreLogService;
    private final Long anObjId;
    private final String mainEntityNum;

    public AnObjDataStoreTaskService(Long anObjId) {
        this.anObjId = anObjId;
        AnalyseObjectService instance = AnalyseObjectService.getInstance();
        this.mainEntityNum = instance.getMainEntityNumber(anObjId);
        this.dataStoreLogService = new DataStoreLogService(anObjId, false);
    }

    @Override
    public boolean beforeExecute() {
        DynamicObject configDyn = AnObjDataStoreTaskServiceHelper.getConfigDyn(this.anObjId);
        String status = configDyn.getString("runstatus");
        if ("1".equals(status)) {
            return this.isDirtyData();
        }
        AnObjDataStoreTaskServiceHelper.updateConfigRunStatus(this.anObjId, "1");
        return true;
    }

    @Override
    public void execute() {
        AnObjExtractConfigBo anObjExtractConfig = AnObjDataExtractService.getInstance().getAnObjExtractConfig(this.anObjId);
        String originMetadataNum = anObjExtractConfig.getMetadataNum();
        AnalyseObjectService anObjService = AnalyseObjectService.getInstance();
        List<QueryFieldBo> queryFieldBos = anObjService.queryAndAssembleQueryFields(this.anObjId);
        List<CalculateFieldBo> calculateFieldBos = CalculateFieldService.getInstance().loadCalFieldsByAnObjIdForBo(this.anObjId, false);
        List<PivotIndexFieldBo> analysePivotIndexes = AnalyseObjectService.getInstance().getAnalysePivotIndexes(this.anObjId, queryFieldBos, calculateFieldBos, true);
        List<AnObjGroupField> groupFields = AnObjGroupFieldService.getInstance().getGroupFields(this.anObjId, queryFieldBos);
        String entityNumber = this.generateEntityNum();
        String tableName = "t_" + entityNumber;
        RptMetadataContentBaseMsg metadataContentBaseMsg = new RptMetadataContentBaseMsg(entityNumber, entityNumber, "3+JJD4IUAS56", "hros", tableName);
        RptFormMetadataContent formMetadataContent = RptMetadataService.getInstance().generateMetaData(metadataContentBaseMsg, anObjExtractConfig.getAnObjId(), queryFieldBos, calculateFieldBos, analysePivotIndexes, groupFields);
        PhysicalTableHandler tableHandler = RptPhysicalTableHandlerCreator.getHandler(formMetadataContent);
        tableHandler.createTable();
        RptMetadataService.getInstance().bindTable(formMetadataContent);
        try {
            Map<String, List<String>> reportsTableIndexes = AnObjDataExtractService.getInstance().getReportsTableIndexes(this.anObjId, tableName, formMetadataContent.getMetaFieldMapList());
            reportsTableIndexes.forEach((indexName, indexFields) -> tableHandler.createIndex((String)indexName, tableName, indexFields.toArray(new String[0])));
        }
        catch (Exception exception) {
            LOGGER.error("AnObjDataStoreTaskService.execute create Index error.", (Throwable)exception);
        }
        if (HRStringUtils.isNotEmpty((String)originMetadataNum)) {
            this.deleteMetadataAndTable(originMetadataNum);
        }
        this.setConfigMetadataNumber(this.anObjId, entityNumber);
        List<RptMetaFieldMap> metaFieldMapList = formMetadataContent.getMetaFieldMapList();
        this.saveFieldMap(this.anObjId, metaFieldMapList);
        this.saveDTSConfig();
        this.dataStoreLogService.insertLog(entityNumber, tableName);
    }

    @Override
    public void endExecute() {
    }

    @Override
    public void endSyn() {
        AnObjDataStoreTaskServiceHelper.updateConfigRunStatus(this.anObjId, "2");
        this.dataStoreLogService.end();
        try (TXHandle txHandle = TX.requiresNew();){
            AnObjDataStoreTaskServiceHelper.deleteDtsConfig(this.anObjId, this.mainEntityNum);
        }
    }

    @Override
    public void batchSynData(List<Object> idList) {
        if (this.isTermination()) {
            return;
        }
        try {
            this.executeBatchSynData(idList);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            this.dataStoreLogService.error(e.toString());
            ThreadPools.executeOnce((String)"AnObjDataStoreTaskService_batchSynData_error", () -> {
                ReportDataStoreServiceHelper.deleteDtsConfig(this.anObjId, this.mainEntityNum);
                AnObjDataStoreTaskServiceHelper.updateConfigRunStatus(this.anObjId, "3");
            });
            throw new KDBizException(e.getMessage());
        }
    }

    private void executeBatchSynData(List<Object> idList) {
        int querySize;
        this.setUserId();
        long time0 = System.currentTimeMillis();
        AnalyseObjectService instance = AnalyseObjectService.getInstance();
        ArrayList newQFilterList = Lists.newArrayList((Object[])new QFilter[]{new QFilter("id", "in", idList)});
        List<QueryFieldBo> queryFieldBos = instance.queryAndAssembleQueryFields(this.anObjId);
        List<QFilter> qFilters = instance.getQueryQFilter(this.anObjId, queryFieldBos);
        newQFilterList.addAll(qFilters);
        List<RptMetaFieldMap> rptMetaFieldMapList = AnObjDataExtractService.getInstance().queryFieldMapList(this.anObjId);
        Map<String, RptMetaFieldMap> mappingFieldMap = rptMetaFieldMapList.stream().collect(Collectors.toMap(RptMetaFieldMap::getFieldAlias, rf -> rf));
        List<FieldInfo> fieldInfoList = this.getFieldInfoList(this.anObjId);
        FieldDataStoreBO dataStoreBO = new FieldDataStoreBO();
        dataStoreBO.setStoreFieldInfoList(fieldInfoList);
        List<FieldInfo> entityIdFieldList = this.getEntityIdFieldList(this.anObjId, rptMetaFieldMapList, this.mainEntityNum);
        HashSet fieldAliasSet = Sets.newHashSetWithExpectedSize((int)dataStoreBO.getStoreFieldInfoList().size());
        for (FieldInfo fieldInfo : dataStoreBO.getStoreFieldInfoList()) {
            fieldAliasSet.add(fieldInfo.getNumber());
        }
        List<FieldInfo> newStoreFieldList = dataStoreBO.getStoreFieldInfoList().stream().filter(sf -> {
            if (sf.getNumber().endsWith(".id")) {
                String pre = sf.getNumber().substring(0, sf.getNumber().length() - 3);
                return !fieldAliasSet.contains(pre + ".number") && !fieldAliasSet.contains(pre + ".name");
            }
            return true;
        }).collect(Collectors.toList());
        newStoreFieldList.addAll(entityIdFieldList);
        dataStoreBO.getStoreFieldInfoList().addAll(entityIdFieldList);
        DynamicObject configDyn = AnObjDataStoreTaskServiceHelper.getConfigDyn(this.anObjId);
        HRBaseServiceHelper newServiceHelper = new HRBaseServiceHelper(configDyn.getString("metadatanum"));
        RptMetaFieldMap idRptMetaFieldMap = mappingFieldMap.get("id");
        if (idRptMetaFieldMap != null) {
            newServiceHelper.deleteByFilter(new QFilter[]{new QFilter(idRptMetaFieldMap.getMetaFieldNumber(), "in", idList)});
        }
        long time1 = System.currentTimeMillis();
        LOGGER.info("AnObjDataStoreTaskService_batchSynData_prepare_time:{}", (Object)(time1 - time0));
        int start = 0;
        try (TXHandle txHandle = TX.requiresNew();){
            BatchQueryAndSaveDataBo bo;
            int fieldSize = dataStoreBO.getStoreFieldInfoList().size();
            int queryCount = MAX_SIZE / fieldSize;
            ReportDataExtractQueryService queryService = new ReportDataExtractQueryService();
            while ((querySize = this.batchQueryAndSaveData(bo = new BatchQueryAndSaveDataBo(this.anObjId, 0L, newServiceHelper, mappingFieldMap, dataStoreBO, null, newQFilterList, queryService, start, queryCount, newStoreFieldList, idList))) >= queryCount) {
                start += queryCount;
            }
        }
        long time2 = System.currentTimeMillis();
        LOGGER.info("AnObjDataStoreTaskService_batchSynData_queryAndSave_time:{}", (Object)(time2 - time1));
        LOGGER.info("AnObjDataStoreTaskService_batchSynData_time:{}", (Object)(time2 - time0));
        this.dataStoreLogService.updateCount(start += querySize);
    }

    @Override
    public String getMainEntityNumber() {
        return this.mainEntityNum;
    }

    @Override
    public String generateEntityNumPre() {
        return "hrom_an_";
    }

    private void deleteMetadataAndTable(String metadataNumber) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)metadataNumber);
        String tableName = dataEntityType.getAlias();
        RptMetadataService.getInstance().deleteMetaData(metadataNumber);
        DataStoreTableBo dataStoreTableBo = new DataStoreTableBo();
        dataStoreTableBo.setTableName(tableName);
        dataStoreTableBo.setDbRoute(DBRoute.of((String)dataEntityType.getDBRouteKey()));
        PhysicalTableHandler tableHandler = new PhysicalTableHandler(dataStoreTableBo);
        tableHandler.deleteTable('a');
        AnObjDataExtractService.getInstance().deleteFieldMapList(this.anObjId);
    }

    private void setConfigMetadataNumber(long anObjId, String metadataNumber) {
        HRBaseServiceHelper configHelper = new HRBaseServiceHelper("hrptmc_anobjextract");
        DynamicObject configDy = configHelper.queryOne("metadatanum", new QFilter[]{new QFilter("anobj", "=", (Object)anObjId)});
        configDy.set("metadatanum", (Object)metadataNumber);
        configHelper.saveOne(configDy);
    }

    private void saveFieldMap(long anObjId, List<RptMetaFieldMap> metaFieldMapList) {
        HRBaseServiceHelper fieldMapHelper = new HRBaseServiceHelper("hrptmc_anobjfieldmap");
        DynamicObjectCollection fieldMapCol = new DynamicObjectCollection();
        for (RptMetaFieldMap rptMetaFieldMap : metaFieldMapList) {
            DynamicObject fieldMapDy = fieldMapHelper.generateEmptyDynamicObject();
            fieldMapDy.set("anobj", (Object)anObjId);
            fieldMapDy.set("fieldalias", (Object)rptMetaFieldMap.getFieldAlias());
            fieldMapDy.set("fieldnum", (Object)rptMetaFieldMap.getMetaFieldNumber());
            fieldMapDy.set("fieldname", (Object)rptMetaFieldMap.getTableFieldName());
            fieldMapDy.set("controltype", (Object)rptMetaFieldMap.getFieldControlType());
            fieldMapDy.set("tablefieldtype", (Object)rptMetaFieldMap.getTableFieldType());
            fieldMapCol.add((Object)fieldMapDy);
        }
        fieldMapHelper.save(fieldMapCol);
    }

    private List<FieldInfo> getFieldInfoList(Long anObjId) {
        FieldInfo fieldInfo;
        AnalyseObjectService instance = AnalyseObjectService.getInstance();
        List<CalculateFieldBo> calculateFieldBos = CalculateFieldService.getInstance().loadCalFieldsByAnObjIdForBo(anObjId, false);
        List<QueryFieldBo> queryFieldBos = instance.queryAndAssembleQueryFields(anObjId);
        List<PivotIndexFieldBo> analysePivotIndexes = AnalyseObjectService.getInstance().getAnalysePivotIndexes(anObjId, queryFieldBos, calculateFieldBos, true);
        AnObjGroupFieldService groupFieldService = AnObjGroupFieldService.getInstance();
        List<AnObjGroupField> groupFields = groupFieldService.getGroupFields(anObjId, queryFieldBos);
        for (AnObjGroupField anObjGroupField : groupFields) {
            calculateFieldBos.add(groupFieldService.transferGroupField(Collections.emptyList(), queryFieldBos, anObjGroupField));
        }
        ArrayList fieldInfoList = Lists.newArrayListWithExpectedSize((int)queryFieldBos.size());
        for (QueryFieldBo queryFieldBo : queryFieldBos) {
            fieldInfo = AnObjDataStoreTaskService.queryField2FieldInfo((QueryFieldCommonBo)queryFieldBo);
            ReportDataStoreServiceHelper.setType(fieldInfo);
            fieldInfoList.add(fieldInfo);
        }
        for (PivotIndexFieldBo analysePivotIndex : analysePivotIndexes) {
            fieldInfo = AnObjDataStoreTaskService.queryField2FieldInfo((QueryFieldCommonBo)analysePivotIndex);
            fieldInfo.setPivotIndex(true);
            fieldInfo.setType("2");
            fieldInfoList.add(fieldInfo);
        }
        for (CalculateFieldBo calculateFieldBo : calculateFieldBos) {
            fieldInfo = new FieldInfo();
            fieldInfo.setFieldId(calculateFieldBo.getId());
            fieldInfo.setNumber(calculateFieldBo.getFieldNumber());
            fieldInfo.setNumberAlias(fieldInfo.getNumber());
            fieldInfo.setDisplayName(calculateFieldBo.getFieldName());
            fieldInfo.setName(calculateFieldBo.getFieldName());
            fieldInfo.setValueType(calculateFieldBo.getValueType());
            fieldInfo.setControlType(calculateFieldBo.getControlType());
            fieldInfo.setFieldSrc("1");
            fieldInfo.setFieldPath(calculateFieldBo.getFieldNumber());
            ReportDataStoreServiceHelper.setType(fieldInfo);
            fieldInfoList.add(fieldInfo);
        }
        LOGGER.info("AnObjDataStoreTaskService_getFieldInfoList_fieldInfoList:{}", (Object)fieldInfoList);
        return fieldInfoList;
    }

    private static FieldInfo queryField2FieldInfo(QueryFieldCommonBo queryFieldCommonBo) {
        FieldInfo fieldInfo = new FieldInfo();
        fieldInfo.setFieldId(queryFieldCommonBo.getId());
        fieldInfo.setNumber(queryFieldCommonBo.getFieldAlias());
        fieldInfo.setNumberAlias(fieldInfo.getNumber());
        fieldInfo.setFieldPath(queryFieldCommonBo.getFieldPath());
        fieldInfo.setBaseDataNum(queryFieldCommonBo.getBaseDataNum());
        fieldInfo.setDisplayName(queryFieldCommonBo.getFieldName());
        fieldInfo.setValueType(queryFieldCommonBo.getValueType());
        fieldInfo.setComplexType(queryFieldCommonBo.getComplexType());
        fieldInfo.setControlType(queryFieldCommonBo.getControlType());
        fieldInfo.setEntityNumber(queryFieldCommonBo.getEntityNumber());
        fieldInfo.setName(queryFieldCommonBo.getFieldName());
        return fieldInfo;
    }

    private boolean isTermination() {
        DynamicObject configDyn = AnObjDataStoreTaskServiceHelper.getConfigDyn(this.anObjId);
        return HRStringUtils.equals((String)"3", (String)configDyn.getString("runstatus"));
    }

    private boolean isDirtyData() {
        return this.isWarningDtsConfig(this.mainEntityNum, AnObjDataStoreTaskServiceHelper.getMappingRule(this.anObjId));
    }

    private void saveDTSConfig() {
        AnObjDataStoreTaskServiceHelper.deleteDtsConfig(this.anObjId, this.mainEntityNum);
        String mappingRule = AnObjDataStoreTaskServiceHelper.getMappingRule(this.anObjId);
        String businessType = new AnObjDtsBusinessType().getBusinessTypeCode();
        DtsConfigOperatorInfo dtsConfigOperatorInfo = new DtsConfigOperatorInfo();
        dtsConfigOperatorInfo.setEntityNumber(this.mainEntityNum);
        dtsConfigOperatorInfo.setDtsDestType(DtsDestTypeEnum.FULLTEXT);
        dtsConfigOperatorInfo.setRegion("hr");
        dtsConfigOperatorInfo.setMappingRule(mappingRule);
        dtsConfigOperatorInfo.setBusinessType(businessType);
        dtsConfigOperatorInfo.setEnable("1");
        dtsConfigOperatorInfo.setEntityFields(new String[]{"id"});
        DtsConfigOperator dtsConfigOperator = DtsConfigOperatorFactory.getDefault();
        dtsConfigOperator.saveDtsConfig(dtsConfigOperatorInfo);
    }
}

