/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.anobj;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.dts.configoperator.DtsConfigOperator;
import kd.bos.dts.configoperator.DtsConfigOperatorFactory;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnObjDataExtractService;
import kd.hr.hrptmc.business.anobj.datastore.AnObjDtsBusinessType;
import kd.hr.hrptmc.business.datastore.DataStoreLogService;
import kd.hr.hrptmc.business.datastore.metadata.service.RptMetadataService;
import kd.hr.hrptmc.business.datastore.physicaltable.PhysicalTableHandler;
import kd.hr.hrptmc.business.datastore.physicaltable.model.DataStoreTableBo;
import kd.hr.hrptmc.common.constant.dataextract.AnObjExtractConstants;
import kd.hr.hrptmc.common.model.dataextract.AnObjExtractConfigBo;

public class AnObjDataStoreTaskServiceHelper
implements AnObjExtractConstants {
    public static String getMappingRule(long anObjId) {
        return "anobjmapping#anObjId=" + anObjId;
    }

    public static void deleteDtsConfig(long anObjId, String entityNum) {
        DtsConfigOperator dtsConfigOperator = DtsConfigOperatorFactory.getDefault();
        String mappingRule = AnObjDataStoreTaskServiceHelper.getMappingRule(anObjId);
        String businessType = new AnObjDtsBusinessType().getBusinessTypeCode();
        dtsConfigOperator.deleteDtsConfig(entityNum, businessType, "hr", mappingRule);
    }

    public static void deleteAnoSchedule(List<Object> anObjIds) {
        for (Object anObjId : anObjIds) {
            AnObjDataStoreTaskServiceHelper.deleteAnoSchedule((Long)anObjId);
        }
        HRBaseServiceHelper configHelper = new HRBaseServiceHelper("hrptmc_anobjextract");
        configHelper.deleteByFilter(new QFilter[]{new QFilter("anobj", "in", anObjIds)});
    }

    public static void deleteAnoSchedule(long anObjId) {
        AnObjDataExtractService anObjDataExtractService = AnObjDataExtractService.getInstance();
        AnObjExtractConfigBo anObjExtractConfig = anObjDataExtractService.getAnObjExtractConfig(anObjId);
        if (anObjExtractConfig != null) {
            AnObjDataStoreTaskServiceHelper.clearConfig(anObjExtractConfig);
        }
    }

    public static void clearConfig(AnObjExtractConfigBo anObjExtractConfig) {
        anObjExtractConfig.setCycle(null);
        anObjExtractConfig.setCronExpr(null);
        AnObjDataExtractService.getInstance().deleteSchedulePlanAndJob(anObjExtractConfig.getSchedulePlanId(), anObjExtractConfig.getSchedulePlanLastId(), anObjExtractConfig.getScheduleJobId());
        anObjExtractConfig.setSchedulePlanId(null);
        anObjExtractConfig.setSchedulePlanLastId(null);
        anObjExtractConfig.setScheduleJobId(null);
        if (HRStringUtils.isNotEmpty((String)anObjExtractConfig.getMetadataNum())) {
            String tableName;
            String dbRouteKey;
            String metadataNum = anObjExtractConfig.getMetadataNum();
            try {
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)anObjExtractConfig.getMetadataNum());
                dbRouteKey = dataEntityType.getDBRouteKey();
                tableName = dataEntityType.getAlias();
            }
            catch (Exception exception) {
                tableName = "t_" + metadataNum;
                dbRouteKey = "hros";
            }
            Long anObjId = anObjExtractConfig.getAnObjId();
            String finalDbRouteKey = dbRouteKey;
            String finalTableName = tableName;
            ThreadPools.executeOnce((String)"AnObjDataStoreTaskServiceHelper.clearConfig.delete", () -> {
                AnObjDataStoreTaskServiceHelper.deleteDtsConfig(anObjId, metadataNum);
                RptMetadataService.getInstance().deleteMetaData(metadataNum);
                PhysicalTableHandler tableHandler = new PhysicalTableHandler(new DataStoreTableBo(finalTableName, new DBRoute(finalDbRouteKey)));
                tableHandler.deleteTable('a');
            });
            AnObjDataExtractService.getInstance().deleteFieldMapList(anObjExtractConfig.getAnObjId());
        }
        anObjExtractConfig.setMetadataNum(null);
        anObjExtractConfig.setExecuteNow(false);
        anObjExtractConfig.setRunStatus("0");
    }

    public static void updateConfigRunStatus(long anObjId, String runStatus) {
        HRBaseServiceHelper configHelper = new HRBaseServiceHelper("hrptmc_anobjextract");
        DynamicObject configDy = configHelper.queryOne("runstatus", new QFilter[]{new QFilter("anobj", "=", (Object)anObjId)});
        if (configDy != null) {
            configDy.set("runstatus", (Object)runStatus);
            configHelper.saveOne(configDy);
        }
    }

    public static void stopSyn(Long anObjId) {
        AnObjDataStoreTaskServiceHelper.updateConfigRunStatus(anObjId, "3");
        DataStoreLogService dataStoreLogService = new DataStoreLogService(anObjId, false);
        dataStoreLogService.stop();
    }

    public static DynamicObject getConfigDyn(long anObjId) {
        HRBaseServiceHelper configHelper = new HRBaseServiceHelper("hrptmc_anobjextract");
        return configHelper.loadDynamicObject(new QFilter[]{new QFilter("anobj", "=", (Object)anObjId)});
    }
}

