/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.anobj;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.filesource.FileSourceTableMsgService;
import kd.hr.hrptmc.business.filesource.ReportFileSourceService;
import kd.hr.hrptmc.common.constant.anobj.AnalyseObjectConstants;

public class AnObjEnumFieldHandler
implements AnalyseObjectConstants {
    private static final Log LOGGER = LogFactory.getLog(AnObjEnumFieldHandler.class);
    private final String objectType;
    private String fileSourceTableName;
    private final Map<String, List<AnObjEnumItem>> fileSourceEnumItems = Maps.newHashMapWithExpectedSize((int)16);
    private final MainEntityTypeUtil mainEntityTypeUtil;

    public AnObjEnumFieldHandler(long anObjId, MainEntityTypeUtil mainEntityTypeUtil) {
        DynamicObject anObjDy = AnalyseObjectService.getInstance().getAnObjDy(anObjId);
        this.objectType = anObjDy.getString("objecttype");
        this.setFileSourceTableName(anObjId);
        this.queryFileSourceEnumItems();
        this.mainEntityTypeUtil = mainEntityTypeUtil;
    }

    public AnObjEnumFieldHandler(DynamicObject anObjDy, MainEntityTypeUtil mainEntityTypeUtil) {
        this.objectType = HRStringUtils.isEmpty((String)anObjDy.getString("objecttype")) ? "multientity" : anObjDy.getString("objecttype");
        this.setFileSourceTableName(anObjDy.getLong("id"));
        this.queryFileSourceEnumItems();
        this.mainEntityTypeUtil = mainEntityTypeUtil;
    }

    public AnObjEnumFieldHandler(long anObjId, String objectType, MainEntityTypeUtil mainEntityTypeUtil) {
        this.objectType = objectType;
        this.setFileSourceTableName(anObjId);
        this.queryFileSourceEnumItems();
        this.mainEntityTypeUtil = mainEntityTypeUtil;
    }

    public List<AnObjEnumItem> getEnumItems(QueryFieldCommonBo queryFieldBo) {
        if (queryFieldBo == null) {
            return Lists.newArrayListWithExpectedSize((int)1);
        }
        List<Object> anObjEnumItems = Lists.newArrayListWithCapacity((int)10);
        if (this.isEntityAnObjType()) {
            String fieldAlias;
            String enumBaseDataNum = queryFieldBo.getBaseDataNum();
            if (enumBaseDataNum == null) {
                enumBaseDataNum = queryFieldBo.getEntityNumber();
            }
            if ((fieldAlias = queryFieldBo.getFieldAlias()).contains(".")) {
                fieldAlias = fieldAlias.substring(fieldAlias.lastIndexOf(".") + 1);
            }
            anObjEnumItems = this.getEnumItemsForAnObj(enumBaseDataNum, fieldAlias);
        } else if (HRStringUtils.equals((String)this.objectType, (String)"filesource")) {
            anObjEnumItems = this.getEnumItemsForFileSource(queryFieldBo.getFieldAlias());
        }
        return anObjEnumItems;
    }

    public List<AnObjEnumItem> getEnumItems(String fieldAlias, String entityNumber) {
        List<Object> anObjEnumItems = Lists.newArrayListWithCapacity((int)10);
        if (this.isEntityAnObjType()) {
            IDataEntityProperty property = AnalyseObjectUtil.parseFieldAliasGetProperty((String)entityNumber, (String)fieldAlias, (MainEntityTypeUtil)this.mainEntityTypeUtil);
            anObjEnumItems = this.getEnumItems(property);
        } else if (HRStringUtils.equals((String)this.objectType, (String)"filesource")) {
            anObjEnumItems = this.getEnumItemsForFileSource(fieldAlias);
        }
        return anObjEnumItems;
    }

    private List<AnObjEnumItem> getEnumItemsForAnObj(String enumBaseDataNum, String fieldNum) {
        MainEntityType dataEntityType = this.mainEntityTypeUtil.getMainEntityType(enumBaseDataNum);
        IDataEntityProperty property = (IDataEntityProperty)dataEntityType.getAllFields().get(fieldNum);
        return this.getEnumItems(property);
    }

    public List<AnObjEnumItem> getEnumItems(IDataEntityProperty property) {
        ArrayList anObjEnumItems = Lists.newArrayListWithCapacity((int)10);
        if (property instanceof ComboProp) {
            List comboItems = ((ComboProp)property).getComboItems();
            for (ValueMapItem comboItem : comboItems) {
                AnObjEnumItem item = new AnObjEnumItem();
                item.setName(comboItem.getName());
                item.setValue(comboItem.getValue());
                anObjEnumItems.add(item);
            }
        }
        return anObjEnumItems;
    }

    public List<AnObjEnumItem> getEnumItemsForFileSource(String fieldAlias) {
        return this.fileSourceEnumItems.get(fieldAlias);
    }

    private void setFileSourceTableName(long anObjId) {
        if (HRStringUtils.equals((String)this.objectType, (String)"filesource")) {
            this.fileSourceTableName = FileSourceTableMsgService.getInstance().queryTableName(anObjId);
        }
    }

    private void queryFileSourceEnumItems() {
        if (HRStringUtils.equals((String)this.objectType, (String)"filesource")) {
            DynamicObjectCollection enumDys = ReportFileSourceService.getInstance().queryEnums(this.fileSourceTableName);
            Map<String, List<DynamicObject>> enumDyMap = enumDys.stream().collect(Collectors.groupingBy(dy -> dy.getString("fieldname")));
            enumDyMap.forEach((fieldName, enumDyCol) -> {
                List<AnObjEnumItem> enumItems = this.fileSourceEnumItems.getOrDefault(fieldName, Lists.newArrayListWithCapacity((int)10));
                for (DynamicObject enumDy : enumDyCol) {
                    AnObjEnumItem item = new AnObjEnumItem();
                    String enumValue = enumDy.getString("enum");
                    item.setName(new LocaleString(enumValue));
                    item.setValue(enumValue);
                    enumItems.add(item);
                }
                this.fileSourceEnumItems.putIfAbsent((String)fieldName, enumItems);
            });
        }
    }

    private boolean isEntityAnObjType() {
        return HRStringUtils.equals((String)this.objectType, (String)"template") || HRStringUtils.equals((String)this.objectType, (String)"multientity");
    }

    public static class AnObjEnumItem {
        private LocaleString name;
        private String value;

        public LocaleString getName() {
            return this.name;
        }

        public void setName(LocaleString name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

