/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.anobj;

import com.alibaba.fastjson.JSON;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnObjGroupFieldService;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.calfield.CalculateFieldService;
import kd.hr.hrptmc.common.model.anobj.AnObjGroupField;
import kd.hr.hrptmc.common.model.anobj.AnObjHisVersionConfigBo;
import kd.hr.hrptmc.common.model.anobj.EntityRelationBo;
import kd.hr.hrptmc.common.model.anobj.JoinEntityBo;
import kd.hr.hrptmc.common.model.anobj.PivotIndexFieldBo;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;

public class AnObjHisVersionService {
    private final String ENTITY_AN_OBJ_CONFIG_HIS = "hrptmc_anobjconfighis";
    private final String AN_OBJ_ID = "anobjid";
    private final String START_TIME = "starttime";
    private final String END_TIME = "endtime";
    private final HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_anobjconfighis");
    private final HRBaseServiceHelper anObjHelper = new HRBaseServiceHelper("hrptmc_analyseobject");
    private static final Log LOGGER = LogFactory.getLog(AnObjHisVersionService.class);
    private static volatile AnObjHisVersionService service = null;

    private AnObjHisVersionService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AnObjHisVersionService getInstance() {
        if (service != null) return service;
        Class<AnObjHisVersionService> clazz = AnObjHisVersionService.class;
        synchronized (AnObjHisVersionService.class) {
            if (service != null) return service;
            service = new AnObjHisVersionService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public AnObjHisVersionConfigBo getAnObjHisVersionConfigBo(long anObjId, Date versionTime) {
        QFilter qFilter = new QFilter("anobjid", "=", (Object)anObjId);
        qFilter.and(new QFilter("starttime", "<=", (Object)versionTime));
        qFilter.and(new QFilter("endtime", ">", (Object)versionTime));
        DynamicObject versionDy = this.helper.loadDynamicObject(qFilter);
        if (versionDy == null) {
            return null;
        }
        String anObjName = versionDy.getLocaleString("name").getLocaleValue();
        String anObjNumber = versionDy.getString("number");
        String objectType = versionDy.getString("objecttype");
        String queryFieldStr = versionDy.getString("queryfield");
        String joinEntityStr = versionDy.getString("joinentity");
        String entityRelationStr = versionDy.getString("entityrelation");
        String calculateFieldStr = versionDy.getString("calculatefield");
        String pivotIndexStr = versionDy.getString("pivotindexes");
        String groupFieldStr = versionDy.getString("groupfields");
        String dataFilter = versionDy.getString("datafilter");
        AnObjHisVersionConfigBo anObjHisVersionConfigBo = new AnObjHisVersionConfigBo();
        anObjHisVersionConfigBo.setAnObjId(Long.valueOf(anObjId));
        anObjHisVersionConfigBo.setAnObjNumber(anObjNumber);
        anObjHisVersionConfigBo.setAnObjName(anObjName);
        anObjHisVersionConfigBo.setObjectType(objectType);
        List queryFieldBos = JSON.parseArray((String)queryFieldStr, QueryFieldBo.class);
        anObjHisVersionConfigBo.setQueryFieldBos(queryFieldBos);
        List joinEntityBos = JSON.parseArray((String)joinEntityStr, JoinEntityBo.class);
        anObjHisVersionConfigBo.setJoinEntityBos(joinEntityBos);
        if (HRStringUtils.isNotEmpty((String)entityRelationStr)) {
            List entityRelationBos = JSON.parseArray((String)entityRelationStr, EntityRelationBo.class);
            anObjHisVersionConfigBo.setEntityRelationBos(entityRelationBos);
        }
        if (HRStringUtils.isNotEmpty((String)calculateFieldStr)) {
            List calculateFieldBos = JSON.parseArray((String)calculateFieldStr, CalculateFieldBo.class);
            anObjHisVersionConfigBo.setCalculateFieldBos(calculateFieldBos);
        }
        if (HRStringUtils.isNotEmpty((String)pivotIndexStr)) {
            List pivotIndexFieldBos = JSON.parseArray((String)pivotIndexStr, PivotIndexFieldBo.class);
            anObjHisVersionConfigBo.setPivotIndexes(pivotIndexFieldBos);
        }
        if (HRStringUtils.isNotEmpty((String)groupFieldStr)) {
            List groupFields = JSON.parseArray((String)groupFieldStr, AnObjGroupField.class);
            anObjHisVersionConfigBo.setGroupFields(groupFields);
        }
        anObjHisVersionConfigBo.setDataFilter(dataFilter);
        return anObjHisVersionConfigBo;
    }

    public void saveAnObjHisVersionConfigBo(DynamicObject anObjDy, String objectType, List<JoinEntityBo> joinEntityBos, List<EntityRelationBo> entityRelations, List<QueryFieldBo> queryFieldBos, List<CalculateFieldBo> calculateFieldBos, List<PivotIndexFieldBo> pivotIndexFieldBos, List<AnObjGroupField> groupFields, String dataFilter) {
        try {
            long anObjId = anObjDy.getLong("id");
            DynamicObject versionDy = this.helper.generateEmptyDynamicObject();
            versionDy.set("anobjid", (Object)anObjId);
            versionDy.set("name", anObjDy.get("name"));
            versionDy.set("number", anObjDy.get("number"));
            versionDy.set("objecttype", (Object)objectType);
            versionDy.set("datafilter", (Object)dataFilter);
            this.setConfigData(versionDy, joinEntityBos, entityRelations, queryFieldBos, calculateFieldBos, pivotIndexFieldBos, groupFields);
            versionDy.set("starttime", (Object)new Date());
            Calendar calendar = Calendar.getInstance();
            calendar.set(2999, 11, 31);
            versionDy.set("endtime", (Object)calendar.getTime());
            versionDy.set("creator", (Object)RequestContext.get().getCurrUserId());
            DynamicObject lastVersionDy = this.helper.queryOne("starttime, endtime", new QFilter[]{new QFilter("anobjid", "=", (Object)anObjId)}, "starttime desc");
            if (lastVersionDy != null) {
                lastVersionDy.set("endtime", (Object)versionDy.getDate("starttime"));
                this.helper.saveOne(lastVersionDy);
            } else if (anObjDy.getDataEntityState().getFromDatabase()) {
                this.generateOriginalVersion(anObjId, anObjDy, versionDy);
            }
            this.helper.saveOne(versionDy);
        }
        catch (Exception exception) {
            LOGGER.error("AnObjHisVersionService saveAnObjHisVersionConfigBo error: ", (Throwable)exception);
            throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5206\u6790\u5bf9\u8c61\u914d\u7f6e\u7248\u672c\u8bb0\u5f55\u5f02\u5e38\u3002", (String)"AnObjHisVersionService_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
        }
    }

    private void generateOriginalVersion(long anObjId, DynamicObject anObjDy, DynamicObject versionDy) {
        DynamicObject originalAnObjDy = this.anObjHelper.queryOne("id, name, number, objecttype, datafilter", new QFilter[]{new QFilter("id", "=", (Object)anObjId)});
        DynamicObject originVersionDy = this.helper.generateEmptyDynamicObject();
        originVersionDy.set("anobjid", (Object)anObjId);
        originVersionDy.set("name", originalAnObjDy.get("name"));
        originVersionDy.set("number", originalAnObjDy.get("number"));
        originVersionDy.set("objecttype", originalAnObjDy.get("objecttype"));
        originVersionDy.set("datafilter", originVersionDy.get("datafilter"));
        List<JoinEntityBo> originalJoinEntities = AnalyseObjectService.getInstance().queryAndAssembleJoinEntities(anObjId);
        List<EntityRelationBo> originalRelations = AnalyseObjectService.getInstance().queryAndAssembleEntityRelations(anObjId);
        List<QueryFieldBo> originalQueryFields = AnalyseObjectService.getInstance().queryAndAssembleQueryFields(anObjId);
        List<CalculateFieldBo> originalCalculateFields = CalculateFieldService.getInstance().loadCalFieldsByAnObjIdForBo(anObjId, false);
        DynamicObject[] pivotConfigDys = AnalyseObjectService.getInstance().queryAnObjPivotDys(anObjId);
        List<PivotIndexFieldBo> originalPivotIndexes = AnalyseObjectService.getInstance().getAnalysePivotIndexes(pivotConfigDys, originalQueryFields, originalCalculateFields, false);
        List<AnObjGroupField> originalGroupFields = AnObjGroupFieldService.getInstance().getGroupFields(anObjId, originalQueryFields);
        this.setConfigData(originVersionDy, originalJoinEntities, originalRelations, originalQueryFields, originalCalculateFields, originalPivotIndexes, originalGroupFields);
        originVersionDy.set("starttime", (Object)anObjDy.getDate("createtime"));
        originVersionDy.set("endtime", (Object)versionDy.getDate("starttime"));
        originVersionDy.set("creator", (Object)versionDy.getLong("creator"));
        this.helper.saveOne(originVersionDy);
    }

    private void setConfigData(DynamicObject versionDy, List<JoinEntityBo> joinEntityBos, List<EntityRelationBo> entityRelations, List<QueryFieldBo> queryFieldBos, List<CalculateFieldBo> calculateFieldBos, List<PivotIndexFieldBo> pivotIndexFieldBos, List<AnObjGroupField> groupFields) {
        versionDy.set("joinentity", (Object)SerializationUtils.toJsonString(joinEntityBos));
        versionDy.set("entityrelation", (Object)SerializationUtils.toJsonString(entityRelations));
        versionDy.set("queryfield", (Object)SerializationUtils.toJsonString(queryFieldBos));
        if (calculateFieldBos != null) {
            versionDy.set("calculatefield", (Object)SerializationUtils.toJsonString(calculateFieldBos));
        }
        if (pivotIndexFieldBos != null) {
            versionDy.set("pivotindexes", (Object)SerializationUtils.toJsonString(pivotIndexFieldBos));
        }
        if (groupFields != null) {
            versionDy.set("groupfields", (Object)SerializationUtils.toJsonString(groupFields));
        }
    }

    public void updateVersionWhenDeleteAnObj(List<Object> anObjIds) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2999, 11, 31);
        Date forever = calendar.getTime();
        DynamicObject[] lastVersionDys = this.helper.query("anobjid, starttime, endtime", new QFilter[]{new QFilter("anobjid", "in", anObjIds), new QFilter("endtime", "=", (Object)forever)});
        if (lastVersionDys.length > 0) {
            Date now = new Date();
            for (DynamicObject lastVersionDy : lastVersionDys) {
                lastVersionDy.set("endtime", (Object)now);
            }
            this.helper.save(lastVersionDys);
        }
    }
}

