/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.anobj;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hrptmc.business.anobj.AnObjGroupFieldService;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.calfield.CalculateFieldService;
import kd.hr.hrptmc.common.constant.anobj.AnalyseObjectConstants;
import kd.hr.hrptmc.common.model.anobj.AnObjGroupField;
import kd.hr.hrptmc.common.model.anobj.PivotIndexFieldBo;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.anobj.TempAnObjFieldBo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;

public class AnObjTemplateLibService
implements AnalyseObjectConstants {
    private static final Log LOGGER = LogFactory.getLog(AnObjTemplateLibService.class);
    private final HRBaseServiceHelper analyseObjectHelper = new HRBaseServiceHelper("hrptmc_analyseobject");
    private final HRBaseServiceHelper queryFieldHelper = new HRBaseServiceHelper("hrptmc_anobjqueryfield");
    private final HRBaseServiceHelper pivotHelper = new HRBaseServiceHelper("hrptmc_anobjpivot");
    private static final HRBaseServiceHelper groupFieldHelper = new HRBaseServiceHelper("hrptmc_anobjgroupfield");
    private final HRBaseServiceHelper calFieldHelper = new HRBaseServiceHelper("hrptmc_calculatefield");
    private static volatile AnObjTemplateLibService service = null;

    private AnObjTemplateLibService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AnObjTemplateLibService getInstance() {
        if (service != null) return service;
        Class<AnObjTemplateLibService> clazz = AnObjTemplateLibService.class;
        synchronized (AnObjTemplateLibService.class) {
            if (service != null) return service;
            service = new AnObjTemplateLibService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public DynamicObjectCollection getAllTemplateAnObjCol() {
        QFilter qFilter = new QFilter("objecttype", "=", (Object)"template").and(new QFilter("enable", "=", (Object)"1"));
        return this.analyseObjectHelper.queryOriginalCollection("id, name, number, description", new QFilter[]{qFilter}, "createtime desc");
    }

    public List<TempAnObjFieldBo> getAllTemplateAnObjFieldCol(long anObjId) {
        ArrayList allFields = Lists.newArrayListWithCapacity((int)10);
        List<QueryFieldBo> queryFieldBos = AnalyseObjectService.getInstance().queryAndAssembleQueryFields(anObjId);
        List<CalculateFieldBo> calculateFieldBos = CalculateFieldService.getInstance().loadCalFieldsByAnObjIdForBo(anObjId, false);
        List<PivotIndexFieldBo> analysePivotIndexes = AnalyseObjectService.getInstance().getAnalysePivotIndexes(anObjId, queryFieldBos, calculateFieldBos, true);
        List<AnObjGroupField> groupFields = AnObjGroupFieldService.getInstance().getGroupFields(anObjId, queryFieldBos);
        queryFieldBos.forEach(queryFieldBo -> {
            TempAnObjFieldBo tempAnObjFieldBo = new TempAnObjFieldBo();
            tempAnObjFieldBo.setNumber(queryFieldBo.getFieldAlias());
            tempAnObjFieldBo.setName(queryFieldBo.getFieldName().getLocaleValue());
            tempAnObjFieldBo.setType(queryFieldBo.getValueType());
            allFields.add(tempAnObjFieldBo);
        });
        calculateFieldBos.forEach(calculateFieldBo -> {
            TempAnObjFieldBo tempAnObjFieldBo = new TempAnObjFieldBo();
            tempAnObjFieldBo.setNumber(calculateFieldBo.getFieldNumber());
            tempAnObjFieldBo.setName(calculateFieldBo.getFieldName().getLocaleValue());
            tempAnObjFieldBo.setType(calculateFieldBo.getValueType());
            allFields.add(tempAnObjFieldBo);
        });
        analysePivotIndexes.forEach(pivotIndexBo -> {
            TempAnObjFieldBo tempAnObjFieldBo = new TempAnObjFieldBo();
            tempAnObjFieldBo.setNumber(pivotIndexBo.getFieldAlias());
            tempAnObjFieldBo.setName(pivotIndexBo.getFieldName().getLocaleValue());
            tempAnObjFieldBo.setType(pivotIndexBo.getValueType());
            allFields.add(tempAnObjFieldBo);
        });
        groupFields.forEach(groupFieldBo -> {
            TempAnObjFieldBo tempAnObjFieldBo = new TempAnObjFieldBo();
            tempAnObjFieldBo.setNumber(groupFieldBo.getNumber());
            tempAnObjFieldBo.setName(groupFieldBo.getName().getLocaleValue());
            tempAnObjFieldBo.setType(DataTypeEnum.STRING.getDataTypeKey());
            allFields.add(tempAnObjFieldBo);
        });
        return allFields;
    }
}

