/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.anobj;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.formula.excel.Expr;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.function.service.ReportFunctionExecuteService;
import kd.hr.hbp.business.service.complexobj.RptLRUCache;
import kd.hr.hbp.business.service.complexobj.util.AlgoDataTypeTransUtil;
import kd.hr.hbp.business.service.complexobj.util.ReportFunctionExecuteByCache;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.common.DataSetTransUtil;
import kd.hr.hrptmc.business.repcalculate.CalculateContext;
import kd.hr.hrptmc.business.repcalculate.RepCalculateService;
import kd.hr.hrptmc.business.repcalculate.algo.AnObjPivotMapFunction;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repdesign.field.AggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.AnObjFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.IndexFieldInfo;

public class AnalyseObjectPivotService {
    private static final Log LOGGER = LogFactory.getLog(AnalyseObjectPivotService.class);
    private final RptLRUCache<String, Object> lruCache = new RptLRUCache(1000);
    private List<FieldInfo> pivotIndexes;
    private final List<IndexFieldInfo> refPivotIndexes;
    private List<IndexFieldInfo> transIndexFieldInfoList;
    private final Set<String> fromReportAggregateCalNumList;
    private final List<ReportField> fromReportAggregateCalList;
    private final Set<String> presetIndexNumList;
    private final List<ReportField> presetIndexList;
    private final List<ReportField> dependPivotFields;
    private final RepCalculateService service;
    private final ReportFunctionExecuteByCache reportFunctionExecuteByCache;

    public AnalyseObjectPivotService(RepCalculateService service, List<FieldInfo> pivotIndexes, List<IndexFieldInfo> refPivotIndexes, List<IndexFieldInfo> transIndexFieldInfoList, List<ReportField> fromReportCalList, List<ReportField> presetIndexList, List<ReportField> dependPivotFields) {
        this.service = service;
        this.pivotIndexes = pivotIndexes;
        this.refPivotIndexes = refPivotIndexes;
        this.transIndexFieldInfoList = transIndexFieldInfoList;
        this.fromReportAggregateCalList = fromReportCalList.stream().filter(field -> field instanceof AggregateIndexField).collect(Collectors.toList());
        this.fromReportAggregateCalNumList = fromReportCalList.stream().filter(field -> field instanceof AggregateIndexField).map(ReportField::getFieldAlias).collect(Collectors.toSet());
        this.presetIndexList = presetIndexList;
        this.presetIndexNumList = presetIndexList.stream().map(ReportField::getFieldAlias).collect(Collectors.toSet());
        this.dependPivotFields = dependPivotFields;
        this.reportFunctionExecuteByCache = new ReportFunctionExecuteByCache(service.getGlobalContext().getComplexObjContext(), service.getGlobalContext().getComplexObjContext().getComplexObjFieldInfoList());
    }

    public DataSet queryAnObjPivotDataset(int start, int limit) {
        this.beforeQuery();
        DataSet dataSet = this.service.calculate(start, limit);
        return this.afterQuery(dataSet);
    }

    private void beforeQuery() {
        this.service.getCalculateInfo().setAnObjPivot(true);
        this.removeFromReportCalculateField();
        this.removePresetIndex();
        HRComplexObjContext complexObjContext = this.service.getGlobalContext().getComplexObjContext();
        CalculateContext calculateContext = new CalculateContext(this.service.getCalculateInfo(), complexObjContext);
        this.service.setGlobalContext(calculateContext);
    }

    private DataSet afterQuery(DataSet dataSet) {
        dataSet = this.transferAnObjPivotDataset(dataSet);
        this.addPresetIndex();
        return this.calculateAggregateCalFromReport(dataSet);
    }

    private void removeFromReportCalculateField() {
        List<ReportField> rowFieldList = this.service.getCalculateInfo().getRowFieldList();
        rowFieldList.removeIf(field -> this.fromReportAggregateCalNumList.contains(field.getFieldAlias()));
    }

    private void removePresetIndex() {
        List<ReportField> rowFieldList = this.service.getCalculateInfo().getRowFieldList();
        rowFieldList.removeIf(field -> this.presetIndexNumList.contains(field.getFieldAlias()));
    }

    private void addPresetIndex() {
        List<ReportField> rowFieldList = this.service.getCalculateInfo().getRowFieldList();
        rowFieldList.addAll(this.presetIndexList);
    }

    private DataSet calculateAggregateCalFromReport(DataSet dataSet) {
        AggregateIndexField reportField;
        LOGGER.info("AnalyseObjectPivotService_fromReportAggregateCalList: {}", this.fromReportAggregateCalList);
        if (this.fromReportAggregateCalList == null || this.fromReportAggregateCalList.isEmpty()) {
            return dataSet;
        }
        ArrayList<Field> queryFieldList = new ArrayList<Field>(Arrays.asList(dataSet.getRowMeta().getFields()));
        List<Map<String, Object>> dataList = DataSetTransUtil.dataSetToList(dataSet);
        for (ReportField rptf : this.fromReportAggregateCalList) {
            reportField = (AggregateIndexField)rptf;
            this.setCalFieldVal(dataList, reportField);
        }
        for (ReportField rptf : this.fromReportAggregateCalList) {
            reportField = (AggregateIndexField)rptf;
            Field field = new Field(reportField.getUniqueKey(), AlgoDataTypeTransUtil.getDataType((String)reportField.getFieldType()));
            queryFieldList.add(field);
        }
        for (ReportField dependPivotField : this.dependPivotFields) {
            this.setPivotDataVal(dataList, dependPivotField);
        }
        for (ReportField dependPivotField : this.dependPivotFields) {
            Field field = new Field(dependPivotField.getFieldAlias(), AlgoDataTypeTransUtil.getDataType((String)dependPivotField.getFieldType()));
            queryFieldList.add(field);
        }
        return DataSetTransUtil.listToDataset(dataList, queryFieldList);
    }

    private void setCalFieldVal(List<Map<String, Object>> dataList, AggregateIndexField reportField) {
        String formula = reportField.getCalcFormulaInfo();
        String alias = reportField.getUniqueKey();
        Expr expr = ReportFunctionExecuteService.getInstance().parseExpr(formula);
        Set<String> refFieldAliasSet = reportField.getDependentFieldSet();
        for (Map<String, Object> dataMap : dataList) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            for (String key : refFieldAliasSet) {
                Optional<String> fieldAlias = dataMap.keySet().stream().filter(fieldKey -> {
                    if (fieldKey.contains("\u03b4")) {
                        return HRStringUtils.equals((String)fieldKey.split("\u03b4")[0], (String)key);
                    }
                    return HRStringUtils.equals((String)fieldKey, (String)key);
                }).findAny();
                if (fieldAlias.isPresent()) {
                    paramMap.putIfAbsent(key, dataMap.get(fieldAlias.get()));
                    continue;
                }
                paramMap.putIfAbsent(key, null);
            }
            Object val = this.reportFunctionExecuteByCache.getFormulaVal(this.lruCache, formula, expr, paramMap);
            dataMap.put(alias, val);
        }
    }

    private void setPivotDataVal(List<Map<String, Object>> dataList, ReportField reportField) {
        Map<String, String> pivotMap = this.pivotIndexes.stream().collect(Collectors.toMap(FieldInfo::getNumber, FieldInfo::getNumberAlias, (k1, k2) -> k1));
        for (Map<String, Object> dataMap : dataList) {
            String fieldAlias = reportField.getFieldAlias();
            String numberAlias = pivotMap.get(fieldAlias);
            Object value = dataMap.get(numberAlias);
            dataMap.put(fieldAlias, value);
        }
    }

    private DataSet transferAnObjPivotDataset(DataSet dataset) {
        Map<String, List<FieldInfo>> pivotIndexMap = this.pivotIndexes.stream().collect(Collectors.groupingBy(FieldInfo::getNumber));
        Map<String, List<IndexFieldInfo>> refPivotIndexMap = this.refPivotIndexes.stream().collect(Collectors.groupingBy(AnObjFieldInfo::getFieldAlias));
        ReportCalculateInfo calculateInfo = this.service.getCalculateInfo();
        dataset = dataset.map((MapFunction)new AnObjPivotMapFunction(this.transIndexFieldInfoList, pivotIndexMap, refPivotIndexMap, dataset.getRowMeta(), calculateInfo));
        dataset.copy();
        return dataset;
    }

    public List<FieldInfo> getPivotIndexes() {
        return this.pivotIndexes;
    }

    public void setPivotIndexes(List<FieldInfo> pivotIndexes) {
        this.pivotIndexes = pivotIndexes;
    }

    public List<IndexFieldInfo> getTransIndexFieldInfoList() {
        return this.transIndexFieldInfoList;
    }

    public void setTransIndexFieldInfoList(List<IndexFieldInfo> transIndexFieldInfoList) {
        this.transIndexFieldInfoList = transIndexFieldInfoList;
    }
}

