/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.anobj;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.service.labelandreport.HRFilterUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinConditionBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinEntityCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnObjEnumFieldHandler;
import kd.hr.hrptmc.business.anobj.AnObjGroupFieldService;
import kd.hr.hrptmc.business.calfield.CalculateFieldService;
import kd.hr.hrptmc.business.common.DateTimeFieldTimeZoneUtil;
import kd.hr.hrptmc.business.repcalculate.model.RepQueryConfigBo;
import kd.hr.hrptmc.business.repdesign.ReportManageService;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.common.constant.anobj.AnalyseObjectConstants;
import kd.hr.hrptmc.common.model.anobj.AnObjPivotBo;
import kd.hr.hrptmc.common.model.anobj.EntityRelationBo;
import kd.hr.hrptmc.common.model.anobj.JoinEntityBo;
import kd.hr.hrptmc.common.model.anobj.PivotIndexFieldBo;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;
import kd.hr.hrptmc.common.util.ReportComplexObjTransferUtil;

public class AnalyseObjectService
implements AnalyseObjectConstants {
    private static final Log LOGGER = LogFactory.getLog(AnalyseObjectService.class);
    private final HRBaseServiceHelper analyseObjectHelper = new HRBaseServiceHelper("hrptmc_analyseobject");
    private final HRBaseServiceHelper joinEntityHelper = new HRBaseServiceHelper("hrptmc_anobjjoinentity");
    private final HRBaseServiceHelper queryFieldHelper = new HRBaseServiceHelper("hrptmc_anobjqueryfield");
    private final HRBaseServiceHelper entityRelationHelper = new HRBaseServiceHelper("hrptmc_anobjentityrel");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^[0-9]");
    private final HRBaseServiceHelper pivotHelper = new HRBaseServiceHelper("hrptmc_anobjpivot");
    private static volatile AnalyseObjectService service = null;

    private AnalyseObjectService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AnalyseObjectService getInstance() {
        if (service != null) return service;
        Class<AnalyseObjectService> clazz = AnalyseObjectService.class;
        synchronized (AnalyseObjectService.class) {
            if (service != null) return service;
            service = new AnalyseObjectService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public Map<String, Long> queryFieldIdByFieldAlias(long reportId, List<String> fieldAliasList) {
        Long anObjId = ReportManageService.getAnObjId(reportId);
        DynamicObjectCollection fieldDys = this.queryFieldHelper.queryOriginalCollection("id, fieldalias", new QFilter[]{new QFilter("fieldalias", "in", fieldAliasList), new QFilter("anobj", "=", (Object)anObjId)});
        return fieldDys.stream().collect(Collectors.toMap(field -> field.getString("fieldalias"), field -> field.getLong("id")));
    }

    public Map<String, Long> queryAdminOrgFieldIdByFieldAlias(long reportId, List<String> fieldAliasList) {
        Long anObjId = ReportManageService.getAnObjId(reportId);
        DynamicObjectCollection fieldDys = this.queryFieldHelper.queryOriginalCollection("id, fieldalias", new QFilter[]{new QFilter("fieldalias", "in", fieldAliasList), new QFilter("complextype", "=", (Object)FieldComplexType.ADMIN_ORG.getValue()), new QFilter("anobj", "=", (Object)anObjId)});
        return fieldDys.stream().collect(Collectors.toMap(field -> field.getString("fieldalias"), field -> field.getLong("id")));
    }

    public void removeRefByReportFieldAliasCache(Long anObjId) {
        if (anObjId != null && anObjId != 0L) {
            IAppCache appCache = AppCache.get((String)"hrptmc");
            appCache.remove("AnObjFieldRefByReport#" + anObjId);
        }
    }

    public Set<String> getRefByReportFieldAliasCollection(Long anObjId) {
        Set refFields = Sets.newHashSetWithExpectedSize((int)16);
        if (anObjId == null || anObjId == 0L) {
            return refFields;
        }
        IAppCache appCache = AppCache.get((String)"hrptmc");
        refFields = (Set)appCache.get("AnObjFieldRefByReport#" + anObjId, Set.class);
        if (refFields != null) {
            return refFields;
        }
        Set<String> refByReportFieldAliasList = this.getRefByReportFieldAliasList(anObjId);
        appCache.put("AnObjFieldRefByReport#" + anObjId, refByReportFieldAliasList);
        return refByReportFieldAliasList;
    }

    public DynamicObject loadAnObjDy(Long anObjId) {
        return this.analyseObjectHelper.loadSingle((Object)anObjId);
    }

    public DynamicObject getAnObjDy(Long anObjId) {
        QFilter qFilter = new QFilter("id", "=", (Object)anObjId);
        return this.analyseObjectHelper.queryOriginalOne("name,number,objecttype", new QFilter[]{qFilter});
    }

    public DynamicObject getAnObjDy(String number) {
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        return this.analyseObjectHelper.queryOne("id,name,number", new QFilter[]{qFilter});
    }

    public DynamicObject getAnObjDyByName(String name) {
        QFilter qFilter = new QFilter("name", "=", (Object)name);
        return this.analyseObjectHelper.queryOriginalOne("id,name,number,objecttype", new QFilter[]{qFilter});
    }

    public DynamicObjectCollection getAnObjDysStartWithName(String prefix, String suffix) {
        QFilter qFilter = new QFilter("name", "like", (Object)(prefix + "%" + suffix));
        return this.analyseObjectHelper.queryOriginalCollection("id,name,number,objecttype", new QFilter[]{qFilter}, "name DESC");
    }

    public Long getAnObjId(long anObjFieldId) {
        QFilter qFilter = new QFilter("id", "=", (Object)anObjFieldId);
        DynamicObject fieldDy = this.queryFieldHelper.queryOriginalOne("anobj", new QFilter[]{qFilter});
        if (fieldDy == null) {
            return null;
        }
        return fieldDy.getLong("anobj");
    }

    public boolean isAnObjExist(String name) {
        QFilter qFilter = new QFilter("name", "=", (Object)name);
        return this.analyseObjectHelper.isExists(qFilter);
    }

    public DynamicObject[] loadJoinEntities(Long anObjId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("anobj", "=", (Object)anObjId)};
        return this.joinEntityHelper.loadDynamicObjectArray(qFilters);
    }

    public DynamicObject[] loadQueryFields(Long anObjId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("anobj", "=", (Object)anObjId)};
        return this.queryFieldHelper.loadDynamicObjectArray(qFilters);
    }

    public boolean isVirtualEntityAnObj(Long anObjId) {
        DynamicObject anObjDy = this.analyseObjectHelper.queryOriginalOne("objecttype", (Object)anObjId);
        return this.isVirtualEntityAnObj(anObjDy.getString("objecttype"));
    }

    public boolean isVirtualEntityAnObj(String objectType) {
        return HRStringUtils.equals((String)objectType, (String)"virtualentity") || HRStringUtils.equals((String)objectType, (String)"filesource");
    }

    public boolean isFileSourceAnObj(Long anObjId) {
        DynamicObject anObjDy = this.analyseObjectHelper.queryOriginalOne("objecttype", (Object)anObjId);
        return anObjDy != null && HRStringUtils.equals((String)anObjDy.getString("objecttype"), (String)"filesource");
    }

    public boolean isFileSourceAnObjs(Set<Long> anObjIds) {
        DynamicObjectCollection anObjDys = this.analyseObjectHelper.queryOriginalCollection("objecttype", new QFilter[]{new QFilter("id", "in", anObjIds)});
        return anObjDys.stream().anyMatch(anObjDy -> HRStringUtils.equals((String)"filesource", (String)anObjDy.getString("objecttype")));
    }

    public String getMainEntityNumber(Long anObjId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("anobj", "=", (Object)anObjId), new QFilter("type", "=", (Object)"main")};
        DynamicObject dy = this.joinEntityHelper.queryOriginalOne("entitynumber", qFilters);
        return dy.getString("entitynumber");
    }

    public DynamicObjectCollection queryFieldDimCount(Long anObjId, Set<String> fieldAlias) {
        QFilter qFilter = new QFilter("anobj", "=", (Object)anObjId);
        QFilter qFilter2 = new QFilter("fieldalias", "in", fieldAlias);
        return this.queryFieldHelper.queryOriginalCollection("id, fieldalias, dimcount.dimcount, dimcount.isbigdatatable", new QFilter[]{qFilter, qFilter2});
    }

    public DynamicObject[] loadEntityRelations(Long anObjId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("anobj", "=", (Object)anObjId)};
        return this.entityRelationHelper.loadDynamicObjectArray(qFilters);
    }

    public List<JoinEntityBo> queryAndAssembleJoinEntities(Long anObjId) {
        DynamicObject[] joinEntityCol = this.loadJoinEntities(anObjId);
        boolean virtualEntityAnObj = AnalyseObjectService.getInstance().isVirtualEntityAnObj(anObjId);
        ArrayList joinEntities = Lists.newArrayListWithCapacity((int)joinEntityCol.length);
        Map<Object, Object> entityNumMap = Maps.newHashMapWithExpectedSize((int)16);
        if (!virtualEntityAnObj) {
            Set set = Arrays.stream(joinEntityCol).map(dy -> dy.getString("entitynumber")).collect(Collectors.toSet());
            HRBaseServiceHelper entityHelper = new HRBaseServiceHelper("bos_entityobject");
            DynamicObjectCollection entityDys = entityHelper.queryOriginalCollection("number, name", new QFilter[]{new QFilter("number", "in", set)});
            entityNumMap = entityDys.stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getString("name")));
        }
        for (DynamicObject joinEntityDy : joinEntityCol) {
            JoinEntityBo joinEntity = new JoinEntityBo();
            joinEntity.setId(joinEntityDy.getString("id"));
            joinEntity.setAnObjId(joinEntityDy.getDynamicObject("anobj").getString("id"));
            String type = joinEntityDy.getString("type");
            String longNumber = joinEntityDy.getString("longnumber");
            if (HRStringUtils.isEmpty((String)longNumber)) {
                if (HRStringUtils.equals((String)type, (String)"main")) {
                    joinEntity.setLongNumber("0");
                } else {
                    int index = joinEntityDy.getInt("index");
                    joinEntity.setLongNumber("0!" + index);
                }
            } else {
                joinEntity.setLongNumber(joinEntityDy.getString("longnumber"));
            }
            longNumber = joinEntity.getLongNumber();
            if (longNumber.contains("!")) {
                joinEntity.setParentLongNumber(longNumber.substring(0, longNumber.lastIndexOf("!")));
            } else {
                joinEntity.setParentLongNumber(null);
            }
            if (HRStringUtils.equals((String)longNumber, (String)"0")) {
                joinEntity.setLevel(Integer.valueOf(0));
            } else {
                String[] longNumberSp = longNumber.split("!");
                joinEntity.setLevel(Integer.valueOf(longNumberSp.length - 1));
            }
            joinEntity.setEntityNumber(joinEntityDy.getString("entitynumber"));
            joinEntity.setEntityAlias(joinEntityDy.getString("entityalias"));
            joinEntity.setType(joinEntityDy.getString("type"));
            joinEntity.setVirtualEntity(virtualEntityAnObj);
            if (!virtualEntityAnObj) {
                String entityName = (String)entityNumMap.get(joinEntity.getEntityNumber());
                String[] split = joinEntity.getEntityAlias().split("\u03b4");
                if (split.length > 1) {
                    joinEntity.setDisplayName(entityName + split[1]);
                } else {
                    joinEntity.setDisplayName(entityName);
                }
            }
            joinEntities.add(joinEntity);
        }
        if (virtualEntityAnObj) {
            HRBaseServiceHelper hRBaseServiceHelper = new HRBaseServiceHelper("hrptmc_virtualentity");
            DynamicObject virtualEntityDy = hRBaseServiceHelper.queryOriginalOne("name", new QFilter[]{new QFilter("number", "=", (Object)((JoinEntityBo)joinEntities.get(0)).getEntityNumber())});
            String entityName = virtualEntityDy.getString("name");
            ((JoinEntityBo)joinEntities.get(0)).setDisplayName(entityName);
        }
        return joinEntities.stream().sorted(Comparator.comparing(JoinEntityCommonBo::getLongNumber)).collect(Collectors.toList());
    }

    public List<QueryFieldBo> queryAndAssembleQueryFields(Collection<Long> queryFieldIds) {
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", queryFieldIds)};
        DynamicObject[] queryFieldCol = this.queryFieldHelper.loadDynamicObjectArray(qFilters);
        return this.assembleQueryFields(queryFieldCol);
    }

    public List<QueryFieldBo> queryAndAssembleQueryFields(Long anObjId) {
        DynamicObject[] queryFieldCol = this.loadQueryFields(anObjId);
        List<QueryFieldBo> queryFieldBos = this.assembleQueryFields(queryFieldCol);
        if (queryFieldBos.isEmpty()) {
            return queryFieldBos;
        }
        if (queryFieldBos.get(0).isVirtualEntityField()) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_virtualentity");
            DynamicObject dy = helper.queryOriginalOne("name", new QFilter[]{new QFilter("number", "=", (Object)queryFieldBos.get(0).getEntityNumber())});
            String entityName = dy.getString("name");
            queryFieldBos.forEach(field -> field.setEntityName(entityName));
        }
        return queryFieldBos;
    }

    public List<QueryFieldBo> assembleQueryFields(DynamicObject[] queryFieldCol) {
        ArrayList queryFields = Lists.newArrayListWithCapacity((int)queryFieldCol.length);
        MainEntityTypeUtil entityTypeUtil = new MainEntityTypeUtil();
        HRBaseServiceHelper entityHelper = new HRBaseServiceHelper("bos_entityobject");
        Set entityNums = Arrays.stream(queryFieldCol).map(dy -> dy.getString("entitynumber")).collect(Collectors.toSet());
        DynamicObjectCollection entityDys = entityHelper.queryOriginalCollection("number, name", new QFilter[]{new QFilter("number", "in", entityNums)});
        Map<String, String> entityNumMap = entityDys.stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getString("name")));
        for (DynamicObject queryFieldDy : queryFieldCol) {
            Map baseDataNumAndPkType;
            QueryFieldBo queryField = new QueryFieldBo();
            queryField.setId(queryFieldDy.getString("id"));
            queryField.setAnObjId(queryFieldDy.getDynamicObject("anobj").getString("id"));
            String entityNumber = queryFieldDy.getString("entitynumber");
            queryField.setEntityNumber(entityNumber);
            queryField.setVirtualEntityField(queryFieldDy.getBoolean("isvirtualfield"));
            String fieldAlias = queryFieldDy.getString("fieldalias");
            if (!queryField.isVirtualEntityField()) {
                String nameSuffix = "";
                if (fieldAlias.contains("\u03b4")) {
                    nameSuffix = fieldAlias.substring(fieldAlias.indexOf(948), fieldAlias.indexOf(46));
                }
                String entityName = entityNumMap.get(entityNumber);
                entityName = entityName + nameSuffix;
                queryField.setEntityName(entityName);
            }
            OrmLocaleValue fieldName = (OrmLocaleValue)queryFieldDy.getLocaleString("fieldname");
            queryField.setFieldName(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)fieldName));
            queryField.setFieldAlias(fieldAlias);
            queryField.setFieldPath(queryFieldDy.getString("fieldpath"));
            String complexType = queryFieldDy.getString("complextype");
            queryField.setComplexType(complexType);
            queryField.setValueType(queryFieldDy.getString("valuetype"));
            queryField.setControlType(queryFieldDy.getString("controltype"));
            if (queryField.isVirtualEntityField()) {
                queryField.setFieldNumber(queryField.getFieldAlias());
                if (AnalyseObjectUtil.isBaseDataType((String)complexType)) {
                    baseDataNumAndPkType = AnalyseObjectUtil.parseFieldAliasGetBaseDataNumAndPkType((String)queryField.getFieldPath().split("\\.")[0], (String)queryField.getFieldPath(), (MainEntityTypeUtil)entityTypeUtil);
                    queryField.setBaseDataNum((String)baseDataNumAndPkType.get("baseDataNum"));
                    queryField.setBaseDataIdType((String)baseDataNumAndPkType.get("pkType"));
                } else {
                    queryField.setBaseDataNum(queryField.getFieldPath().split("\\.")[0]);
                }
            } else {
                queryField.setFieldNumber(this.getFieldShortNumber(entityNumber, fieldAlias, complexType, entityTypeUtil));
                if (AnalyseObjectUtil.isBaseDataType((String)complexType)) {
                    baseDataNumAndPkType = AnalyseObjectUtil.parseFieldAliasGetBaseDataNumAndPkType((String)entityNumber, (String)fieldAlias, (MainEntityTypeUtil)entityTypeUtil);
                    queryField.setBaseDataNum((String)baseDataNumAndPkType.get("baseDataNum"));
                    queryField.setBaseDataIdType((String)baseDataNumAndPkType.get("pkType"));
                }
                if (AnalyseObjectUtil.isEnumType((String)queryField.getControlType())) {
                    AnObjEnumFieldHandler anObjEnumFieldHandler = new AnObjEnumFieldHandler(queryFieldDy.getDynamicObject("anobj"), entityTypeUtil);
                    List<AnObjEnumFieldHandler.AnObjEnumItem> enumItems = anObjEnumFieldHandler.getEnumItems((QueryFieldCommonBo)queryField);
                    ArrayList comboItems = Lists.newArrayListWithCapacity((int)enumItems.size());
                    for (AnObjEnumFieldHandler.AnObjEnumItem enumItem : enumItems) {
                        ValueMapItem comboItem = new ValueMapItem("", enumItem.getValue(), enumItem.getName());
                        comboItems.add(comboItem);
                    }
                    queryField.setData(SerializationUtils.toJsonString((Object)comboItems));
                }
            }
            DynamicObject dimCountDy = queryFieldDy.getDynamicObject("dimcount");
            if (dimCountDy != null) {
                queryField.setDimCount(Integer.valueOf(dimCountDy.getInt("dimcount")));
            } else {
                queryField.setDimCount(Integer.valueOf(0));
            }
            queryField.setStoreField(queryFieldDy.getString("storefield"));
            queryFields.add(queryField);
        }
        DateTimeFieldTimeZoneUtil.buildTimeZoneInfoIntoQueryField(queryFields, entityTypeUtil);
        return queryFields;
    }

    public List<EntityRelationBo> queryAndAssembleEntityRelations(Long anObjId) {
        DynamicObject[] entityRelationCol = this.loadEntityRelations(anObjId);
        ArrayList entityRelations = Lists.newArrayListWithCapacity((int)entityRelationCol.length);
        for (DynamicObject entityRelationDy : entityRelationCol) {
            EntityRelationBo entityRelation = new EntityRelationBo();
            DynamicObject entityDy = entityRelationDy.getDynamicObject("entityid");
            DynamicObject joinEntityDy = entityRelationDy.getDynamicObject("joinentityid");
            entityRelation.setId(entityRelationDy.getString("id"));
            entityRelation.setAnObjId(entityRelationDy.getDynamicObject("anobj").getString("id"));
            entityRelation.setEntityId(entityDy.getString("id"));
            entityRelation.setEntityNumber(entityDy.getString("entitynumber"));
            entityRelation.setEntityAlias(entityDy.getString("entityalias"));
            entityRelation.setJoinType(entityRelationDy.getString("jointype"));
            entityRelation.setJoinEntityId(joinEntityDy.getString("id"));
            entityRelation.setJoinEntityNumber(joinEntityDy.getString("entitynumber"));
            entityRelation.setJoinEntityAlias(joinEntityDy.getString("entityalias"));
            DynamicObjectCollection joinConditionCol = entityRelationDy.getDynamicObjectCollection("joinconditions");
            if (joinConditionCol.isEmpty()) {
                throw new KDBizException("analyse object join conditions is empty.");
            }
            ArrayList joinConditions = Lists.newArrayListWithCapacity((int)joinConditionCol.size());
            for (DynamicObject joinConditionDy : joinConditionCol) {
                JoinConditionBo joinCondition = new JoinConditionBo();
                joinCondition.setId(joinConditionDy.getString("id"));
                joinCondition.setLeftProp(joinConditionDy.getString("leftprop"));
                joinCondition.setCompareType(joinConditionDy.getString("comparetype"));
                String rightPropType = joinConditionDy.getString("rightproptype");
                joinCondition.setRightPropType(rightPropType);
                if (HRStringUtils.equals((String)rightPropType, (String)"field")) {
                    joinCondition.setRightProp(joinConditionDy.getString("rightprop"));
                } else {
                    joinCondition.setRightPropVal(joinConditionDy.getString("rightpropval"));
                }
                joinCondition.setLogicType(joinConditionDy.getString("logictype"));
                joinConditions.add(joinCondition);
            }
            entityRelation.setConditions((List)joinConditions);
            entityRelations.add(entityRelation);
        }
        return entityRelations;
    }

    public HRComplexObjContext getComplexObjContext(Long anObjId) {
        List<JoinEntityBo> joinEntityBos = this.queryAndAssembleJoinEntities(anObjId);
        List<QueryFieldBo> queryFieldBos = this.queryAndAssembleQueryFields(anObjId);
        List<EntityRelationBo> entityRelationBos = this.queryAndAssembleEntityRelations(anObjId);
        List<CalculateFieldBo> calculateFieldBos = CalculateFieldService.getInstance().loadCalFieldsByAnObjIdForBo(anObjId, false);
        List<QFilter> qFilters = this.getQueryQFilter(anObjId, queryFieldBos);
        return ReportComplexObjTransferUtil.transferToComplexObjContext(joinEntityBos, queryFieldBos, entityRelationBos, calculateFieldBos, qFilters);
    }

    public HRComplexObjContext getComplexObjContextNoQueryField(Long anObjId) {
        List<JoinEntityBo> joinEntityBos = this.queryAndAssembleJoinEntities(anObjId);
        List<EntityRelationBo> entityRelationBos = this.queryAndAssembleEntityRelations(anObjId);
        List<QueryFieldBo> queryFieldBos = this.queryAndAssembleQueryFields(anObjId);
        List<QFilter> qFilters = this.getQueryQFilter(anObjId, queryFieldBos);
        return ReportComplexObjTransferUtil.transferToComplexObjContext(joinEntityBos, Collections.emptyList(), entityRelationBos, Collections.emptyList(), qFilters);
    }

    public List<QFilter> getQueryQFilter(Long anObjId, List<QueryFieldBo> queryFieldBos) {
        QFilter qFilter;
        String dataFilter;
        DynamicObject anObj = this.analyseObjectHelper.queryOne("datafilter", new QFilter[]{new QFilter("id", "=", (Object)anObjId)});
        ArrayList qFilters = Lists.newArrayListWithCapacity((int)10);
        if (anObj != null && HRStringUtils.isNotEmpty((String)(dataFilter = anObj.getString("datafilter"))) && (qFilter = HRFilterUtil.condition2QFilter4HRReport((String)dataFilter, (String)SerializationUtils.toJsonString(queryFieldBos))) != null) {
            qFilters.add(qFilter);
        }
        return qFilters;
    }

    public boolean isAnObjRefByReport(Long anObjId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_reportmanage");
        return helper.isExists(new QFilter("anobjid", "=", (Object)anObjId));
    }

    public DynamicObject[] queryAnObjPivotDys(long anObjId) {
        return this.pivotHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("anobj", "=", (Object)anObjId)});
    }

    public Set<String> getRefReportUseFieldAliasList(Long anObjId) {
        HashSet aliasSet = Sets.newHashSetWithExpectedSize((int)16);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_reportmanage");
        DynamicObject[] reportDys = helper.query("number, row, column, rptfilter, datafilter", new QFilter[]{new QFilter("anobjid", "=", (Object)anObjId)});
        if (reportDys == null || reportDys.length == 0) {
            return aliasSet;
        }
        DynamicObjectCollection queryFieldDys = this.queryFieldHelper.queryOriginalCollection("id,fieldalias,fieldpath,entitynumber", new QFilter[]{new QFilter("anobj", "=", (Object)anObjId)});
        this.getRowColFilterRefFields(aliasSet, reportDys, queryFieldDys, new DynamicObjectCollection());
        return aliasSet;
    }

    public Set<String> getRefByReportFieldAliasList(Long anObjId) {
        HashSet aliasSet = Sets.newHashSetWithExpectedSize((int)16);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_reportmanage");
        DynamicObject[] reportDys = helper.query("number, row, column, rptfilter, datafilter", new QFilter[]{new QFilter("anobjid", "=", (Object)anObjId)});
        HRBaseServiceHelper preIndexHelper = new HRBaseServiceHelper("hrptmc_preindex");
        DynamicObjectCollection preIndexDys = preIndexHelper.queryOriginalCollection("target", new QFilter[]{new QFilter("anobj", "=", (Object)anObjId)});
        for (DynamicObject preIndexDy : preIndexDys) {
            String index = preIndexDy.getString("target");
            aliasSet.add(index);
        }
        if (reportDys == null || reportDys.length == 0) {
            return aliasSet;
        }
        DynamicObjectCollection queryFieldDys = this.queryFieldHelper.queryOriginalCollection("id,fieldalias,fieldpath,entitynumber", new QFilter[]{new QFilter("anobj", "=", (Object)anObjId)});
        DynamicObjectCollection groupFieldDys = AnObjGroupFieldService.getInstance().getGroupFieldDys(anObjId);
        Set<Long> reportIds = Arrays.stream(reportDys).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        HashSet reportCalAndPresetFields = Sets.newHashSetWithExpectedSize((int)16);
        DynamicObject[] calFieldDys = CalculateFieldService.getInstance().loadCalFieldByReportIds(reportIds);
        HRBaseServiceHelper presetIndexHelper = new HRBaseServiceHelper("hrptmc_reportpreindex");
        DynamicObject[] preIndexes = presetIndexHelper.query("preindex", new QFilter[]{new QFilter("report", "in", reportIds)});
        Set preIndexNums = Arrays.stream(preIndexes).map(dy -> dy.getDynamicObject("preindex").getString("number")).collect(Collectors.toSet());
        reportCalAndPresetFields.addAll(preIndexNums);
        for (DynamicObject calFieldDy : calFieldDys) {
            if (HRStringUtils.equals((String)calFieldDy.getString("source"), (String)"report")) {
                reportCalAndPresetFields.add(calFieldDy.getString("number"));
            }
            DynamicObjectCollection refFieldEntry = calFieldDy.getDynamicObjectCollection("reffieldentry");
            for (DynamicObject refFieldDy : refFieldEntry) {
                String refType = refFieldDy.getString("reftype");
                if (HRStringUtils.equals((String)refType, (String)"entityfield")) {
                    aliasSet.add(refFieldDy.getString("reffieldalias"));
                    continue;
                }
                if (HRStringUtils.equals((String)refType, (String)"calfield")) {
                    aliasSet.add(refFieldDy.getDynamicObject("refcalfield").getString("number"));
                    continue;
                }
                if (!HRStringUtils.equals((String)refType, (String)"groupfield")) continue;
                aliasSet.add(refFieldDy.getString("reffieldalias"));
            }
        }
        this.getRowColFilterRefFields(aliasSet, reportDys, queryFieldDys, groupFieldDys);
        aliasSet.removeAll(reportCalAndPresetFields);
        return aliasSet;
    }

    private void getRowColFilterRefFields(Set<String> aliasSet, DynamicObject[] reportDys, DynamicObjectCollection queryFieldDys, DynamicObjectCollection groupFieldDys) {
        Set reportIds = Arrays.stream(reportDys).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        for (DynamicObject reportDy : reportDys) {
            try {
                String row = reportDy.getString("row");
                String column = reportDy.getString("column");
                String dataFilter = reportDy.getString("datafilter");
                if (HRStringUtils.isNotEmpty((String)row)) {
                    List rows = JSON.parseArray((String)row, RowFieldInfo.class);
                    for (RowFieldInfo rowFieldInfo : rows) {
                        if (!HRStringUtils.equals((String)rowFieldInfo.getMergeType(), (String)"1")) {
                            aliasSet.add(rowFieldInfo.getGroupName().getNumber());
                        }
                        ReportManageService.recursive(rowFieldInfo._getChildFields(), field -> aliasSet.add(field.getNumber()));
                    }
                }
                if (HRStringUtils.isNotEmpty((String)column)) {
                    List columns = JSON.parseArray((String)column, FieldInfo.class);
                    for (FieldInfo fieldInfo : columns) {
                        aliasSet.add(fieldInfo.getNumber());
                    }
                }
                if (!HRStringUtils.isNotEmpty((String)dataFilter)) continue;
                this.addDataFilterRefFieldAlias(dataFilter, queryFieldDys, aliasSet);
            }
            catch (Exception ex) {
                LOGGER.error("AnalyseObjectService.getRefByReportFieldAliasCollection error reportId: {}", (Object)reportDy.getLong("id"), (Object)ex);
                throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f53\u524d\u5206\u6790\u5bf9\u8c61\u4e0b\u7684%s\u7f16\u7801\u62a5\u8868\u5b58\u5728\u810f\u6570\u636e\uff0c\u7f13\u5b58\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u4fee\u590d\u6570\u636e\u3002", (String)"AnalyseObjectService_2", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), reportDy.getString("number")));
            }
        }
        HRBaseServiceHelper filterHelper = new HRBaseServiceHelper("hrptmc_filter");
        DynamicObjectCollection refFieldIds = filterHelper.queryOriginalCollection("isgroupfield, anobjfield.id, groupfield.id", new QFilter[]{new QFilter("rptmanage", "in", reportIds)});
        for (Object filterDy : refFieldIds) {
            boolean isGroupField = filterDy.getBoolean("isgroupfield");
            if (isGroupField) {
                long groupFieldId = filterDy.getLong("groupfield.id");
                groupFieldDys.stream().filter(groupField -> groupFieldId == groupField.getLong("id")).map(groupField -> groupField.getString("number")).findAny().ifPresent(aliasSet::add);
                continue;
            }
            long anObjFieldId = filterDy.getLong("anobjfield.id");
            queryFieldDys.stream().filter(queryField -> anObjFieldId == queryField.getLong("id")).map(queryField -> queryField.getString("fieldalias")).findAny().ifPresent(aliasSet::add);
        }
        HashSet orginAliasSet = Sets.newHashSetWithExpectedSize((int)16);
        for (String alias2 : aliasSet) {
            if (!alias2.contains("!")) continue;
            orginAliasSet.add(alias2.split("!")[0]);
        }
        aliasSet.removeIf(alias -> alias.contains("!"));
        aliasSet.addAll(orginAliasSet);
        HRBaseServiceHelper splitDateHelper = new HRBaseServiceHelper("hrptmc_splitdate");
        DynamicObjectCollection splitDateCol = splitDateHelper.queryOriginalCollection("anobjfield.id", new QFilter[]{new QFilter("rptmanage", "in", reportIds)});
        Set splitDateRefFieldIds = splitDateCol.stream().map(dy -> dy.getLong("anobjfield.id")).collect(Collectors.toSet());
        if (!splitDateRefFieldIds.isEmpty()) {
            queryFieldDys.stream().filter(queryField -> splitDateRefFieldIds.contains(queryField.getLong("id"))).map(queryField -> queryField.getString("fieldalias")).forEach(aliasSet::add);
        }
    }

    private void addDataFilterRefFieldAlias(String dataFilter, DynamicObjectCollection queryFieldDys, Set<String> aliasSet) {
        RuleConditionInfo conditionInfo = (RuleConditionInfo)SerializationUtils.fromJsonString((String)dataFilter, RuleConditionInfo.class);
        block0: for (ConditionInfo info : conditionInfo.getConditionList()) {
            String fieldAlias = info.getParam();
            for (DynamicObject queryFieldDy : queryFieldDys) {
                QueryFieldCommonBo queryFieldCommonBo = new QueryFieldCommonBo();
                queryFieldCommonBo.setEntityNumber(queryFieldDy.getString("entitynumber"));
                queryFieldCommonBo.setFieldAlias(queryFieldDy.getString("fieldalias"));
                queryFieldCommonBo.setFieldPath(queryFieldDy.getString("fieldpath"));
                if (!queryFieldCommonBo.getHRFilterParam().equals(fieldAlias)) continue;
                aliasSet.add(queryFieldCommonBo.getFieldAlias());
                continue block0;
            }
        }
    }

    public RepQueryConfigBo queryRepQueryConfigBo(long reportId) {
        return this.queryRepQueryConfigBo(reportId, null);
    }

    @ExcludeFromJacocoGeneratedReport
    public RepQueryConfigBo queryRepQueryConfigBo(Long reportId, IPageCache pageCache) {
        if (reportId == null) {
            RepQueryConfigBo repQueryConfigBo = new RepQueryConfigBo();
            repQueryConfigBo.setEnableCache(false);
            return repQueryConfigBo;
        }
        String repQueryConfigStr = null;
        if (pageCache != null) {
            repQueryConfigStr = pageCache.get("repQueryConfig");
        }
        if (HRStringUtils.isEmpty(repQueryConfigStr)) {
            RepQueryConfigBo repQueryConfigBo = new RepQueryConfigBo();
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_rptqueryconfig");
            String queryFields = "report.id, enablecache, cachebatch, sumbatchcount, detailbatchcount, cachetimeout, queryscheme, ksqlcountbatch, ksqlsumbatch, ksqlsumthreshold, ksqldetailoptimize, algoxoptimizedimcount, algoxoptimizedatacount, enableentityjoinoptimize,originalfieldsort,defsorttype";
            DynamicObject queryConfigDy = helper.queryOriginalOne(queryFields, new QFilter[]{new QFilter("report", "=", (Object)reportId)});
            if (queryConfigDy != null) {
                repQueryConfigBo.setEnableCache(queryConfigDy.getBoolean("enablecache"));
                repQueryConfigBo.setCacheBatch(queryConfigDy.getInt("cachebatch"));
                repQueryConfigBo.setSumBatchCount(queryConfigDy.getInt("sumbatchcount"));
                repQueryConfigBo.setDetailBatchCount(queryConfigDy.getInt("detailbatchcount"));
                repQueryConfigBo.setCacheTimeout(queryConfigDy.getLong("cachetimeout"));
                repQueryConfigBo.setQueryScheme(queryConfigDy.getString("queryscheme"));
                repQueryConfigBo.setkSqlCountBatch(queryConfigDy.getInt("ksqlcountbatch"));
                repQueryConfigBo.setkSqlSumBatch(queryConfigDy.getInt("ksqlsumbatch"));
                repQueryConfigBo.setkSqlSumThreshold(queryConfigDy.getInt("ksqlsumthreshold"));
                repQueryConfigBo.setKsqlDetailOptimize(queryConfigDy.getBoolean("ksqldetailoptimize"));
                repQueryConfigBo.setAlgoXOptimizedDimCount(queryConfigDy.getInt("algoxoptimizedimcount"));
                repQueryConfigBo.setAlgoXOptimizeDataCount(queryConfigDy.getInt("algoxoptimizedatacount"));
                repQueryConfigBo.setEnableEntityJoinOptimize(queryConfigDy.getBoolean("enableentityjoinoptimize"));
                repQueryConfigBo.setOriginalFieldSort(queryConfigDy.getBoolean("originalfieldsort"));
                repQueryConfigBo.setDefSortType(queryConfigDy.getString("defsorttype"));
            }
            if (pageCache != null) {
                pageCache.put("repQueryConfig", SerializationUtils.toJsonString((Object)repQueryConfigBo));
            }
            return repQueryConfigBo;
        }
        return (RepQueryConfigBo)SerializationUtils.fromJsonString((String)repQueryConfigStr, RepQueryConfigBo.class);
    }

    public List<AnObjPivotBo> getAnObjPivotConfigMsg(long anObjId) {
        DynamicObject[] anObjPivotDys = this.queryAnObjPivotDys(anObjId);
        ArrayList anObjPivotBos = Lists.newArrayListWithExpectedSize((int)anObjPivotDys.length);
        for (DynamicObject anObjPivotDy : anObjPivotDys) {
            AnObjPivotBo anObjPivotBo = new AnObjPivotBo();
            anObjPivotBo.setAnObjId(anObjId);
            anObjPivotBo.setPivotDim(anObjPivotDy.getString("pivotdim"));
            anObjPivotBo.setPivotIndex(anObjPivotDy.getString("pivotindex"));
            anObjPivotBo.setPivotDimVal(anObjPivotDy.getString("pivotdimval"));
            anObjPivotBo.setPivotIndexNum(anObjPivotDy.getString("pivotindexnum"));
            anObjPivotBos.add(anObjPivotBo);
        }
        return anObjPivotBos;
    }

    public void deleteAnObjPivotConfig(List<Object> anObjIds) {
        this.pivotHelper.deleteByFilter(new QFilter[]{new QFilter("anobj", "in", anObjIds)});
    }

    public void deleteAnObjPivotConfig(long anObjId) {
        this.pivotHelper.deleteByFilter(new QFilter[]{new QFilter("anobj", "=", (Object)anObjId)});
    }

    public List<DynamicObject> saveAnObjPivotConfig(DynamicObject anObjDy) {
        long anObjId = anObjDy.getLong("id");
        String pivotDim = anObjDy.getString("pivotdim");
        DynamicObject[] loadDys = this.queryAnObjPivotDys(anObjId);
        List<Object> loadAnObjPivotList = Lists.newArrayListWithCapacity((int)16);
        if (loadDys != null && loadDys.length > 0 && HRStringUtils.equals((String)loadDys[0].getString("pivotdim"), (String)pivotDim)) {
            loadAnObjPivotList = Arrays.stream(loadDys).collect(Collectors.toList());
        }
        this.deleteAnObjPivotConfig(anObjId);
        List<DynamicObject> saveDys = this.generatePivotConfig(anObjDy, loadAnObjPivotList);
        if (!saveDys.isEmpty()) {
            this.pivotHelper.save(saveDys.toArray(new DynamicObject[0]));
            anObjDy.set("pivotdim", null);
            anObjDy.set("pivotindex", null);
            anObjDy.set("pivotdimval", null);
        }
        return saveDys;
    }

    public List<DynamicObject> generatePivotConfig(DynamicObject anObjDy, List<DynamicObject> loadAnObjPivotList) {
        ArrayList saveDys = Lists.newArrayListWithCapacity((int)16);
        long anObjId = anObjDy.getLong("id");
        String pivotDim = anObjDy.getString("pivotdim");
        String pivotDimValStr = anObjDy.getString("pivotdimval");
        String pivotIndexStr = anObjDy.getString("pivotindex");
        List<Object> pivotDimValList = Lists.newArrayListWithCapacity((int)16);
        List<Object> pivotIndexList = Lists.newArrayListWithCapacity((int)16);
        if (HRStringUtils.isNotEmpty((String)pivotDimValStr)) {
            pivotDimValList = Arrays.stream(pivotDimValStr.split(",")).collect(Collectors.toList());
        }
        if (HRStringUtils.isNotEmpty((String)pivotIndexStr)) {
            pivotIndexList = Arrays.stream(pivotIndexStr.split(",")).collect(Collectors.toList());
        }
        if (!pivotDimValList.isEmpty() && !pivotIndexList.isEmpty()) {
            HashSet newIndexAliasCol = Sets.newHashSetWithExpectedSize((int)16);
            for (String string : pivotDimValList) {
                for (String string2 : pivotIndexList) {
                    DynamicObject newDy = this.pivotHelper.generateEmptyDynamicObject();
                    newDy.set("anobj", (Object)anObjId);
                    newDy.set("pivotdim", (Object)pivotDim);
                    newDy.set("pivotdimval", (Object)string);
                    newDy.set("pivotindex", (Object)string2);
                    Optional<DynamicObject> anyPivot = loadAnObjPivotList.stream().filter(pivot -> HRStringUtils.equals((String)dimVal, (String)pivot.getString("pivotdimval")) && HRStringUtils.equals((String)index, (String)pivot.getString("pivotindex"))).findAny();
                    if (anyPivot.isPresent()) {
                        String genIndexNum = anyPivot.get().getString("pivotindexnum");
                        newIndexAliasCol.add(genIndexNum);
                        newDy.set("pivotindexnum", (Object)genIndexNum);
                    } else {
                        String newIndexNum = this.generatePivotIndexNumber(string, string2, newIndexAliasCol);
                        newDy.set("pivotindexnum", (Object)newIndexNum);
                    }
                    saveDys.add(newDy);
                }
            }
        } else if (!pivotDimValList.isEmpty()) {
            for (String string : pivotDimValList) {
                DynamicObject dynamicObject = this.pivotHelper.generateEmptyDynamicObject();
                dynamicObject.set("anobj", (Object)anObjId);
                dynamicObject.set("pivotdim", (Object)pivotDim);
                dynamicObject.set("pivotdimval", (Object)string);
                saveDys.add(dynamicObject);
            }
        } else {
            for (String string : pivotIndexList) {
                DynamicObject dynamicObject = this.pivotHelper.generateEmptyDynamicObject();
                dynamicObject.set("anobj", (Object)anObjId);
                dynamicObject.set("pivotdim", (Object)pivotDim);
                dynamicObject.set("pivotindex", (Object)string);
                saveDys.add(dynamicObject);
            }
        }
        return saveDys;
    }

    public List<PivotIndexFieldBo> getAnalysePivotIndexes(DynamicObject[] pivotDys, List<QueryFieldBo> queryFieldBoList, List<CalculateFieldBo> calculateFieldBoList, boolean removeOriginField) {
        ArrayList pivotIndexes = Lists.newArrayListWithCapacity((int)10);
        if (pivotDys == null || pivotDys.length == 0) {
            return pivotIndexes;
        }
        String pivotDim = pivotDys[0].getString("pivotdim");
        if (HRStringUtils.isEmpty((String)pivotDim)) {
            return pivotIndexes;
        }
        Map<String, QueryFieldBo> queryFieldMap = queryFieldBoList.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, field -> field));
        Map<String, CalculateFieldBo> calFieldMap = calculateFieldBoList.stream().collect(Collectors.toMap(CalculateFieldBo::getFieldNumber, field -> field));
        if (removeOriginField) {
            queryFieldBoList.removeIf(field -> this.isIndexField(field.getValueType()) && this.isNotIdField(field.getFieldAlias()) || HRStringUtils.equals((String)pivotDim, (String)field.getFieldAlias()));
            calculateFieldBoList.removeIf(field -> HRStringUtils.equals((String)field.getSource(), (String)"anobj") && this.isIndexField(field.getValueType()) || HRStringUtils.equals((String)pivotDim, (String)field.getFieldNumber()));
        }
        QueryFieldBo queryFieldBo = queryFieldMap.get(pivotDim);
        List<String> dimValues = Arrays.stream(pivotDys).map(pivotDy -> pivotDy.getString("pivotdimval")).collect(Collectors.toList());
        dimValues.removeIf(HRStringUtils::isEmpty);
        if (dimValues.isEmpty()) {
            return pivotIndexes;
        }
        Map<String, String> dimValueMap = this.queryPivotDimValuesById(queryFieldBo, dimValues);
        for (DynamicObject pivotDy2 : pivotDys) {
            String indexValueType;
            String indexName;
            String pivotIndex = pivotDy2.getString("pivotindex");
            String pivotDimVal = pivotDy2.getString("pivotdimval");
            String newIndexNum = pivotDy2.getString("pivotindexnum");
            if (HRStringUtils.isEmpty((String)pivotDim) || HRStringUtils.isEmpty((String)pivotDimVal) || HRStringUtils.isEmpty((String)pivotIndex)) continue;
            PivotIndexFieldBo newIndexBo = new PivotIndexFieldBo();
            String dimName = dimValueMap.get(pivotDimVal);
            QueryFieldBo indexBo = queryFieldMap.get(pivotIndex);
            if (indexBo == null) {
                CalculateFieldBo indexCalBo = calFieldMap.get(pivotIndex);
                indexName = indexCalBo.getFieldName().getLocaleValue();
                indexValueType = indexCalBo.getValueType();
            } else {
                indexName = indexBo.getFieldName().getLocaleValue();
                indexValueType = indexBo.getValueType();
            }
            String newIndexName = dimName + "-" + indexName;
            LocaleString fieldName = new LocaleString(newIndexName);
            fieldName.setItem("GLang", (Object)newIndexName);
            newIndexBo.setFieldName(fieldName);
            newIndexBo.setFieldAlias(newIndexNum);
            newIndexBo.setFieldPath(newIndexNum);
            newIndexBo.setComplexType(FieldComplexType.NORMAL.getValue());
            newIndexBo.setValueType(indexValueType);
            if (HRStringUtils.equals((String)indexValueType, (String)DataTypeEnum.LONG.getDataTypeKey())) {
                newIndexBo.setControlType(FieldControlType.BIGINT.getValue());
            } else if (HRStringUtils.equals((String)indexValueType, (String)DataTypeEnum.BIGDECIMAL.getDataTypeKey())) {
                newIndexBo.setControlType(FieldControlType.DECIMAL.getValue());
            } else if (HRStringUtils.equals((String)indexValueType, (String)DataTypeEnum.INTEGER.getDataTypeKey())) {
                newIndexBo.setControlType(FieldControlType.INTEGER.getValue());
            }
            newIndexBo.setPivotDimAlias(pivotDim);
            newIndexBo.setPivotDimName(dimName);
            newIndexBo.setPivotDimVal(pivotDimVal);
            newIndexBo.setPivotIndexAlias(pivotIndex);
            pivotIndexes.add(newIndexBo);
        }
        return pivotIndexes;
    }

    public List<PivotIndexFieldBo> getAnalysePivotIndexes(Long anObjId, List<QueryFieldBo> queryFieldBoList, List<CalculateFieldBo> calculateFieldBoList, boolean removeOriginField) {
        DynamicObject[] pivotDys = this.queryAnObjPivotDys(anObjId);
        if (pivotDys == null || pivotDys.length == 0) {
            return Lists.newArrayListWithExpectedSize((int)10);
        }
        return this.getAnalysePivotIndexes(pivotDys, queryFieldBoList, calculateFieldBoList, removeOriginField);
    }

    public Set<String> generatePivotIndexNumber(DynamicObject[] anObjPivotDys) {
        HashSet newIndexNumbers = Sets.newHashSetWithExpectedSize((int)16);
        if (anObjPivotDys == null || anObjPivotDys.length == 0) {
            return newIndexNumbers;
        }
        String pivotDim = anObjPivotDys[0].getString("pivotdim");
        for (DynamicObject pivotDy : anObjPivotDys) {
            String pivotIndex = pivotDy.getString("pivotindex");
            String pivotDimVal = pivotDy.getString("pivotdimval");
            String newIndexNum = pivotDy.getString("pivotindexnum");
            if (HRStringUtils.isEmpty((String)pivotDim) || HRStringUtils.isEmpty((String)pivotDimVal) || HRStringUtils.isEmpty((String)pivotIndex)) continue;
            newIndexNumbers.add(newIndexNum);
        }
        return newIndexNumbers;
    }

    @ExcludeFromJacocoGeneratedReport
    private String generatePivotIndexNumber(String dimValue, String indexAlias, Set<String> newIndexAliasCol) {
        String newIndexNum;
        block4: {
            for (int i = 0; i < dimValue.length(); ++i) {
                char chr = dimValue.charAt(i);
                if (this.isAliasChar(chr)) continue;
                dimValue = dimValue.replace(chr, '_');
            }
            newIndexNum = NUMBER_PATTERN.matcher(dimValue).find() ? "idx_" + dimValue + "_" + indexAlias : dimValue + "_" + indexAlias;
            if (newIndexAliasCol.contains(newIndexNum)) {
                int idx = 1;
                while (true) {
                    String finalIndexNum;
                    if (newIndexAliasCol.add(finalIndexNum = newIndexNum + idx)) {
                        newIndexNum = finalIndexNum;
                        break block4;
                    }
                    ++idx;
                }
            }
            newIndexAliasCol.add(newIndexNum);
        }
        return newIndexNum;
    }

    public boolean isIndexField(String valueType) {
        return HRStringUtils.equals((String)DataTypeEnum.INTEGER.getDataTypeKey(), (String)valueType) || HRStringUtils.equals((String)DataTypeEnum.LONG.getDataTypeKey(), (String)valueType) || HRStringUtils.equals((String)DataTypeEnum.BIGDECIMAL.getDataTypeKey(), (String)valueType);
    }

    public boolean isNotIdField(String fieldAlias) {
        return !fieldAlias.endsWith(".id") && !HRStringUtils.equals((String)fieldAlias, (String)"id");
    }

    private boolean isAliasChar(char chr) {
        return chr >= 'a' && chr <= 'z' || chr >= 'A' && chr <= 'Z' || chr >= '0' && chr <= '9' || chr == '_';
    }

    @ExcludeFromJacocoGeneratedReport
    private Map<String, String> queryPivotDimValuesById(QueryFieldBo field, List<String> dimValIds) {
        IDataEntityProperty fieldProperty;
        HashMap dimValueMap = Maps.newHashMapWithExpectedSize((int)dimValIds.size());
        if (field.isVirtualEntityField()) {
            String fieldPath = field.getFieldPath();
            fieldProperty = AnalyseObjectService.getInstance().getFieldProperty(fieldPath.substring(0, fieldPath.indexOf(46)), fieldPath, field.getComplexType());
        } else {
            fieldProperty = AnalyseObjectService.getInstance().getFieldProperty(field.getEntityNumber(), field.getFieldAlias(), field.getComplexType());
        }
        if (AnalyseObjectUtil.isBaseDataType((String)field.getComplexType())) {
            QFilter[] qFilters;
            BasedataEntityType parent = (BasedataEntityType)fieldProperty.getParent();
            String baseEntityId = parent.getName();
            String fieldName = fieldProperty.getName();
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
            HRBaseServiceHelper helper = new HRBaseServiceHelper(baseEntityId);
            if (dataEntityType.getPrimaryKey() instanceof LongProp) {
                List longIds = dimValIds.stream().map(Long::valueOf).collect(Collectors.toList());
                qFilters = new QFilter[]{new QFilter("id", "in", longIds)};
            } else {
                qFilters = new QFilter[]{new QFilter("id", "in", dimValIds)};
            }
            DynamicObjectCollection dynamicObjects = helper.queryOriginalCollection("id," + fieldName, qFilters);
            for (DynamicObject dynamicObject : dynamicObjects) {
                dimValueMap.put(dynamicObject.getString("id"), dynamicObject.getString(fieldName));
            }
        } else {
            List comboItems = ((ComboProp)fieldProperty).getComboItems();
            for (ValueMapItem comboItem : comboItems) {
                dimValueMap.put(comboItem.getValue(), comboItem.getName().getLocaleValue());
            }
        }
        return dimValueMap;
    }

    private String getFieldShortNumber(String entityNumber, String fieldAlias, String fieldComplexType, MainEntityTypeUtil entityTypeUtil) {
        if (AnalyseObjectUtil.isBaseDataType((String)fieldComplexType) && fieldAlias.contains(".")) {
            MainEntityType dataEntityType = entityTypeUtil.getMainEntityType(entityNumber);
            String[] aliasArr = fieldAlias.split("\\.");
            if (aliasArr.length > 2) {
                String parentFieldName = aliasArr[aliasArr.length - 3];
                IDataEntityProperty parentProp = (IDataEntityProperty)dataEntityType.getAllFields().get(parentFieldName);
                if (parentProp instanceof BasedataProp) {
                    return aliasArr[aliasArr.length - 3] + "." + aliasArr[aliasArr.length - 2] + "." + aliasArr[aliasArr.length - 1];
                }
            }
            return aliasArr[aliasArr.length - 2] + "." + aliasArr[aliasArr.length - 1];
        }
        return fieldAlias.substring(fieldAlias.lastIndexOf(46) + 1);
    }

    public IDataEntityProperty getFieldProperty(String entityNumber, String fieldAlias, String fieldComplexType) {
        if (fieldAlias.endsWith(".id")) {
            return null;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String[] aliasArr = fieldAlias.split("\\.");
        IDataEntityProperty property = null;
        String fieldName = aliasArr[aliasArr.length - 1];
        if (AnalyseObjectUtil.isBaseDataType((String)fieldComplexType)) {
            String parentFieldName = aliasArr[aliasArr.length - 2];
            if (aliasArr.length > 2) {
                String grandParentFieldName = aliasArr[aliasArr.length - 3];
                IDataEntityProperty grandParentProp = (IDataEntityProperty)dataEntityType.getAllFields().get(grandParentFieldName);
                if (grandParentProp instanceof BasedataProp) {
                    String grandParentEntityNum = ((BasedataProp)grandParentProp).getBaseEntityId();
                    MainEntityType grandParentBaseDataEntityType = EntityMetadataCache.getDataEntityType((String)grandParentEntityNum);
                    property = (IDataEntityProperty)grandParentBaseDataEntityType.getAllFields().get(parentFieldName);
                    MainEntityType parentBaseDataEntityType = EntityMetadataCache.getDataEntityType((String)((BasedataProp)property).getBaseEntityId());
                    property = (IDataEntityProperty)parentBaseDataEntityType.getAllFields().get(fieldName);
                }
            }
            if (property == null) {
                property = (IDataEntityProperty)dataEntityType.getAllFields().get(parentFieldName);
                if (property == null) {
                    LOGGER.error("AnObj-getDimensionParam-fieldNotExist entityNumber: {}, fieldAlias: {}, fieldComplexType: {}", new Object[]{entityNumber, parentFieldName, fieldComplexType});
                    String msg = ResManager.loadKDString((String)"\u5b9e\u4f53%1$s\u7684\u522b\u540d\u4e3a%2$s\u7684\u5b57\u6bb5\u4e0d\u5b58\u5728\u3002", (String)"AnalyseObjectService_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]);
                    throw new KDBizException(String.format(msg, entityNumber, parentFieldName));
                }
                String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                MainEntityType baseDataEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
                property = (IDataEntityProperty)baseDataEntityType.getAllFields().get(fieldName);
            }
        } else {
            property = (IDataEntityProperty)dataEntityType.getAllFields().get(fieldName);
        }
        if (property == null) {
            LOGGER.error("AnObj-getDimensionParam-fieldNotExist entityNumber: {}, fieldAlias: {}, fieldComplexType: {}", new Object[]{entityNumber, fieldAlias, fieldComplexType});
            String msg = ResManager.loadKDString((String)"\u5b9e\u4f53%1$s\u7684\u522b\u540d\u4e3a%2$s\u7684\u5b57\u6bb5\u4e0d\u5b58\u5728\u3002", (String)"AnalyseObjectService_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]);
            throw new KDBizException(String.format(msg, entityNumber, fieldAlias));
        }
        return property;
    }
}

