/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.bizopen.queryservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hrptmc.business.anobj.AnObjGroupFieldService;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.bizopen.dto.OpenAnObjGroupFieldBo;
import kd.hr.hrptmc.business.bizopen.dto.OpenCalculateFieldBo;
import kd.hr.hrptmc.business.bizopen.dto.OpenQueryFieldBo;
import kd.hr.hrptmc.business.calfield.CalculateFieldService;
import kd.hr.hrptmc.common.constant.bizopen.OpenServiceConstants;
import kd.hr.hrptmc.common.model.anobj.AnObjGroupField;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;

public class OpenAnalysisObjectService
extends OpenServiceConstants {
    private static final Log logger = LogFactory.getLog(OpenAnalysisObjectService.class);

    public Map<String, List> getAnalysisObjectFieldMap(Long anObjId, List<String> fieldTypeList) {
        HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)3);
        if (CollectionUtils.isEmpty(fieldTypeList)) {
            return fieldMap;
        }
        List<QueryFieldBo> queryFieldBos = AnalyseObjectService.getInstance().queryAndAssembleQueryFields(anObjId);
        for (String fieldType : fieldTypeList) {
            if ("analysisField".equals(fieldType)) {
                List<OpenQueryFieldBo> openQueryFieldCommonBoList = this.getOpenQueryFieldBos(queryFieldBos);
                fieldMap.put("analysisField", openQueryFieldCommonBoList);
            }
            if ("calculateField".equals(fieldType)) {
                List<OpenCalculateFieldBo> openCalculateFieldBoList = this.getOpenCalculateFieldBos(anObjId);
                fieldMap.put("calculateField", openCalculateFieldBoList);
            }
            if (!"analysisGroupField".equals(fieldType)) continue;
            List<OpenAnObjGroupFieldBo> anObjGroupFieldList = this.getOpenAnObjGroupFields(anObjId, queryFieldBos);
            fieldMap.put("analysisGroupField", anObjGroupFieldList);
        }
        return fieldMap;
    }

    public List<AnObjGroupField.GroupItem> getAnObjGroupItem(Long groupItemId) {
        AnObjGroupField anObjGroupField = AnObjGroupFieldService.getInstance().getGroupField(groupItemId);
        return anObjGroupField.getGroup();
    }

    private List<OpenQueryFieldBo> getOpenQueryFieldBos(List<QueryFieldBo> queryFieldBos) {
        ArrayList openQueryFieldCommonBoList = Lists.newArrayListWithExpectedSize((int)queryFieldBos.size());
        for (QueryFieldBo queryFieldBo : queryFieldBos) {
            OpenQueryFieldBo openQueryFieldBo = new OpenQueryFieldBo();
            openQueryFieldBo.setId(queryFieldBo.getId());
            openQueryFieldBo.setEntityNumber(queryFieldBo.getEntityNumber());
            openQueryFieldBo.setEntityName(queryFieldBo.getEntityName());
            openQueryFieldBo.setFieldName(queryFieldBo.getFieldName());
            openQueryFieldBo.setFieldNumber(queryFieldBo.getFieldAlias());
            openQueryFieldBo.setFieldPath(queryFieldBo.getFieldPath());
            openQueryFieldBo.setValueType(queryFieldBo.getValueType());
            openQueryFieldBo.setComplexType(queryFieldBo.getComplexType());
            openQueryFieldBo.setControlType(queryFieldBo.getControlType());
            openQueryFieldBo.setData(queryFieldBo.getData());
            openQueryFieldBo.setBaseDataNum(queryFieldBo.getBaseDataNum());
            openQueryFieldBo.setBaseDataIdType(queryFieldBo.getBaseDataIdType());
            openQueryFieldBo.setVirtualEntityField(queryFieldBo.isVirtualEntityField());
            openQueryFieldBo.setAnObjId(queryFieldBo.getAnObjId());
            openQueryFieldCommonBoList.add(openQueryFieldBo);
        }
        return openQueryFieldCommonBoList;
    }

    private List<OpenCalculateFieldBo> getOpenCalculateFieldBos(Long anObjId) {
        List<CalculateFieldBo> calculateFieldBos = CalculateFieldService.getInstance().loadCalFieldsByAnObjIdForBo(anObjId, false);
        ArrayList openCalculateFieldBoList = Lists.newArrayListWithExpectedSize((int)calculateFieldBos.size());
        for (CalculateFieldBo calculateFieldBo : calculateFieldBos) {
            if (!calculateFieldBo.getSelected().booleanValue()) continue;
            OpenCalculateFieldBo openQueryFieldBo = new OpenCalculateFieldBo();
            openQueryFieldBo.setId(calculateFieldBo.getId());
            openQueryFieldBo.setFieldName(calculateFieldBo.getFieldName());
            openQueryFieldBo.setFieldNumber(calculateFieldBo.getFieldNumber());
            openQueryFieldBo.setIndex(calculateFieldBo.getIndex());
            openQueryFieldBo.setType(calculateFieldBo.getType());
            openQueryFieldBo.setAnObjId(calculateFieldBo.getAnObjId());
            openQueryFieldBo.setControlType(calculateFieldBo.getControlType());
            openQueryFieldBo.setExpr(calculateFieldBo.getExpr());
            openQueryFieldBo.setValueType(calculateFieldBo.getValueType());
            openQueryFieldBo.setViewExpr(calculateFieldBo.getViewExpr());
            openCalculateFieldBoList.add(openQueryFieldBo);
        }
        return openCalculateFieldBoList;
    }

    private List<OpenAnObjGroupFieldBo> getOpenAnObjGroupFields(Long anObjId, List<QueryFieldBo> queryFieldBos) {
        List<AnObjGroupField> anObjGroupFields = AnObjGroupFieldService.getInstance().getGroupFields(anObjId, queryFieldBos);
        ArrayList anObjGroupFieldList = Lists.newArrayListWithExpectedSize((int)anObjGroupFields.size());
        for (AnObjGroupField anObjGroupField : anObjGroupFields) {
            OpenAnObjGroupFieldBo openQueryFieldBo = new OpenAnObjGroupFieldBo();
            openQueryFieldBo.setId(anObjGroupField.getId());
            openQueryFieldBo.setIndex(anObjGroupField.getIndex());
            openQueryFieldBo.setName(anObjGroupField.getName());
            openQueryFieldBo.setFieldNumber(anObjGroupField.getNumber());
            openQueryFieldBo.setFieldType(anObjGroupField.getFieldType());
            openQueryFieldBo.setAnObjId(anObjGroupField.getAnObjId());
            openQueryFieldBo.setGroup(anObjGroupField.getGroup());
            openQueryFieldBo.setType(anObjGroupField.getType());
            anObjGroupFieldList.add(openQueryFieldBo);
        }
        return anObjGroupFieldList;
    }
}

