/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.calfield;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnObjGroupFieldService;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.common.constant.calfield.CalculateFieldConstants;
import kd.hr.hrptmc.common.model.anobj.AnObjGroupField;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;
import kd.hr.hrptmc.common.model.calfield.PreIndexBo;

public class CalculateFieldService
implements CalculateFieldConstants {
    private static final Log LOGGER = LogFactory.getLog(CalculateFieldService.class);
    private final HRBaseServiceHelper calFieldHelper = new HRBaseServiceHelper("hrptmc_calculatefield");
    private static volatile CalculateFieldService service = null;

    private CalculateFieldService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CalculateFieldService getInstance() {
        if (service != null) return service;
        Class<CalculateFieldService> clazz = CalculateFieldService.class;
        synchronized (CalculateFieldService.class) {
            if (service != null) return service;
            service = new CalculateFieldService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public DynamicObject[] loadCalFieldsByAnObjId(Long anObjId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("anobj", "=", (Object)anObjId)};
        return this.calFieldHelper.loadDynamicObjectArray(qFilters);
    }

    public DynamicObject[] loadCalFieldByReportId(Long reportId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("report", "=", (Object)reportId)};
        return this.calFieldHelper.loadDynamicObjectArray(qFilters);
    }

    public DynamicObject[] loadCalFieldByReportIds(Collection<Long> reportIds) {
        QFilter[] qFilters = new QFilter[]{new QFilter("report", "in", reportIds)};
        return this.calFieldHelper.loadDynamicObjectArray(qFilters);
    }

    public DynamicObject[] queryReportCalFieldNameNumsForAnObj(Long anObjId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_reportmanage");
        DynamicObjectCollection reports = helper.queryOriginalCollection("id", new QFilter[]{new QFilter("anobjid", "=", (Object)anObjId)});
        if (reports.isEmpty()) {
            return new DynamicObject[0];
        }
        List reportIds = reports.stream().map(report -> report.get("id")).collect(Collectors.toList());
        return this.calFieldHelper.query("id, name, number", new QFilter[]{new QFilter("report", "in", reportIds)});
    }

    public CalculateFieldBo loadCalFieldByAnObjIdForBo(Long anObjId, String calFieldNumber) {
        QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", (Object)calFieldNumber), new QFilter("anobj", "=", (Object)anObjId)};
        DynamicObject calFieldDy = this.calFieldHelper.loadDynamicObject(qFilters);
        List<CalculateFieldBo> calculateFieldBos = this.assembleCalFieldsForAnObj(new DynamicObject[]{calFieldDy}, false);
        return calculateFieldBos.get(0);
    }

    public List<CalculateFieldBo> loadCalFieldsByAnObjIdForBo(Long anObjId, boolean queryRefDimCount) {
        DynamicObject[] calFields = this.loadCalFieldsByAnObjId(anObjId);
        return this.assembleCalFieldsForAnObj(calFields, queryRefDimCount);
    }

    public List<CalculateFieldBo> loadCalFieldsByReportIdForBo(Long anObjId, Long reportId, List<QueryFieldBo> loadQueryFields) {
        DynamicObject[] calFields = this.loadCalFieldByReportId(reportId);
        DynamicObject[] anObjCalFields = this.loadCalFieldsByAnObjId(anObjId);
        List<CalculateFieldBo> anObjCalFieldBos = this.assembleCalFieldsForAnObj(anObjCalFields, false);
        List<AnObjGroupField> groupFields = AnObjGroupFieldService.getInstance().getGroupFields(anObjId, loadQueryFields);
        return this.assembleCalFieldsForReport(calFields, anObjCalFieldBos, loadQueryFields, groupFields);
    }

    public CalculateFieldBo generateCalculateFieldForCount(String fieldAlias, LocaleString displayName, int index) {
        CalculateFieldBo calculateFieldBo = new CalculateFieldBo();
        calculateFieldBo.setFieldName(displayName);
        calculateFieldBo.setFieldNumber(this.getDimCountFieldAlias(fieldAlias));
        calculateFieldBo.setTitle(displayName.getLocaleValue());
        calculateFieldBo.setSource("report");
        calculateFieldBo.setControlType(FieldControlType.INTEGER.getValue());
        calculateFieldBo.setValueType(DataTypeEnum.INTEGER.getDataTypeKey());
        calculateFieldBo.setIndex(Integer.valueOf(index));
        calculateFieldBo.setKey(calculateFieldBo.getFieldNumber());
        calculateFieldBo.setType("simple");
        calculateFieldBo.setExpr("1");
        calculateFieldBo.setViewExpr("1");
        return calculateFieldBo;
    }

    public String getDimCountFieldAlias(String fieldAlias) {
        return "RPTDIMCOUNT_" + fieldAlias;
    }

    public String getControlTypeByValueType(String valueType) {
        DataTypeEnum dataTypeEnum = DataTypeEnum.of((String)valueType);
        String controlType = FieldControlType.TEXT.getValue();
        switch (dataTypeEnum) {
            case LONG: {
                controlType = FieldControlType.BIGINT.getValue();
                break;
            }
            case BIGDECIMAL: {
                controlType = FieldControlType.DECIMAL.getValue();
                break;
            }
            case INTEGER: {
                controlType = FieldControlType.INTEGER.getValue();
                break;
            }
            case BOOLEAN: {
                controlType = FieldControlType.CHECKBOX.getValue();
                break;
            }
        }
        return controlType;
    }

    public boolean deleteCalculateField(String deleteCalFieldNumber, List<CalculateFieldBo> calculateFieldBos, StringBuilder errorMsg) {
        boolean deleteError;
        StringBuilder refCalFieldNames = new StringBuilder();
        for (CalculateFieldBo calculateFieldBo : calculateFieldBos) {
            if (!calculateFieldBo.getRefCalculateFields().stream().anyMatch(field -> HRStringUtils.equals((String)deleteCalFieldNumber, (String)field.getFieldNumber()))) continue;
            refCalFieldNames.append(calculateFieldBo.getFieldName().getLocaleValue()).append(",");
        }
        boolean bl = deleteError = refCalFieldNames.length() > 0;
        if (deleteError) {
            String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002\u8be5\u8ba1\u7b97\u5b57\u6bb5\u88ab\u201c%s\u201d\u8ba1\u7b97\u5b57\u6bb5\u5f15\u7528\u3002", (String)"CalculateFieldService_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), refCalFieldNames.substring(0, refCalFieldNames.length() - 1));
            errorMsg.append(msg);
        } else {
            calculateFieldBos.removeIf(field -> HRStringUtils.equals((String)deleteCalFieldNumber, (String)field.getFieldNumber()));
        }
        return !deleteError;
    }

    public void saveCalculateFieldsForAnObj(boolean isAnObjUpdate, Long anObjId, List<CalculateFieldBo> calculatedFields) {
        Map<Object, DynamicObject> calFieldsLoadMap = Collections.emptyMap();
        boolean anObjRefByReport = false;
        if (isAnObjUpdate) {
            CalculateFieldService calFieldService = CalculateFieldService.getInstance();
            DynamicObject[] calFieldLoads = calFieldService.loadCalFieldsByAnObjId(anObjId);
            calFieldsLoadMap = Arrays.stream(calFieldLoads).collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy));
            anObjRefByReport = AnalyseObjectService.getInstance().isAnObjRefByReport(anObjId);
        }
        this.assembleAndSaveCalFields(anObjId, null, calculatedFields, calFieldsLoadMap, anObjRefByReport);
    }

    public void saveCalculateFieldForReport(boolean isReportUpdate, Long reportId, List<CalculateFieldBo> calculatedFields) {
        Map<Object, DynamicObject> calFieldsLoadMap = Collections.emptyMap();
        if (isReportUpdate) {
            CalculateFieldService calFieldService = CalculateFieldService.getInstance();
            DynamicObject[] calFieldLoads = calFieldService.loadCalFieldByReportId(reportId);
            calFieldsLoadMap = Arrays.stream(calFieldLoads).collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy));
        }
        this.assembleAndSaveCalFields(null, reportId, calculatedFields, calFieldsLoadMap, false);
    }

    private void assembleAndSaveCalFields(Long anObjId, Long reportId, List<CalculateFieldBo> calculatedFields, Map<Object, DynamicObject> calFieldsLoadMap, boolean anObjRefByReport) {
        HRBaseServiceHelper calFieldHelper = new HRBaseServiceHelper("hrptmc_calculatefield");
        DynamicObjectCollection calFieldCol = new DynamicObjectCollection();
        ArrayList deleteIds = Lists.newArrayListWithCapacity((int)10);
        if (anObjRefByReport) {
            for (CalculateFieldBo calculateFieldBo : calculatedFields) {
                String id = calculateFieldBo.getId();
                if (!HRStringUtils.isNotEmpty((String)id)) continue;
                DynamicObject calFieldDy = calFieldsLoadMap.get(Long.valueOf(id));
                boolean isSelected = calFieldDy.getBoolean("isselected");
                if (isSelected && !calculateFieldBo.getSelected().booleanValue()) {
                    calculateFieldBo.setSelected(Boolean.valueOf(false));
                }
                if (isSelected || !calculateFieldBo.getSelected().booleanValue()) continue;
                calculateFieldBo.setSelected(Boolean.valueOf(true));
            }
        }
        Set ids = calculatedFields.stream().filter(calFieldBo -> HRStringUtils.isNotEmpty((String)calFieldBo.getId())).map(calFieldBo -> Long.valueOf(calFieldBo.getId())).collect(Collectors.toSet());
        for (DynamicObject dy : calFieldsLoadMap.values()) {
            Long id = dy.getLong("id");
            if (ids.contains(id)) continue;
            Optional<CalculateFieldBo> calFieldBo2 = calculatedFields.stream().filter(field -> HRStringUtils.isNotEmpty((String)field.getId())).filter(field -> Objects.equals(Long.valueOf(field.getId()), id)).findAny();
            if (anObjRefByReport && calFieldBo2.isPresent() && calFieldBo2.get().getSelected().booleanValue()) continue;
            deleteIds.add(id);
        }
        long l = calculatedFields.stream().filter(field -> HRStringUtils.isEmpty((String)field.getId())).count();
        long[] newIds = ORM.create().genLongIds("hrptmc_calculatefield", (int)l);
        int index = 0;
        HashMap numberToIdMap = Maps.newHashMapWithExpectedSize((int)calculatedFields.size());
        for (CalculateFieldBo calField : calculatedFields) {
            String refAggregation;
            DynamicObjectCollection refFieldEntry;
            DynamicObject calFieldDy;
            long calFieldId = 0L;
            if (HRStringUtils.isNotEmpty((String)calField.getId())) {
                calFieldId = Long.parseLong(calField.getId());
            }
            if ((calFieldDy = calFieldsLoadMap.get(calFieldId)) == null) {
                calFieldDy = calFieldHelper.generateEmptyDynamicObject();
                calFieldDy.set("id", (Object)newIds[index]);
                calField.setId(String.valueOf(newIds[index]));
                calField.setId(String.valueOf(newIds[index]));
                numberToIdMap.put(calField.getFieldNumber(), newIds[index]);
                ++index;
            } else if (HRStringUtils.isNotEmpty((String)calField.getId())) {
                numberToIdMap.put(calField.getFieldNumber(), Long.valueOf(calField.getId()));
            }
            calFieldDy.set("index", (Object)calField.getIndex());
            calFieldDy.set("number", (Object)calField.getFieldNumber());
            calFieldDy.set("name", (Object)calField.getFieldName());
            calFieldDy.set("type", (Object)calField.getType());
            calFieldDy.set("valuetype", (Object)calField.getValueType());
            calFieldDy.set("controltype", (Object)calField.getControlType());
            calFieldDy.set("expr", (Object)calField.getExpr());
            calFieldDy.set("viewexpr", (Object)calField.getViewExpr());
            calFieldDy.set("source", (Object)calField.getSource());
            calFieldDy.set("order", (Object)calField.getOrder());
            calFieldDy.set("isselected", (Object)calField.getSelected());
            calFieldDy.set("calmethod", (Object)calField.getCalMethod());
            calFieldDy.set("hidefield", (Object)calField.isHideField());
            if (HRStringUtils.equals((String)calField.getSource(), (String)"anobj")) {
                calFieldDy.set("anobj", (Object)anObjId);
            } else {
                calFieldDy.set("report", (Object)reportId);
            }
            if (calFieldDy.getDataEntityState().getFromDatabase()) {
                refFieldEntry = calFieldDy.getDynamicObjectCollection("reffieldentry");
                refFieldEntry.clear();
            } else {
                refFieldEntry = calFieldHelper.generateEmptyEntryCollection(calFieldDy, "reffieldentry");
            }
            Map aggregationMap = calField.getAggregationMap();
            for (String refEntityFieldAlias : calField.getRefEntityFields()) {
                DynamicObject refCalculateFieldDy = calFieldHelper.generateEmptyEntryDynamicObject("reffieldentry");
                refCalculateFieldDy.set("reftype", (Object)"entityfield");
                refCalculateFieldDy.set("reffieldalias", (Object)refEntityFieldAlias);
                refAggregation = (String)aggregationMap.get(refEntityFieldAlias);
                if (HRStringUtils.isNotEmpty((String)refAggregation)) {
                    refCalculateFieldDy.set("aggregation", (Object)refAggregation);
                }
                refFieldEntry.add((Object)refCalculateFieldDy);
            }
            for (PreIndexBo refPreIndex : calField.getRefPreIndexes()) {
                DynamicObject refPreIndexDy = calFieldHelper.generateEmptyEntryDynamicObject("reffieldentry");
                refPreIndexDy.set("reftype", (Object)"preindex");
                refPreIndexDy.set("refpreindex", (Object)refPreIndex.getId());
                refPreIndexDy.set("reffieldalias", (Object)refPreIndex.getFieldNumber());
                refAggregation = (String)aggregationMap.get(refPreIndex.getFieldNumber());
                if (HRStringUtils.isNotEmpty((String)refAggregation)) {
                    refPreIndexDy.set("aggregation", (Object)refAggregation);
                }
                refFieldEntry.add((Object)refPreIndexDy);
            }
            calFieldCol.add((Object)calFieldDy);
        }
        Map<Long, DynamicObject> fieldDyMap = calFieldCol.stream().collect(Collectors.toMap(field -> field.getLong("id"), field -> field));
        for (CalculateFieldBo calField : calculatedFields) {
            List refCalculateFields = calField.getRefCalculateFields();
            Map aggregationMap = calField.getAggregationMap();
            for (CalculateFieldBo refCalculateField : refCalculateFields) {
                Long refId;
                DynamicObject refCalculateFieldDy = calFieldHelper.generateEmptyEntryDynamicObject("reffieldentry");
                if (refCalculateField.getGroupField().booleanValue()) {
                    refCalculateFieldDy.set("reftype", (Object)"groupfield");
                    refCalculateFieldDy.set("reffieldalias", (Object)refCalculateField.getFieldNumber());
                    DynamicObject fieldDy = fieldDyMap.get(Long.valueOf(calField.getId()));
                    DynamicObjectCollection refFieldDys = fieldDy.getDynamicObjectCollection("reffieldentry");
                    refFieldDys.add((Object)refCalculateFieldDy);
                    continue;
                }
                refCalculateFieldDy.set("reftype", (Object)"calfield");
                String refAggregation = (String)aggregationMap.get(refCalculateField.getFieldNumber());
                if (HRStringUtils.isNotEmpty((String)refAggregation)) {
                    refCalculateFieldDy.set("aggregation", (Object)refAggregation);
                }
                if ((refId = HRStringUtils.isNotEmpty((String)refCalculateField.getId()) ? Long.valueOf(Long.parseLong(refCalculateField.getId())) : (Long)numberToIdMap.get(refCalculateField.getFieldNumber())) == 0L) continue;
                refCalculateFieldDy.set("refcalfield", (Object)refId);
                DynamicObject fieldDy = fieldDyMap.get(Long.valueOf(calField.getId()));
                DynamicObjectCollection refFieldDys = fieldDy.getDynamicObjectCollection("reffieldentry");
                refFieldDys.add((Object)refCalculateFieldDy);
            }
        }
        calFieldHelper.delete(deleteIds.toArray(new Object[0]));
        calFieldHelper.save(calFieldCol);
    }

    private List<CalculateFieldBo> assembleCalFieldsForAnObj(DynamicObject[] calFields, boolean queryRefDimCount) {
        return this.assembleCalFields(calFields, null, Lists.newArrayListWithCapacity((int)10), Lists.newArrayListWithCapacity((int)10), queryRefDimCount);
    }

    private List<CalculateFieldBo> assembleCalFieldsForReport(DynamicObject[] calFields, List<CalculateFieldBo> anObjCalFieldBos, List<QueryFieldBo> queryFields, List<AnObjGroupField> groupFields) {
        return this.assembleCalFields(calFields, anObjCalFieldBos, queryFields, groupFields, false);
    }

    private List<CalculateFieldBo> assembleCalFields(DynamicObject[] calFields, List<CalculateFieldBo> anObjCalFieldBos, List<QueryFieldBo> queryFields, List<AnObjGroupField> groupFields, boolean queryRefDimCount) {
        if (calFields == null || calFields.length == 0) {
            return Lists.newArrayListWithExpectedSize((int)16);
        }
        ArrayList calculateFieldBoList = Lists.newArrayListWithCapacity((int)10);
        for (DynamicObject calFieldDy : calFields) {
            calculateFieldBoList.add(this.assembleCalFieldBo(calFieldDy));
        }
        Map<String, CalculateFieldBo> calFieldMap = calculateFieldBoList.stream().collect(Collectors.toMap(CalculateFieldBo::getId, bo -> bo));
        if (anObjCalFieldBos != null && !anObjCalFieldBos.isEmpty()) {
            calFieldMap.putAll(anObjCalFieldBos.stream().collect(Collectors.toMap(CalculateFieldBo::getId, bo -> bo)));
        }
        for (DynamicObject calFieldDy : calFields) {
            this.assembleCalFieldRefCalField(calFieldDy, calFieldMap, queryFields, groupFields);
        }
        if (queryRefDimCount) {
            Set<String> refEntityFieldAliasSet = calculateFieldBoList.stream().flatMap(field -> field.getRefEntityFields().stream()).collect(Collectors.toSet());
            HashMap fieldAliasToDimCountMap = Maps.newHashMapWithExpectedSize((int)16);
            if (!refEntityFieldAliasSet.isEmpty()) {
                DynamicObjectCollection fieldCol = AnalyseObjectService.getInstance().queryFieldDimCount(Long.valueOf(((CalculateFieldBo)calculateFieldBoList.get(0)).getAnObjId()), refEntityFieldAliasSet);
                for (DynamicObject fieldDy : fieldCol) {
                    String fieldAlias = fieldDy.getString("fieldalias");
                    boolean isBigDataTable = fieldDy.getBoolean("dimcount.isbigdatatable");
                    if (isBigDataTable) {
                        fieldAliasToDimCountMap.put(fieldAlias, Integer.MAX_VALUE);
                        continue;
                    }
                    fieldAliasToDimCountMap.put(fieldAlias, fieldDy.getInt("dimcount.dimcount"));
                }
            }
            for (CalculateFieldBo calculateFieldBo : calculateFieldBoList) {
                int calFieldDimCount = this.getCalFieldDimCount(calculateFieldBo, fieldAliasToDimCountMap);
                calculateFieldBo.setDimCount(Integer.valueOf(calFieldDimCount));
            }
        }
        return calculateFieldBoList.stream().sorted(Comparator.comparing(CalculateFieldBo::getIndex)).collect(Collectors.toList());
    }

    private int getCalFieldDimCount(CalculateFieldBo calculateFieldBo, Map<String, Integer> fieldAliasToDimCountMap) {
        String valueType = calculateFieldBo.getValueType();
        if (this.isDimCalculateField(valueType)) {
            if (calculateFieldBo.getDimCount() > 0) {
                return calculateFieldBo.getDimCount();
            }
            List refEntityFields = calculateFieldBo.getRefEntityFields();
            long resultCount = 1L;
            for (String refEntityField : refEntityFields) {
                Integer dimCount = fieldAliasToDimCountMap.get(refEntityField);
                if (dimCount == null || dimCount <= 0) continue;
                resultCount *= (long)dimCount.intValue();
            }
            List refCalculateFields = calculateFieldBo.getRefCalculateFields();
            for (CalculateFieldBo refCalculateField : refCalculateFields) {
                int refCalFieldDimCount = this.getCalFieldDimCount(refCalculateField, fieldAliasToDimCountMap);
                if (refCalFieldDimCount <= 0) continue;
                resultCount *= (long)refCalFieldDimCount;
            }
            return resultCount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)resultCount;
        }
        return 0;
    }

    private boolean isDimCalculateField(String valueType) {
        DataTypeEnum fieldValueType = DataTypeEnum.of((String)valueType);
        return DataTypeEnum.INTEGER != fieldValueType && DataTypeEnum.LONG != fieldValueType && DataTypeEnum.BIGDECIMAL != fieldValueType;
    }

    private void assembleCalFieldRefCalField(DynamicObject calFieldDy, Map<String, CalculateFieldBo> calFieldMap, List<QueryFieldBo> queryFields, List<AnObjGroupField> groupFields) {
        String calId = calFieldDy.getString("id");
        String calFieldNumber = calFieldDy.getString("number");
        DynamicObjectCollection refFieldEntry = calFieldDy.getDynamicObjectCollection("reffieldentry");
        ArrayList refCalculateFields = Lists.newArrayListWithCapacity((int)10);
        Map groupFieldMap = groupFields.stream().collect(Collectors.toMap(AnObjGroupField::getNumber, Function.identity()));
        for (DynamicObject refFieldDy : refFieldEntry) {
            String refType = refFieldDy.getString("reftype");
            if (HRStringUtils.equals((String)refType, (String)"calfield")) {
                DynamicObject refCalFieldDy = refFieldDy.getDynamicObject("refcalfield");
                if (refCalFieldDy == null) {
                    String tips = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8ba1\u7b97\u5b57\u6bb5%s\u7684\u5f15\u7528\u5b57\u6bb5\u8bbe\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u521b\u5efa\u8be5\u8ba1\u7b97\u5b57\u6bb5\u3002", (String)"CalculateFieldService_2", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), calFieldNumber);
                    LOGGER.error(tips);
                    continue;
                }
                String refCalId = refCalFieldDy.getString("id");
                refCalculateFields.add(calFieldMap.get(refCalId));
                continue;
            }
            if (!HRStringUtils.equals((String)refType, (String)"groupfield")) continue;
            AnObjGroupField groupField = (AnObjGroupField)groupFieldMap.get(refFieldDy.getString("reffieldalias"));
            CalculateFieldBo calculateFieldBo = AnObjGroupFieldService.getInstance().transferGroupField(new ArrayList<CalculateFieldBo>(calFieldMap.values()), queryFields, groupField);
            refCalculateFields.add(calculateFieldBo);
        }
        CalculateFieldBo calculateFieldBo = calFieldMap.get(calId);
        calculateFieldBo.setRefCalculateFields((List)refCalculateFields);
    }

    private CalculateFieldBo assembleCalFieldBo(DynamicObject calFieldDy) {
        CalculateFieldBo calField = new CalculateFieldBo(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)((OrmLocaleValue)calFieldDy.getLocaleString("name"))), calFieldDy.getString("number"));
        calField.setId(calFieldDy.getString("id"));
        calField.setIndex(Integer.valueOf(calFieldDy.getInt("index")));
        calField.setExpr(calFieldDy.getString("expr"));
        calField.setViewExpr(calFieldDy.getString("viewexpr"));
        calField.setType(calFieldDy.getString("type"));
        calField.setOrder(Integer.valueOf(calFieldDy.getInt("order")));
        calField.setValueType(calFieldDy.getString("valuetype"));
        calField.setControlType(calFieldDy.getString("controltype"));
        calField.setSelected(Boolean.valueOf(calFieldDy.getBoolean("isselected")));
        String calMethod = calFieldDy.getString("calmethod");
        if (HRStringUtils.isEmpty((String)calMethod)) {
            calMethod = "normal";
        }
        calField.setCalMethod(calMethod);
        calField.setHideField(calFieldDy.getBoolean("hidefield"));
        String source = calFieldDy.getString("source");
        calField.setSource(source);
        if (HRStringUtils.equals((String)source, (String)"anobj")) {
            calField.setAnObjId(calFieldDy.getDynamicObject("anobj").getString("id"));
        } else {
            calField.setReportId(calFieldDy.getDynamicObject("report").getString("id"));
        }
        DynamicObjectCollection refFieldEntry = calFieldDy.getDynamicObjectCollection("reffieldentry");
        ArrayList refEntityFields = Lists.newArrayListWithCapacity((int)10);
        ArrayList refPreIndexFields = Lists.newArrayListWithCapacity((int)10);
        HashMap aggregationMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject refFieldDy : refFieldEntry) {
            String refType = refFieldDy.getString("reftype");
            String fieldAlias = "";
            if (HRStringUtils.equals((String)refType, (String)"entityfield")) {
                fieldAlias = refFieldDy.getString("reffieldalias");
                if (refEntityFields.contains(fieldAlias)) continue;
                refEntityFields.add(fieldAlias);
            } else if (HRStringUtils.equals((String)refType, (String)"preindex")) {
                DynamicObject refPreIndexDy = refFieldDy.getDynamicObject("refpreindex");
                PreIndexBo indexBo = new PreIndexBo();
                indexBo.setId(refPreIndexDy.getString("id"));
                indexBo.setFieldName(refPreIndexDy.getLocaleString("name").getLocaleValue());
                fieldAlias = refFieldDy.getString("reffieldalias");
                if (HRStringUtils.isEmpty((String)fieldAlias)) {
                    indexBo.setFieldNumber(refPreIndexDy.getString("number"));
                } else {
                    indexBo.setFieldNumber(fieldAlias);
                }
                refPreIndexFields.add(indexBo);
            } else if (HRStringUtils.equals((String)refType, (String)"calfield")) {
                DynamicObject refCalculateField = refFieldDy.getDynamicObject("refcalfield");
                fieldAlias = refCalculateField.getString("number");
            } else if (HRStringUtils.equals((String)refType, (String)"groupfield")) {
                fieldAlias = refFieldDy.getString("reffieldalias");
            }
            String aggregation = refFieldDy.getString("aggregation");
            aggregationMap.put(fieldAlias, HRStringUtils.isEmpty((String)aggregation) ? "sum" : aggregation);
        }
        calField.setRefEntityFields((List)refEntityFields);
        calField.setRefPreIndexes((List)refPreIndexFields);
        calField.setAggregationMap((Map)aggregationMap);
        return calField;
    }
}

